<?php
/* これは文字化け防止のための日本語文字列です。
   Above is a Japanese strings to avoid charset mis-understanding.*/

/* ==================================================
 *   Ktai Template Tags
     version 0.81
   ================================================== */

add_filter('the_title', '_shrink_title');
add_filter('the_content', '_shrink_content');
add_filter('get_comment_text', '_shrink_content');
add_filter('post_link', '_strip_host');
add_filter('wp_list_categories', '_strip_properties');
add_filter('comments_template', '_ks_comments_template');

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_header() {
	Ktai_Style::get_header();
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_footer() {
	Ktai_Style::get_footer();
	return;
}

/* ==================================================
 * @param	string  $permalink
 * @return	string  $permalink
 */
function _strip_host($permalink = '') {
	return preg_replace('#^https?://[^/]*/?#', '/', $permalink);
}

/* ==================================================
 * @param	string  $output
 * @return	string  $output
 */
function _strip_properties($output) {
	$short_url = _strip_host(get_bloginfo('url'));
	$output = preg_replace('#href=([\'"])' . preg_quote(get_bloginfo('url')) . '#', 'href=\\1' . $short_url, $output);
	$output = preg_replace('#(<\\w.*?) title=([\'"]).*?\\2(.*?>)#', '\\1\\3', $output);
	$output = preg_replace('/^\\s+/m', '', $output);
	$output = preg_replace('#[\r\n]+</#s', '</', $output);
	return $output;
}

/* ==================================================
 * @param	string $content
 * @return	string $content
 */
function _strip_links($content) {
	$short_url   = _strip_host(get_bloginfo('url'));
	$short_wpurl = _strip_host(get_bloginfo('wpurl'));
	$internal = array('#^' . preg_quote($short_url) . '#', 
	                  '#^' . preg_quote($short_wpurl) . '#', 
	                  '#^' . preg_quote(get_bloginfo('url')) . '#', 
	                  '#^' . preg_quote(get_bloginfo('wpurl')) . '#');
	$converted = array($short_url, $short_wpurl, $short_url, $short_wpurl);
	if (preg_match_all('#<a (.*?)>(.*?)</a>#', $content, $links, PREG_SET_ORDER)) {
		foreach ($links as $l) {
			if (preg_match('#^<img.*?/? ?>#', $l[2])) {
				$content = str_replace($l[0], $l[2], $content);
			} else {
				preg_match('/href=[\'"](.*?)[\'"]/', $l[1], $href);
				$link = preg_replace($internal, $converted, $href[1], 1, $is_internal);
				if ($is_internal) {
					$content = str_replace($l[0], '<a href="' . $link . '">' . $l[2] . '</a>', $content);
				} else {
					$content = str_replace($l[0], $l[2], $content);
				}
			}
		}
	}
	return $content;
}

/* ==================================================
 * @param	string $title
 * @param	string $before
 * @param	string $after
 * @return	string $title
 */
function _shrink_title($title, $before = '', $after = '') {
	$protected_text = str_replace('%s', '', __('Protected: %s'));
	return preg_replace('/^' . preg_quote("$before$protected_text") . '/', $before . '<img localsrc="279" alt="' . $protected_text . '" />', $title);
}

/* ==================================================
 * @param	string $content
 * @return	string $content
 */
function _shrink_content($content) {
	$content = _strip_links($content);
	$content = preg_replace('#^\\s*<(script|style)>[.\\r\\n]*?</\1>\\s*#m', '', $content);
	$content = preg_replace('#^\\s*<div class="locationurl">.*?</div>#ms', '', $content);
	$content = preg_replace('#<div class="[-_ a-zA-Z0-9]*">\\s*?</div>\\s*#', '', $content);
	$content = preg_replace('#<img .*?src=[\'"](.*?)[\'"] alt=[\'"](.*?)[\'"].*?>#', '[<a href="\\1"><img localsrc="94" alt="IMAGE:">\\2</a>]', $content);
	return $content;
}

/* ==================================================
 * @param	int    $more_link_text
 * @param   int    $stripteaser
 * @param   int    $more_file
 * @return	string $output
 * based on get_the_content() at post-template.php of WP 2.2.3
 */
function _ks_get_content($more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {
	global $id, $post, $more, $single, $withcomments, $page, $pages, $multipage, $numpages;
	global $pagenow;
	$output = '';

	$need_password = ks_check_password();
	if ($need_password) {
		return $need_password;
	}

	if ( $more_file != '' )
		$file = $more_file;
	else
		$file = $pagenow; //$_SERVER['PHP_SELF'];

	if ( $page > count($pages) ) // if the requested page doesn't exist
		$page = count($pages); // give them the highest numbered page that DOES exist

	$content = $pages[$page-1];
	if ( preg_match('/<!--more(.*?)?-->/', $content, $matches) ) {
		$content = explode($matches[0], $content, 2);
		if ( !empty($matches[1]) && !empty($more_link_text) )
			$more_link_text = strip_tags(wp_kses_no_null(trim($matches[1])));
	} else {
		$content = array($content);
	}
	if ( (false !== strpos($post->post_content, '<!--noteaser-->') && ((!$multipage) || ($page==1))) )
		$stripteaser = 1;
	$teaser = $content[0];
	if ( ($more) && ($stripteaser) )
		$teaser = '';
	$output .= $teaser;
	if ( count($content) > 1 ) {
		if ( $more ) {
			$output .= '<span id="more-'.$id.'"></span>'.$content[1];
		} else {
			$output = balanceTags($output);
			if ( ! empty($more_link_text) )
				$output .= ' <a href="'. get_permalink() . "#more-$id\">$more_link_text</a>";
		}
	}

	return $output;
}

/* ==================================================
 * @param	none
 * @return	boolean $password_is_ok
 */
function _ks_confirmed_post_password() {
	global $post;
	if (empty($post->post_password)) {
		return TRUE;
	}
	return (stripslashes($_POST['post_password']) == $post->post_password);
}

/* ==================================================
 * @param	string  $path
 * @return	string  $path
 */
function _ks_comments_template($path) {
	return str_replace(TEMPLATEPATH . '/', Ktai_Style::$template_dir, $path);
}

/* ==================================================
 * @param	none
 * @return	boolean $is_front
 */
function ks_is_front() {
	global $paged;
	return (is_home() && intval($paged) < 2);
}

/* ==================================================
 * @param	none
 * @return	boolean $is_comments_list
 */
function ks_is_comments_list() {
	if (isset($_GET['view']) && $_GET['view'] == 'co_list') {
		return TRUE;
	} elseif (isset($_POST['view']) && $_POST['view'] == 'co_list') {
		return TRUE;
	}
	return FALSE;	
}

/* ==================================================
 * @param	none
 * @return	boolean $is_comment_post
 */
function ks_is_comment_post() {
	if (isset($_GET['view']) && $_GET['view'] == 'co_post') {
		return TRUE;
	} elseif (isset($_POST['view']) && $_POST['view'] == 'co_post') {
		return TRUE;
	}
	return FALSE;	
}

/* ==================================================
 * @param	none
 * @return	boolean $is_comments
 */
function ks_is_comments() {
	return (ks_is_comments_list() || ks_is_comment_post());
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_blogurl() {
	echo _strip_host(get_bloginfo('url') . '/');
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_siteurl() {
	echo _strip_host(get_bloginfo('wpurl') . '/');
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_plugin_dir() {
	echo ks_siteurl() . Ktai_Style::$plugin_dir;
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_title() {
	$title = wp_title('', FALSE); 
	if (empty($title)) {
		$title = get_bloginfo('name');
	}
	echo $title;
	return $title;
}

/* ==================================================
 * @param	int    $more_link_text
 * @param   int    $stripteaser
 * @param   int    $more_file
 * @return	none
 * based on the_content() at post-template.php of WP 2.2.3
 */
function ks_content($more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {
	$content = _ks_get_content($more_link_text, $stripteaser, $more_file);
	$content = apply_filters('the_content', $content);
	$content = str_replace(']]>', ']]&gt;', $content);
	echo $content;
}

/* ==================================================
 * @param	none
 * @return	none
 * based on get_the_content and get_the_password_form() at post-template.php of WP 2.2.3
 */
function ks_check_password($message = '') {
	if (empty($message)) {
		$message = __("This post is password protected. To view it please enter your password below:");
	}
	if (_ks_confirmed_post_password()) {
		return NULL;
	} else {
		$form = '<form method="post" action="">
<p>' . $message . '</p>
<p><input name="post_password" type="password" size="20" />';
		if (isset($_GET['view']) && ($_GET['view'] == 'co_list' || $_GET['view'] == 'co_post')) {
			$form .= '<input type="hidden" name="view" value="' . $_GET['view'] . '" />';
		}
		$form .= '<input type="submit" name="Submit" value="' . __("Submit") . '" /></p>
</form>';
		return $form;
	}
}

/* ==================================================
 * @param	int    $count
 * @param   int    $max
 * @return	none
 */
function ks_orderd_link($count, $max = 9, $link) {
	$accesskey = '';
	if (is_numeric($count)) {
		if ($count > 0 && $count <= $max) {
			$accesskey = ' accesskey="' . intval($count) . '"';
			$num = intval(179 + $count);
			$output = '<img localsrc="' . $num . '" alt="' . $count . '." />';
		} else { 
			$output = '□';
		}
	} else {
		$output = '';
	}
	echo '<a href="' . $link . '"' . $accesskey . '>' . $output;
}

/* ==================================================
 * @param	string $before
 * @param	string $after
 * @return	none
 */
function ks_pagenum($before = ' (', $after = ')') {
	global $paged, $wp_query;
	if (! $paged) {
		$paged = 1;
	}
	$max_page = $wp_query->max_num_pages;
	if ($wp_query->max_num_pages > 1) {
		echo "$before$paged/$max_page$after";
	}
}

/* ==================================================
 * @param	string  $format
 * @param	string  $link
 * @param	boolean $in_same_cat
 * @param	string  $excluded_categories
 * @return	none
 * based on previous_post_link() at link-template.php of WP 2.2.3
 */
function ks_previous_post_link($format='<img localsrc="7" alt="&laquo;">*.%link', $link='%title', $in_same_cat = false, $excluded_categories = '') {

	if ( is_attachment() )
		$post = & get_post($GLOBALS['post']->post_parent);
	else
		$post = get_previous_post($in_same_cat, $excluded_categories);

	if ( !$post )
		return;

	$title = apply_filters('the_title', $post->post_title, $post);
	$string = '<a href="'.get_permalink($post->ID).'" accesskey="*">';
	$link = str_replace('%title', $title, $link);
	$link = $pre . $string . $link . '</a>';

	$format = str_replace('%link', $link, $format);

	echo $format;
}

/* ==================================================
 * @param	string  $format
 * @param	string  $link
 * @param	boolean $in_same_cat
 * @param	string  $excluded_categories
 * @return	none
 * based on next_post_link() at link-template.php of WP 2.2.3
 */
function ks_next_post_link($format='#.%link<img localsrc="8" alt="&raquo;">', $link='%title', $in_same_cat = false, $excluded_categories = '') {
	$post = get_next_post($in_same_cat, $excluded_categories);

	if ( !$post )
		return;

	$title = apply_filters('the_title', $post->post_title, $post);
	$string = '<a href="'.get_permalink($post->ID).'" accesskey="#">';
	$link = str_replace('%title', $title, $link);
	$link = $string . $link . '</a>';
	$format = str_replace('%link', $link, $format);

	echo $format;
}

/* ==================================================
 * @param	string  $label
 * @return	none
 * based on previous_posts_link() at link-template.php of WP 2.2.3
 */
function ks_previous_posts_link($label = '<img localsrc="7" alt="&laquo;">*.前') {
	global $paged;
	if ( (!is_single())	&& ($paged > 1) ) {
		echo '<a href="' . _strip_host(clean_url(get_previous_posts_page_link()));
		echo '" accesskey="*">'. preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $label) .'</a>';
	}
}

/* ==================================================
 * @param	string  $label
 * @param   int     $max_page
 * @return	none
 * based on next_posts_link() at link-template.php of WP 2.2.3
 */
function ks_next_posts_link($label = '#.次<img localsrc="8" alt="&raquo;">', $max_page=0) {
	global $paged, $wpdb, $wp_query;
	if ( !$max_page ) {
		$max_page = $wp_query->max_num_pages;
	}
	if ( !$paged )
		$paged = 1;
	$nextpage = intval($paged) + 1;
	if ( (! is_single()) && (empty($paged) || $nextpage <= $max_page) ) {
		echo '<a href="' . _strip_host(clean_url(get_next_posts_page_link($max_page))) . '" accesskey="#">'. preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $label) .'</a>';
	}
}

/* ==================================================
 * @param	string  $sep
 * @return	none
 */
function ks_posts_nav_link($sep = ' | ') {
	global $wp_query;
	if ( !is_singular() ) {
		$max_num_pages = $wp_query->max_num_pages;
		$paged = get_query_var('paged');

		//only have sep if there's both prev and next results
		if ($paged < 2 || $paged >= $max_num_pages) {
			$sep = '';
		}

		if ( $max_num_pages > 1 ) {
			ks_previous_posts_link();
			echo preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $sep);
			ks_next_posts_link();
		}
	}
}

/* ==================================================
 * @param	string $zero
 * @param	string $one
 * @param	string $more
 * @param	string $none
 * @return	string $output
 * based on comments_popup_link() at comment-template.php
 */
function ks_comments_link($icon = '<img localsrc="86" alt="" />', $zero='コメントなし', $one='コメント1件', $more='コメント%件') {
	global $id, $post, $wpdb;
	if (is_page() ) {
		return;
	}
	$number = get_comments_number($id);
	if ( 0 == $number && 'closed' == $post->comment_status && 'closed' == $post->ping_status ) {
		echo '<img localsrc="61" alt="×" />' . $none;
		return;
	}

	$co_link = _strip_host(get_permalink());
	if (strpos($co_link, '?') === FALSE) {
		$co_link .= '?view=co_list">';
	} else {
		$co_link .= '&view=co_list">';
	}
	if ( !empty($post->post_password) ) { // if there's a password
		if (_ks_confirmed_post_password()) {
			echo '<form method="post" action="' . $co_link . $icon . '<input type="hidden" name="post_password" value="' . htmlspecialchars($post->post_password, ENT_QUOTES) . '" /><input type="submit" name="submit" value="';
			comments_number($zero, $one, $more);
			echo '" /></form>';
		} else {
			echo $icon . '<a href="' . $co_link . 'コメントを見る(要パスワード)</a>';
			return;
		}
	} elseif ($number == 0) {
		echo $icon . $zero;
	} else {
		echo $icon . '<a href="' . $co_link;
		comments_number($zero, $one, $more);
		echo '</a>';
	}
}

/* ==================================================
 * @param	none
 * based on comments_popup_link() at comment-template.php
 */
function ks_comments_post_link($before = '<img localsrc="149" alt="" />', $after = '', $link = 'コメント投稿') {
	if (comments_open()) {
		global $post;
		$co_post = _strip_host(get_permalink());
		if (strpos($co_post, '?') === FALSE) {
			$co_post .= '?view=co_post">';
		} else {
			$co_post .= '&view=co_post">';
		}
		if (! empty($post->post_password) && _ks_confirmed_post_password()) {
			echo '<form method="post" action="' . $co_post . $before . '<input type="hidden" name="post_password" value="' . htmlspecialchars($post->post_password, ENT_QUOTES) . '" /><input type="submit" name="submit" value="' . $link . '" /></form>' . $after;
		} else {
			echo $before . '<a href="' . $co_post . $link . '</a>' . $after;
		}
	}
}

/* ==================================================
 * @param	string $separator
 * @return	none
 */
function ks_category($separator = ', ') {
	$categories = get_the_category();
	if (count($categories)) {
		$cat_links = array();
		foreach ($categories as $c) {
			$cat_links[] = '<a href="' . get_category_link($c->cat_ID) . '">' . wp_specialchars($c->cat_name) . '</a>';
		}
		echo implode($separator, $cat_links);
	}
	return;
}

/* ==================================================
 * @param	string  $args
 * @return	none
 */
function ks_get_archives($args) {
	ob_start();
	wp_get_archives($args);
	$output = ob_get_contents();
	ob_end_clean();
	echo _strip_properties($output);
	return;
}

/* ==================================================
 * @param	string  $sep
 * @return	none
 */
function ks_pages_menu($sep = ' | ', $before = '', $after = '') {
	$r = array('depth' => 0, 'child_of' => 0, 'exclude' => '', 'authors' => '', 'sort_column' => 'menu_order, ID');
	$pages = get_pages($r);
	$menu = array();
	if (count($pages)) {
		foreach ($pages as $p) {
			$menu[] = '<a href="' . _strip_host(get_page_link($p->ID)) . '">' . wp_specialchars($p->post_title) . '</a>';
		}
		echo $before . implode($sep, $menu) . $after;
	}
	return;
}

?>
