<?php
/*
Plugin Name: wp-tmkm-amazon
Plugin URI: http://tomokame.moo.jp/
Description: ASIN を指定して Amazon から個別商品の情報を取出します。BOOKS, DVD, CD は詳細情報を取り出せます。
Author: ともかめ
Version: 0.81j
Author URI: http://tomokame.moo.jp/
Special Thanks: Keith Devens.com (http://keithdevens.com/software/phpxml)
Special Thanks: websitepublisher.net (http://www.websitepublisher.net/article/aws-php/)
Special Thanks: hiromasa.zone :o) (http://hiromasa.zone.ne.jp/)
Special Thanks: PEAR :: Package :: Cache_Lite (http://pear.php.net/package/Cache_Lite)
*/

/********** Notes
 # ECS4.0 に対応しています。
 # PHP4.x で動作します。ただし Keith Devens.com の PHP XML Library が必要。
 # [tmkm-amazon]ASIN[/tmkm-amazon] または <?php tmkm_amazon_view('ASIN'); ?> という記述で動作します。
 # LGPL で提供されている Lite.php および Open Source License で提供されている xml.php を同梱しています。
**********/

/********** Usage
 # 1. ダウンロードした zip ファイルを解凍します。
 # 2. wp-tmkm-amazon.php の 316 行目 tomokametei-22 を、ご自身のアフィリエイト ID に書き換えます。
 # 3. 同梱の tmkm-amazon.css の記述を、お使いのテーマの CSS ファイルに追記します。
 # 4. wp-tmkm-amazon フォルダを wp-content/plugins フォルダに転送します。
 # 5. 管理画面から wp-tmkm-amazon を有効化します。
 # 6. 各テーマの php ファイル、もしくは記事本文中に以下を記載します。
 ## PHP 関数として呼び出す場合	...	<?php tmkm_amazon_view('ASIN'); ?>　：テーマファイルに記述
 ## 記事本文中にコードを書く場合	...	[tmkm-amazon]ASIN[/tmkm-amazon]
 ## 記事本文中で PHP コードを実行できるプラグインを導入していれば、PHP 関数として呼び出すこともできます。
 ## ASIN はご自分で調べたものを使ってください。
**********/

$wpTmkmAmazonView = & new WpTmkmAmazonView();
$wpTmkmAmazonList = & new WpTmkmAmazonList();
add_filter('the_content', array(&$wpTmkmAmazonView, '_replacestrings'));


class WpTmkmAmazonView {

	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */

	function WpTmkmAmazonView() {

		$this->makedetailview = & new MakeAmazonHtml();

	}

	/**
	 * 記事本文中のコードを個別商品表示 HTML に置き換える
	 * 
	 * @param $content
	 * @return $transformedstring
	 */
	function _replacestrings($content) { // 記事本文中の呼び出しコードを変換

		global $post;

//		$poststring = '/\[tmkm-amazon type\=([a-z]+)\]([a-zA-Z0-9,]+)\[\/tmkm-amazon\]/';
		$poststring = '/\[tmkm-amazon\]([a-zA-Z0-9,]+)\[\/tmkm-amazon\]/';
		$transformedstring = $content;
		if( preg_match_all($poststring, $content, $regs1) ) {

			for ($i=0; $i<count($regs1[0]); $i++) {
//				$type = $regs1[1][$i];
				$SearchString = $regs1[1][$i];

//				$display = $this->makedetailview->format_amazon( $SearchString, $type );
				$display = $this->makedetailview->format_amazon( $SearchString, 'detail' );

				if( ereg( $SearchString, $regs1[0][$i], $str ) ) { // ASINコードの置換
					$transformedstring = str_replace($regs1[0][$i], $display, $transformedstring);
				}
			}
		}

		return $transformedstring;

	}


	/**
	 * PHP 関数として Amazon の個別商品 HTML を呼び出す
	 * 
	 * @param $SearchString ( ASIN )
	 * @param $type ( book / dvd / cd )
	 * @return echo $display ( HTML )
	 */
	function tmkm_amazon_view($SearchString) { // PHP テ−マファイル中に記述する関数
		$display = $this->makedetailview->format_amazon( $SearchString, 'detail' );
		echo $display;
	}


}


class WpTmkmAmazonList {

	var $sql;
	var $ordersql;

	function WpTmkmAmazonList() {

		$this->makedetailview = & new MakeAmazonHtml();
		$this->sql = '';
		$this->ordersql = '';

	}

	function tmkm_amazon_list( $orderby = 'post_id', $order = 'asc' ) {
	
	    global $wpdb;

		switch( $orderby ) {
			case post_id: $this->ordersql = "$wpdb->posts.ID " . $order; break;
			case post_title: $this->ordersql = "$wpdb->posts.post_title " . $order; break;
			case post_date: $this->ordersql = "$wpdb->posts.post_date " . $order; break;
			case modified_date: $this->ordersql = "$wpdb->posts.post_modified " . $order; break;
		}

	    $this->sql =
			"SELECT " .
				"ID, post_title, " .
				"DATE_FORMAT(post_modified, '%Y/%m/%d') as mdate, " .
				"meta_key, meta_value " .
			"FROM " .
				"$wpdb->posts, $wpdb->postmeta " .
			"WHERE " .
				"$wpdb->posts.ID = $wpdb->postmeta.post_id AND " .
				"$wpdb->posts.post_date <= NOW() AND " .
				"$wpdb->posts.post_status = 'publish' AND " .
				"$wpdb->postmeta.meta_key = 'tmkm-amazon' " .
			"ORDER BY " .
				$this->ordersql;

	    $PostRetainAsin = $wpdb->get_results($this->sql);
	    if( $PostRetainAsin ) {
	    	print '<div id="amazonlist">';
	    	foreach( $PostRetainAsin as $asinlist ) {
	    		$asins = explode(',',$asinlist->meta_value);
	    		foreach( $asins as $asin ) {
	    			$permalink = get_permalink($asinlist->ID);
	    			$display = $this->makedetailview->format_amazon( $asin, 'list' );

	    			$heredoc  = '<dd>';
	    			$heredoc .= $display;
	    			$heredoc .= '<p>このブログの記事：<a href="' . $permalink . '">' . $asinlist->post_title . '</a> ( ' . $asinlist->mdate . ' )</p>';
	    			$heredoc .= '</dd><div style="clear: both"></div>';
	    			echo $heredoc;
	    		}
	    	}
	    	print '</div>';
	    	echo tmkm_clearfloat();
	    }
	}

}

class MakeAmazonHtml {

	function MakeAmazonHtml() {

		$this->amazonparse = & new GetAmazonXmlParse();

	}

	/**
	 * Amazon 商品の HTML ソースを生成
	 * @param $SearchString ( ASIN )
	 * @param $mediatype ( book / dvd / cd )
	 * @return $output ( HTML )
	 */
	function format_amazon( $SearchString, $formattype ) {

		$output = '';

		$AmazonXml = $this->amazonparse->getamazonxml( $SearchString ); // --- Call Amazon XML function ---
/*		echo "<pre>"; // DEBUG
		print_r($AmazonXml);
		echo "</pre>";
*/	
		// --- Get results of the Amazon function ---
		if( false === $AmazonXml ){  // Amazon function was returned false, so AWS is down

			echo '<p>アマゾンのサーバでエラーが起こっているかもしれません。一度ページを再読み込みしてみてください。</p>';

		}else{ // Amazon function returned XML data

			$status = $AmazonXml["ItemLookupResponse"]["Items"]["Request"];

			if( $status["IsValid"] == 'False' ){ // Request is invalid

				echo '<p>与えられたリクエストが正しくありません</p>';

			}else{ // results were found, so display the products
	
		// --- Display the product data returned from the XML ---
				$item = $AmazonXml["ItemLookupResponse"]["Items"]["Item"];

				$mediumimage = $this->amazonparse->get_goods_image($item,'medium');
				$smallimage = $this->amazonparse->get_goods_image($item,'small');

				$url = $this->amazonparse->get_amazon_text($item,'url');
				$Title = $this->amazonparse->get_amazon_text($item,'title');
				$Manufacturer = $this->amazonparse->get_amazon_text($item,'manufacturer');
				$Binding = $this->amazonparse->get_amazon_text($item,'binding');
				$EANcode = $this->amazonparse->get_amazon_text($item,'eancode');

				$Price = $this->amazonparse->get_amazon_text($item,'price');
				$ASIN = $this->amazonparse->get_amazon_text($item,'asincode');
				$ReleaseDate = $this->amazonparse->get_amazon_text($item,'releasedate');

				$ProductGroup = $this->amazonparse->get_amazon_text($item,'productgroup');


				if( $formattype == 'detail' ) {
					if( $ProductGroup == 'Book' ){
	
						$Role = $this->amazonparse->get_amazon_text($item,'role');
						$Author = $this->amazonparse->get_amazon_text($item,'author');
						$ISBN10 = $this->amazonparse->get_amazon_text($item,'isbn10');
						$PublicationDate = $this->amazonparse->get_amazon_text($item,'publicationdate');
	
						$output = '<a href="'.$url.'"><img src="' . $mediumimage . '" border="0" alt="" class="icon_left" /></a></p>';
						$output .= '<p><a href="'.$url.'">' . $Title . "</a>";
						if( $Author != "" ) {
							$output .= "<br /><em>著者／訳者：</em>";
							if( count($Author) == 1 ) { $output .= $Author; 
							} else { foreach($Author as $auth){ $output .= $auth.' '; } } }
						$output .= "<br /><em>出版社：</em>$Manufacturer( $PublicationDate )";
						$output .= "<br /><em>定価：</em>$Price";
						$output .= "<br />$Binding";
						$output .= "<br />ISBN-10 : $ISBN10";
						$output .= "<br />ISBN-13 : $EANcode";
	
					} elseif( $ProductGroup == 'DVD' ) {
	
						$RunningTime = $this->amazonparse->get_amazon_text($item,'runningtime');
						$numofdisc = $this->amazonparse->get_amazon_text($item,'numofdisc');
	
						$output = '<a href="'.$url.'"><img src="' . $mediumimage . '" border="0" alt="" class="icon_left" /></a></p>';
						$output .= '<p><a href="'.$url.'">' . $Title . "</a>";
						$output .= "<br /><em>販売元：</em>$Manufacturer( $ReleaseDate )";
						$output .= "<br /><em>定価：</em>$Price";
						$output .= "<br /><em>時間：</em>$RunningTime 分";
						$output .= "<br />$numofdisc" . " 枚組 ( " . $Binding . " )";
						$output .= "<br />ASIN : $ASIN";
						$output .= "<br />JAN コード : $EANcode";
	
					} elseif( $ProductGroup == 'Music' ) {
	
						$Format = $this->amazonparse->get_amazon_text($item,'format');
						$Artist = $this->amazonparse->get_amazon_text($item,'artist');
	
						$output = '<a href="'.$url.'"><img src="' . $smallimage . '" border="0" alt="" class="icon_left" /></a></p>';
						$output .= '<p><a href="'.$url.'">' . $Title . ' / ' . $Artist . "</a> / $Format $Binding ( $ProductGroup )";
						$output .= "<br />$Manufacturer";
						$output .= "<br /><em>定価：</em>$Price ( $ReleaseDate )";
						$output .= "<br />ASIN : $ASIN ( JAN コード : $EANcode )";
	
					} else {
						$output = '<a href="'.$url.'">' . $smallimage . '</a>';
						$output .= '<p><a href="'.$url.'">' . $Title . "</a>";
						if( $Price != '' ) { $output .= "<br /><em>定価：</em>$Price"; }
						if( $ReleaseDate != '' ) { $output .= "<br /><em>発売日：</em>$ReleaseDate"; }
						$output .= "<br />ASIN : $ASIN";
						if( $EANcode != '' ) { $output .= "<br />JAN コード : $EANcode"; }
					}
					$clearparts = '</p><p style=”clear: both”>';
					$output .= $clearparts;

				} elseif( $formattype == 'list' ) {
					$output = '<a href="'.$url.'"><img src="' . $smallimage . '" border="0" alt="' . $Title . '" class="icon_left" /></a></p>';
					$output .= '<br /><a href="'.$url.'">' . $Title . "</a>";
				}

				return $output;
				
			}
		}
	}

}


class GetAmazonXmlParse {

	var $AssociatesID;
	var $DevToken;
	var $Version;
	var $JPendpoint;
	var $Operation;
	var $ResponseGroup;
	var $PageNum;

	var $plugin_path;
	var $mediumimgfile;
	var $smallimgfile;

	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return Object reference
	 */

	function GetAmazonXmlParse() {

		$this->AssociatesID = 'tomokametei-22';
		$this->DevToken = '10J7BBWBHFNGXM612JR2';
		$this->Version = '2007-01-15';
		$this->JPendpoint = 'http://ecs.amazonaws.jp/onca/xml?Service=AWSECommerceService';
		$this->Operation = 'ItemLookup';
		$this->ResponseGroup = 'Large';
		$this->PageNum = 1; // --- Set Page number  ---

        $this->litephp_path = "Lite.php";
        $this->xmlphp_path = 'xml.php';
        $this->plugin_path  = get_settings('siteurl');
        $this->plugin_path .= '/wp-content/plugins/wp-tmkm-amazon/';
        $this->mediumimgfile = 'amazon_noimg.png';
        $this->smallimgfile = 'amazon_noimg_small.png';

	}

	/**
	 * Get Amazon Image.
	 * 
	 * @param $item (Amazon Xml)
	 * @param $size (Image Size)
	 */
	function get_goods_image($item,$imgsize) {

		if( $imgsize == 'medium' ) {
			$amazon_imgurl = $item["MediumImage"]["URL"];
			if( $amazon_imgurl == '' ) {
				$amazon_imgurl = $this->plugin_path . $this->mediumimgfile;
			}
		} elseif( $imgsize == 'small' ) {
			$amazon_imgurl = $item["SmallImage"]["URL"];
			if( $amazon_imgurl == '' ) {
				$amazon_imgurl = $this->plugin_path . $this->smallimgfile;
			}
		}
		return $amazon_imgurl;
	}


	/**
	 * Get Amazon Text.
	 * 
	 * @param $item (Amazon Xml)
	 * @param $flag (Text Type)
	 */
	function get_amazon_text($item, $flag=''){

		switch ( $flag ) {
			case url: $textdata = $item["DetailPageURL"]; break;
			case title: $textdata = $item["ItemAttributes"]["Title"]; break;
			case manufacturer: $textdata = $item["ItemAttributes"]["Manufacturer"]; break;
			case asincode: $textdata = $item["ASIN"]; break;
			case eancode: $textdata = $item["ItemAttributes"]["EAN"]; break;
			case price: $textdata = $item["ItemAttributes"]["ListPrice"]["FormattedPrice"]; break;
			case releasedate: $textdata = $item["ItemAttributes"]["ReleaseDate"]; break;
			case runningtime: $textdata = $item["ItemAttributes"]["RunningTime"]; break;
			case binding:  $textdata = $item["ItemAttributes"]["Binding"]; break;
			case numofdisc: $textdata = $item["ItemAttributes"]["NumberOfDiscs"]; break;
			case role: $textdata = $item["ItemAttributes"]; break;
			case author: $textdata = $item["ItemAttributes"]["Author"]; break;
			case isbn10: $textdata = $item["ItemAttributes"]["ISBN"]; break;
			case publicationdate: $textdata = $item["ItemAttributes"]["PublicationDate"]; break;
			case format: $textdata = $item["ItemAttributes"]["Format"]; break;
			case artist: $textdata = $item["ItemAttributes"]["Artist"]; break;
			case productgroup: $textdata = $item["ItemAttributes"]["ProductGroup"]; break;

		}

		return $textdata;
	}

	/**
	 * Get ECS XML.
	 * 
	 * @param $SearchString (ASIN)
	 * @param $ResponseGroup (Small / Medium / Large : 情報量)
	 * @param $Page (詳細情報ページ)
	 */
	function getamazonxml( $SearchString ) {
		// --- Build XML Link ---
	
		$xmlFeed  = $this->JPendpoint;
		$xmlFeed .= '&AWSAccessKeyId=' .$this->DevToken;
		$xmlFeed .= '&AssociateTag=' .$this->AssociatesID;
		$xmlFeed .= '&Operation=' .$this->Operation;
		$xmlFeed .= '&ItemId=' .$SearchString;
		$xmlFeed .= '&Version=' .$this->Version;
		$xmlFeed .= '&ResponseGroup=' .$this->ResponseGroup;
		$xmlFeed .= '&page=' .$this->Pagenum. '&f=xml';

//		echo $xmlFeed; // DEBUG
		// --- Include the cache package ---
		// IMPORTANT - enter the path to Lite.php
		require_once( $this->litephp_path );

		// --- Set an ID for this cache ---
		$id = $xmlFeed;

		/**
		* Cache options
		* "lifeTime" is in seconds, so 1 hour would be 60*60*1
		*
		* IMPORTANT - enter the path to your cache directory (a new directory with full permissions)
		*/
		$options = array(
			"cacheDir" => "./cache/",
			"lifeTime" => 60*60*1
			);
		
		$objCache = new Cache_Lite($options);
	
		// Check to see if there is a valid cache of xml
	
		if ($xmlCache = $objCache->get($id)) {  // there is a cache, so parse cached xml
			include_once( $this->xmlphp_path );
			$parsedata = XML_unserialize($xmlCache);
			return $parsedata;
		}else{
			$data = @implode("",file($xmlFeed));

			if(!strpos($data, 'xml')){ // there is no XML data in the string (Amazon's Web Services are down)
				return false;
			} else { // there is XML data, so parse the XML

				include_once( $this->xmlphp_path );
				$parsedata = XML_unserialize($data);
				return $parsedata;

				// --- Cache the XML ---
				$objCache->save($data, $id);
			}
		}
	}
}

if(!function_exists('tmkm_amazon_view')) {
	function tmkm_amazon_view($Searchstring) {
		global $wpTmkmAmazonView;
		$wpTmkmAmazonView->tmkm_amazon_view($Searchstring);
		
	}
}

if(!function_exists('tmkm_amazon_list')) {
	function tmkm_amazon_list($orderby,$order) {
		global $wpTmkmAmazonList;
		$wpTmkmAmazonList->tmkm_amazon_List($orderby,$order);
		
	}
}
?>