<?php
/* ʸɻߤΤܸʸǤ
   (This is a japanese text for detecting th3 correct encoding.) */
   /* wp-shot.php
    *
    * Copyright (c) 2003-2004 The Wordpress Team
    *
    * Copyright (c) 2004 - John B. Hewitt - jb@stcpl.com.au
    * Copyright (c) 2004 - Dan Cech - dcech@lansmash.com
    * Copyright (c) 2006 - Santaro Otsukare - staybymyside [at] gmail.com
    *
    * Licensed under the GNU GPL. For full terms see the file COPYING.
    *
    *
    */

require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';

// Ѥߥ饹ɤ߹
require_once './class-pop3.php';
require_once 'mimeDecode.php';

error_reporting(2037);

$time_difference = get_settings('gmt_offset');

//retrieve mail
$pop3 = new POP3();

if (!$pop3->connect(get_settings('mailserver_url'), get_settings('mailserver_port'))) :
	echo "Ooops $pop3->ERROR <br />\n";
	exit;
endif;

$count = $pop3->apop(get_settings('mailserver_login'), get_settings('mailserver_pass'));
if (0 == $count) die("There doesn't seem to be any new mail.");

for ($i=1; $i <= $count; $i++)
{
	//variables
	$content_type = '';
	$boundary = '';
	$bodysignal = 0;
	
	$input = implode ('',$pop3->get($i));

	//decode the mime
	$params['include_bodies'] = true;
	$params['decode_bodies'] = true;
	$params['decode_headers'] = true;
	$params['input'] = $input;
	$structure = Mail_mimeDecode::decode($params);
	
	// пͥɥ쥹Фȸ
	$from = yn_read_address($structure);
	if (! $from) {
		echo "Error: No sender address found at message #$i.\n";
		continue;
	}
	$post_author = yn_validate_address($from);
	if (is_array($post_author)) {
		echo "Error: Sender address '$from' is not allowd to post at message #$i.\n";
		continue;
	}

	// ̾μФ
	$subject = trim($structure->headers['subject']);
	$subject = mb_convert_encoding($subject, get_settings('blog_charset'), "auto");

	//date reformating
	$post_time_gmt = strtotime(trim($structure->headers['date']));
	if (! $post_time_gmt) {
		echo "Error: There is no Date: field at message #$i.\n";
		continue;
	}
	$post_date = gmdate('Y-m-d H:i:s', $post_time_gmt + ($time_difference * 3600));
	$post_date_gmt = gmdate('Y-m-d H:i:s', $post_time_gmt);

	// ƤμФ
	$content = get_content($structure);

	//filter content
	$search = array (
		'/ (\n|\r\n|\r)/',
		'/(\n|\r\n|\r)/'
	);
	
	$replace = array (
		' ',
		"\n"
	);
	
	// strip extra line breaks
	$content = mb_convert_encoding($content, get_settings('blog_charset'), "auto");
	$content = preg_replace($search,$replace,trim($content));
	//try and determine category
	if ( preg_match('/.*\[(.+)\](.+)/', $subject, $matches) )
	{
		$post_categories[0] = $matches[1];
		$subject = $matches[2];
	}
	
	if (empty($post_categories)) $post_categories[] = get_settings('default_email_category');

	$post_category = $post_categories;
	$post_category = intval($post_category);

	//report
	// print '<p><b>Mail Format</b>: ' . $mailformat . '</p>' . "\n";
	print '<p><b>From</b>: ' . wp_specialchars($from) . '<br />' . "\n";
	print '<b>Date</b>: ' . wp_specialchars($post_date) . '<br />' . "\n";
	print '<b>Date GMT</b>: ' . wp_specialchars($post_date_gmt) . '<br />' . "\n";
	print '<b>Category</b>: ' . wp_specialchars($post_category) . '<br />' . "\n";
	print '<b>Subject</b>: ' . wp_specialchars($subject) . '<br />' . "\n";
	print '<b>Posted content:</b></p><hr />' . wp_specialchars($content) . '<hr />';
	print "--------------------\n";

	// Ϲܤɲ
	// post_name  http://plasticdreams.org/archives/2007/02/01/1639/no-post-slug-please/ 
	$details = array(
		'post_author'		=> $post_author,
		'post_date'		=> $post_date,
		'post_date_gmt'		=> $post_date_gmt,
		'post_content'		=> $content,
		'post_title'		=> $subject,
		'post_modified'		=> $post_date,
		'post_modified_gmt'	=> $post_date_gmt,
		'post_category'		=> $post_categories,
		'post_status'		=> 'publish',
		'post_name'		=> strtolower(preg_replace('/[^%a-zA-Z0-9 _-]/', '', $subject)),
	);

/****** WPΥǡϴؿѹ*/

	$post_ID = wp_insert_post($details);
	do_action('publish_post', $post_ID);
	do_action('publish_phone', $post_ID);

/****** ॢȲ
	pingback($content, $post_ID);

	foreach ($post_categories as $post_category)
	{
		$post_category = intval($post_category);

		// Double check it's not there already
		$exists = $wpdb->get_row("SELECT * FROM $tablepost2cat WHERE post_id = $post_ID AND category_id = $post_category");

		 if (!$exists && $result) { 
			$wpdb->query("
			INSERT INTO $tablepost2cat
			(post_id, category_id)
			VALUES
			($post_ID, $post_category)
			");
		}
	}
*/

	if(! $pop3->delete($i)) {
		echo '<p>Oops '.$pop3->ERROR.'</p></div>';
		$pop3->reset();
		exit;
	} else {
		echo "<p>Mission complete, message <strong>$i</strong> deleted.</p>";
	}

} // end looping over messages

$pop3->quit();

/******** FUNCTIONS **********/

//tear apart the meta part for useful information
// ̤Ƥȿ

function get_content ($part) 
{
	if (get_settings('shot_add_dir')) {

		$photosdir = trailingslashit(get_settings('shot_dir_pass'));
		$link_photosdir = trailingslashit(get_settings('shot_dir_url'));

	} else {

		$cur_dir = wp_upload_dir();
		$photosdir = trailingslashit($cur_dir['path']);
		$link_photosdir = trailingslashit($cur_dir['url']);

	}

	$shot_use_samb = get_settings('shot_make_samb');
	$add_link_rel = ' ' . get_settings('shot_ilink_att');

	if (get_settings('shot_samb_size')) {
		$shot_max_size = get_settings('shot_samb_size');
	} else {
		$shot_max_size = 100;
	}

	// Ǥ
	//$filesdir = "/virtual/hogehoge/public_html/example.jp/wp-filez/";
	//$link_filesdir = get_settings('siteurl') . "/wp-filez/";
	
	switch (strtolower($part->ctype_primary))
	{
		case 'multipart':
			$meta_return = '';
			foreach ($part->parts as $section)
			{
				//$meta_return .= get_content($section);
				$meta_return = get_content($section).$meta_return;
			}
			break;
		case 'text':
			//dump the enriched stuff
			if ($part->ctype_secondary=='enriched') {
				
			} else {
				$meta_return = $part->body;
				
				if($shot_use_samb) {
					$meta_return .= '<br class="shot-clear" />';
				} else {
					$meta_return .= "\n";
				}
			}
			break;
		case 'image':
			$filename = $photosdir . rand() . '.' . $part->ctype_secondary;
			$fp = fopen($filename, 'w');
			fwrite($fp, $part->body);
			fclose($fp);

			$real_file = str_replace($photosdir, '', $filename);

			// ϵʤȤơ֥쥹 & Valid XHTMLǡ
			// С󥢥åפǿΥ쥤Ȼб

			if($shot_use_samb) {
				$thumb = shot_create_thumbnail($filename, $shot_max_size, NULL);
			$real_thumb = str_replace($photosdir, '', $thumb);
				$meta_return = '<a href="' . $link_photosdir . $real_file . '"' . $add_link_rel . '><img src="' . $link_photosdir . $real_thumb . '" alt="' . $part->ctype_parameters['name'] . '" class="shot-float" /></a>';
			} else {
				$meta_return = '<img src="' . $link_photosdir . $real_file . '" alt="' . $part->ctype_parameters['name'] . '" class="shot-image" />';
				$meta_return .= "\n\n";
			}

			break;
		case 'application':
			//pgp signature
			if ( $part->ctype_secondary == 'pgp-signature' ) {break;}
			//other attachments
			$filename = $filesdir . $part->ctype_parameters['name'];
			$fp = fopen($filename, 'w');
			fwrite($fp, $part->body);
			fclose($fp);
			$meta_return = '<a href="' . $filename . '">' . $part->ctype_parameters['name'] . '</a>' . "\n";
			break;
	}		
	return $meta_return;
}

// ==================================================
function yn_rfc2822_mail_address($addr) {
	$addresses = array();
	$quoted    = array();
	// ----- save quoted text -----
	while (1) {
		preg_match('/(^|[^\\\\])("([^\\\\"]|\\\\.)*")/', $addr, $m);
		if (! $m[2]) {
			break;
		}
		$addr = preg_replace("/(^|[^\\\\])$m[2]/", "$1\376\376\376" . count($quoted) . "\376\376\376", $addr, 1);
		$quoted[] = $m[2];
	}
	// ---- remove comments -----
	$addr = preg_replace('/\([^)]*[^\\\\]\)/', '', $addr);
	// ----- remove group name -----
	$addr = preg_replace('/[-\w ]+:([^;]*);/', '$1', $addr);
	// ----- split into each address -----
	foreach (explode(',', $addr) as $a) {
		$a = str_replace(' ', '', $a);
		preg_match('/<([^>]*)>/', $a, $m);
		if ($m[1]) {
			$a = $m[1];
		}
		// ----- restore quoted text -----
		$a = preg_replace('/\376\376\376(\d+)\376\376\376/e', '$quoted[$1]', $a);
		// ----- got address -----
		if ($a) {
			$addresses[] = $a;
		}
	}
	return $addresses;
}

// ==================================================
function yn_read_address($structure) {
	$senders = yn_rfc2822_mail_address(trim($structure->headers['from']));
	$sender = $senders[0];
	if (! $sender) {
		$senders = yn_rfc2822_mail_address($structure->headers['return-path']);
		$sender = $senders[0];
	}
	return $sender;
}

// ==================================================
function yn_validate_address($sender) {
	global $wpdb;
	$email4sql = $wpdb->escape($sender);
	$result = $wpdb->get_row("SELECT ID FROM {$wpdb->users} WHERE user_email = '$email4sql' LIMIT 1");
	if (! $result) {
		return NULL;
	}
	return $result->ID;
}

// ==================================================
/**
* enhanced copy of wp_create_thumbnail()
* եȤ䥯ƥб˾ХС󥢥åפб
*/
function shot_create_thumbnail($file, $max_side, $effect = '') {
	if (file_exists($file)) {
		$type = getimagesize($file);

		// if the associated function doesn't exist - then it's not
		// handle. duh. i hope.

		if (!function_exists('imagegif') && $type[2] == IMAGETYPE_GIF) {
			$error = __('Filetype not supported. Thumbnail not created.');
		}
		elseif (!function_exists('imagejpeg') && $type[2] == IMAGETYPE_JPEG) {
			$error = __('Filetype not supported. Thumbnail not created.');
		}
		elseif (!function_exists('imagepng') && $type[2] == IMAGETYPE_PNG) {
			$error = __('Filetype not supported. Thumbnail not created.');
		} else {

			// create the initial copy from the original file
			if ($type[2] == IMAGETYPE_GIF) {
				$image = imagecreatefromgif($file);
			}
			elseif ($type[2] == IMAGETYPE_JPEG) {
				$image = imagecreatefromjpeg($file);
			}
			elseif ($type[2] == IMAGETYPE_PNG) {
				$image = imagecreatefrompng($file);
			}

			if (function_exists('imageantialias'))
				imageantialias($image, TRUE);

			$image_attr = getimagesize($file);

			// figure out the longest side

			if ($image_attr[0] > $image_attr[1]) {
				$image_width = $image_attr[0];
				$image_height = $image_attr[1];
				$image_new_width = $max_side;

				$image_ratio = $image_width / $image_new_width;
				$image_new_height = $image_height / $image_ratio;
				//width is > height
			} else {
				$image_width = $image_attr[0];
				$image_height = $image_attr[1];
				$image_new_height = $max_side;

				$image_ratio = $image_height / $image_new_height;
				$image_new_width = $image_width / $image_ratio;
				//height > width
			}

			$thumbnail = imagecreatetruecolor($image_new_width, $image_new_height);
			@ imagecopyresampled($thumbnail, $image, 0, 0, 0, 0, $image_new_width, $image_new_height, $image_attr[0], $image_attr[1]);

			// If no filters change the filename, we'll do a default transformation.
			if ( basename($file) == $thumb = apply_filters('thumbnail_filename', basename($file)) )
				$thumb = preg_replace('!(\.[^.]+)?$!', __('.thumbnail').'$1', basename($file), 1);

			$thumbpath = str_replace(basename($file), $thumb, $file);

			// move the thumbnail to it's final destination
			if ($type[2] == 1) {
				if (!imagegif($thumbnail, $thumbpath)) {
					$error = __("Thumbnail path invalid");
				}
			}
			elseif ($type[2] == 2) {
				if (!imagejpeg($thumbnail, $thumbpath)) {
					$error = __("Thumbnail path invalid");
				}
			}
			elseif ($type[2] == 3) {
				if (!imagepng($thumbnail, $thumbpath)) {
					$error = __("Thumbnail path invalid");
				}
			}

		}
	} else {
		$error = __('File not found');
	}

	if (!empty ($error)) {
		return $error;
	} else {
		return $thumbpath;
	}
}
// end of script
?>
