<?php
/*
Plugin Name: wp-shot
Plugin URI: http://wppluginsj.sourceforge.jp/wp-shot/
Description: You can attach images inline in your email messages and they'll be shown as an image in your wordpress article.
Version: 0.2 alpha
Author: Otsukare
Author URI: http://xn--65q67bs6i.jp/
*/

/*  Copyright 2006
WordPress Plugins/JSeries: http://wppluginsj.sourceforge.jp/wp-shot/
This file is distributed under the same license as the WordPress package.

Goxu: http://dowonders.net/pz/wordpress

*/

if (!defined('CUSTOM_TAGS'))
	define('CUSTOM_TAGS', true);

if (!CUSTOM_TAGS) {
	$allowedposttags = array ('address' => array (), 'a' => array ('href' => array (), 'title' => array (), 'rel' => array (), 'rev' => array (), 'name' => array (), 'class' => array (), 'onclick' => array ()), 'abbr' => array ('title' => array ()), 'acronym' => array ('title' => array ()), 'b' => array (), 'big' => array (), 'blockquote' => array ('cite' => array ()), 'br' => array ('class' => array ()), 'button' => array ('disabled' => array (), 'name' => array (), 'type' => array (), 'value' => array ()), 'caption' => array ('align' => array ()), 'code' => array (), 'col' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'span' => array (), 'valign' => array (), 'width' => array ()), 'del' => array ('datetime' => array ()), 'dd' => array (), 'div' => array ('align' => array ()), 'dl' => array (), 'dt' => array (), 'em' => array (), 'fieldset' => array (), 'font' => array ('color' => array (), 'face' => array (), 'size' => array ()), 'form' => array ('action' => array (), 'accept' => array (), 'accept-charset' => array (), 'enctype' => array (), 'method' => array (), 'name' => array (), 'target' => array ()), 'h1' => array ('align' => array ()), 'h2' => array ('align' => array ()), 'h3' => array ('align' => array ()), 'h4' => array ('align' => array ()), 'h5' => array ('align' => array ()), 'h6' => array ('align' => array ()), 'hr' => array ('align' => array (), 'noshade' => array (), 'size' => array (), 'width' => array ()), 'i' => array (), 'img' => array ('alt' => array (), 'align' => array (), 'border' => array (), 'height' => array (), 'hspace' => array (), 'longdesc' => array (), 'vspace' => array (), 'src' => array (), 'width' => array (), 'class' => array ()), 'ins' => array ('datetime' => array (), 'cite' => array ()), 'kbd' => array (), 'label' => array ('for' => array ()), 'legend' => array ('align' => array ()), 'li' => array (), 'p' => array ('align' => array ()), 'pre' => array ('width' => array ()), 'q' => array ('cite' => array ()), 's' => array (), 'strike' => array (), 'strong' => array (), 'sub' => array (), 'sup' => array (), 'table' => array ('align' => array (), 'bgcolor' => array (), 'border' => array (), 'cellpadding' => array (), 'cellspacing' => array (), 'rules' => array (), 'summary' => array (), 'width' => array ()), 'tbody' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 'td' => array ('abbr' => array (), 'align' => array (), 'axis' => array (), 'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 'colspan' => array (), 'headers' => array (), 'height' => array (), 'nowrap' => array (), 'rowspan' => array (), 'scope' => array (), 'valign' => array (), 'width' => array ()), 'textarea' => array ('cols' => array (), 'rows' => array (), 'disabled' => array (), 'name' => array (), 'readonly' => array ()), 'tfoot' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 'th' => array ('abbr' => array (), 'align' => array (), 'axis' => array (), 'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 'colspan' => array (), 'headers' => array (), 'height' => array (), 'nowrap' => array (), 'rowspan' => array (), 'scope' => array (), 'valign' => array (), 'width' => array ()), 'thead' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 'title' => array (), 'tr' => array ('align' => array (), 'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 'tt' => array (), 'u' => array (), 'ul' => array (), 'ol' => array (), 'var' => array () );

	$allowedtags = array ('a' => array ('href' => array (), 'title' => array ()), 'abbr' => array ('title' => array ()), 'acronym' => array ('title' => array ()), 'b' => array (), 'blockquote' => array ('cite' => array ()),
		//	'br' => array(),
	'code' => array (),
		//	'del' => array('datetime' => array()),
		//	'dd' => array(),
		//	'dl' => array(),
		//	'dt' => array(),
	'em' => array (), 'i' => array (),
		//	'ins' => array('datetime' => array(), 'cite' => array()),
		//	'li' => array(),
		//	'ol' => array(),
		//	'p' => array(),
		//	'q' => array(),
	'strike' => array (), 'strong' => array (),
		//	'sub' => array(),
		//	'sup' => array(),
		//	'u' => array(),
		//	'ul' => array(),
	);
}

$wp_shot_dir_full = dirname(__FILE__);

$wp_shot_dir_division = preg_match("/^WIN/i", PHP_OS) ? "\\" : "/";
$wp_shot_dir_array = explode($wp_shot_dir_division, $wp_shot_dir_full);
$wp_shot_dir = array_pop($wp_shot_dir_array);

if(function_exists('load_plugin_textdomain')) {
	load_plugin_textdomain('shot', 'wp-content/plugins/'.$wp_shot_dir.'/lang');
}

function shot_cron_image() {
	global $wp_shot_dir;

	$set_cron = '<img src="';
	$set_cron .= get_settings('siteurl') . '/wp-content/plugins/';
	$set_cron .= $wp_shot_dir . '/pseudo-cron-image.php"';
	$set_cron .= ' width="1" height="1" alt="" />' . "\n";

	echo $set_cron;

}

function shot_style() {
	global $wp_shot_dir;

	$style = '<link rel="stylesheet" href="';
	$style .= get_settings('siteurl') . '/wp-content/plugins/';
	$style .= $wp_shot_dir . '/style.css"';
	$style .= ' type="text/css" media="screen" />' . "\n";

	echo $style;

}

function wp_shot_subpanel() {
	global $wp_shot_dir_full, $wp_shot_dir, $wp_shot_dir_division;

	$log_file = $wp_shot_dir_full . "/crontab.php";

	$shot_lines = fopen($log_file, "r");
	$shot_present = fgets($shot_lines);
	$shot_list = explode(" ", $shot_present);
	fclose($shot_lines);

	if (!is_writable($log_file)) {

		$non_write = "<div class=\"error\"><p>";
		$non_write .= sprintf(__('set the rewritable permission to the %s.', 'shot'), $log_file);
		$non_write .= "</p></div>\n";

		echo $non_write;
	}

	if (isset($_POST['update_shot_style'])) {

		$shot_make_samb = $_POST['shot_make_samb'];
		$shot_samb_size = $_POST['shot_samb_size'];
		$shot_ilink_att = stripslashes($_POST['shot_ilink_att']);
		$shot_ilink_att = trim($shot_ilink_att);

		update_option('shot_make_samb', $shot_make_samb);
		update_option('shot_samb_size', $shot_samb_size);
		update_option('shot_ilink_att', $shot_ilink_att);

		echo "<div class=\"updated\"><p>".__('Changed the Layout Options.', 'shot')."</p></div>\n";

	} 

	if (isset($_POST['update_shot_etc'])) {

		$shot_add_dir = $_POST['shot_add_dir'];
		$shot_dir_pass = $_POST['shot_dir_pass'];
		$shot_dir_url = $_POST['shot_dir_url'];
		$shot_rfc_check = $_POST['shot_rfc_check'];

		update_option('shot_add_dir', $shot_add_dir);
		update_option('shot_dir_pass', $shot_dir_pass);
		update_option('shot_dir_url', $shot_dir_url);
		update_option('shot_rfc_check', $shot_rfc_check);

		echo "<div class=\"updated\"><p>".__('Changed the Posting Options.', 'shot')."</p></div>\n";

	} 

	if (isset($_POST['update_shot_cron'])) {

		$shot_cron_min = $_POST['shot_cron_min'];
		$shot_cron_hour = $_POST['shot_cron_hour'];
		$shot_cron_day = $_POST['shot_cron_day'];
		$shot_cron_month = $_POST['shot_cron_month'];
		$shot_cron_week = $_POST['shot_cron_week'];
		$shot_cron_command = stripslashes($_POST['shot_cron_command']);
		$shot_cron_notify = $_POST['shot_cron_notify'];
		$shot_cron_log = $_POST['shot_cron_log'];

		update_option('shot_cron_notify', $shot_cron_notify);
		update_option('shot_cron_log', $shot_cron_log);

		$shot_cron_data = "$shot_cron_min $shot_cron_hour $shot_cron_day $shot_cron_month $shot_cron_week $shot_cron_command\n";

		$file = fopen($log_file, "w");
		fputs($file, $shot_cron_data);
		fclose($file);

		echo "<div class=\"updated\"><p>".__('Changed the Cron Job Options.', 'shot')."</p></div>\n";

	} else {

		$shot_cron_min = $shot_list[0];
		$shot_cron_hour = $shot_list[1];
		$shot_cron_day = $shot_list[2];
		$shot_cron_month = $shot_list[3];
		$shot_cron_week = $shot_list[4];
		$shot_cron_command = $shot_list[5];

	}

?>

	<div class="wrap">
		<h2><?php _e('Shot Settings', 'shot'); ?></h2>

		<form method="post">

		<table width="100%" cellpadding="3" cellspacing="3">

			<tr class="white">
				<th scope="row" align="left" valign="top" rowspan="2">1.</th>
				<td class="alternate"><?php _e('Set the <a href="./users.php">user</a> for E-mail posting with the level of Author(Level2).', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<td class="white"><?php _e('Enter your mobile phone\'s E-Mail address here.', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<th scope="row" align="left" valign="top" rowspan="2">2.</th>
				<td class="alternate"><?php _e('Create a <a href="./categories.php">category</a> for E-mail posting.', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<td class="white"><?php printf(__('The current selected category: %s ', 'shot'), get_catname(get_settings('default_email_category'))); ?></td>
			</tr>

			<tr class="white">
				<th scope="row" align="left" valign="top" rowspan="2">3.</th>
				<td class="alternate"><?php _e('Use the mobile phone\'s E-mail address for posting.', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<td class="white"><?php _e('All the mail in the inbox will be deleted after the blog recieves them. Please make sure to have the E-mail address only for posting blog entries.', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<th scope="row" align="left" valign="top" rowspan="2">4.</th>
				<td class="alternate"><?php _e('Set the mail server via the Option => <a href="options-writing.php">Writting Option</a>', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<td class="white"><?php _e('The Current Settings:', 'shot'); ?>

					<ul>
						<li><?php _e('Mail server:') . form_option('mailserver_url'); ?></li>
						<li><?php _e('Port:') . form_option('mailserver_port'); ?></li>
						<li><?php _e('Login name:') . form_option('mailserver_login'); ?></li>
						<li><?php _e('Password:') . form_option('mailserver_pass'); ?></li>
					</ul>
				</td>
			</tr>

			<tr class="white">
				<th scope="row" align="left" valign="top" rowspan="2">5.</th>
				<td class="alternate"><?php _e('translate line_218 into en_US.', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<td class="white"><input name="shot_rfc_check" type="checkbox" value="1" <?php checked(1, get_settings('shot_rfc_check')); ?> /> <?php _e('translate line_222 into en_US.', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<th scope="row" align="left" valign="top" rowspan="7">6.</th>
				<td class="alternate"><?php _e('Create a directry for images and set the rewritable permission.', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<td><input name="shot_add_dir" type="radio" value="0" <?php checked(0, get_settings('shot_add_dir')); ?> /> <?php _e('<a href="./options-misc.php">Keep the Current Directry</a> => ', 'shot'); ?> <?php echo wp_specialchars(str_replace(ABSPATH, '', get_settings('upload_path')), 1); ?></td>
			</tr>

			<tr class="white">
				<td><input name="shot_add_dir" type="radio" value="1" <?php checked(1, get_settings('shot_add_dir')); ?> /> <?php _e('Create Your Own => Fill out the following both text fields without slashes (/) at the end.', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<td><?php _e('Absolute Path of the Directry', 'shot'); ?> : <input name="shot_dir_pass" type="text" value="<?php echo get_settings('shot_dir_pass'); ?>" size="60" /></td>
			</tr>

			<tr class="white">
				<td><?php _e('Example', 'shot'); ?> : <?php echo dirname(dirname(dirname(dirname(__FILE__)))) . $wp_shot_dir_division . 'wp-photos'; ?></td>
			</tr>

			<tr class="white">
				<td><?php _e('URL of the Directry', 'shot'); ?> : <input name="shot_dir_url" type="text" value="<?php echo get_settings('shot_dir_url'); ?>" size="60" /></td>
			</tr>

			<tr class="white">
				<td><?php _e('Example', 'shot'); ?> : <?php echo get_settings('siteurl') . '/wp-photos'; ?></td>
			</tr>

		</table>

		<p class="submit"><input type="submit" name="update_shot_etc" value="<?php _e('Save the Options', 'shot'); ?>" style="font-weight:bold;" /></p>

		</form>

	</div>

	<div class="wrap">
		<h2><?php _e('Cron Job Settings', 'shot'); ?></h2>
		<p><?php _e('You can schedule to run the script with CRONTAB.', 'shot'); ?></p>

		<form method="post">

		<table width="100%" cellpadding="3" cellspacing="3">

			<tr class="white">
				<th scope="row" align="left"><?php _e('Minute', 'shot'); ?></th>
				<td><input name="shot_cron_min" type="text" value="<?php echo $shot_cron_min; ?>" size="3" /></td>
				<td><?php _e('0 - 59', 'shot'); ?></td>
			</tr>

			<tr class="alternate">
				<th scope="row" align="left"><?php _e('Hour', 'shot'); ?></th>
				<td><input name="shot_cron_hour" type="text" value="<?php echo $shot_cron_hour; ?>" size="3" /></td>
				<td><?php _e('0 - 23', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<th scope="row" align="left"><?php _e('Day', 'shot'); ?></th>
				<td><input name="shot_cron_day" type="text" value="<?php echo $shot_cron_day; ?>" size="3" /></td>
				<td><?php _e('1 - 31', 'shot'); ?></td>
			</tr>

			<tr class="alternate">
				<th scope="row" align="left"><?php _e('Month', 'shot'); ?></th>
				<td><input name="shot_cron_month" type="text" value="<?php echo $shot_cron_month; ?>" size="3" /></td>
				<td><?php _e('1 - 12 or jan - dec', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<th scope="row" align="left"><?php _e('Week', 'shot'); ?></th>
				<td><input name="shot_cron_week" type="text" value="<?php echo $shot_cron_week; ?>" size="3" /></td>
				<td><?php _e('0 - 7 or sun - sat (0 and 7 mean Sunday)', 'shot'); ?></td>
			</tr>

			<tr class="alternate">
				<th scope="row" align="left"><?php _e('The Script URL to Execute', 'shot'); ?></th>
				<td colspan="2"><input name="shot_cron_command" type="text" value="<?php echo $shot_cron_command; ?>" size="80" /><?php _e('<br />Example', 'shot'); ?> <?php echo get_settings('siteurl') . '/wp-content/plugins/' . $wp_shot_dir . '/wp-shot.php'; ?></td>
			</tr>

			<tr class="white">
				<th scope="row" align="left"><?php _e('Notification', 'shot'); ?></th>
				<td colspan="2"><input name="shot_cron_notify" type="checkbox" value="1" <?php checked(1, get_settings('shot_cron_notify')); ?> /> <?php _e('Notify Me by E-mail When Cron Job is executed', 'shot'); ?></td>
			</tr>

			<tr class="alternate">
				<th scope="row" align="left"><?php _e('Log', 'shot'); ?></th>
				<td colspan="2"><input name="shot_cron_log" type="checkbox" value="1" <?php checked(1, get_settings('shot_cron_log')); ?> /> <?php _e('Enable Logging CRON Jobs', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<th scope="row" align="left"><?php _e('Notes', 'shot'); ?></th>
				<td colspan="2"><?php _e('<p>* The script above will be executed based on the schedule of the "Munite Hour Day Month Week" section.<br />* Wildcard can be used in each column.<br />* The <a href="http://www.google.com/search?hl=en&q=crontab&btnG=Google+Search">CRONTAB Cofiguration</a> requires some basic understandings of how it works.</p>', 'shot'); ?></td>
			</tr>

		</table>

		<p><div class="submit"><input type="submit" name="update_shot_cron" value="<?php _e('Save Cron Job Options', 'shot'); ?>"  style="font-weight:bold;" /></div></p>

		</form>
	</div>

	<div class="wrap">
		<h2><?php _e('Layout Settings', 'shot'); ?></h2>

		<form method="post">

		<table width="100%" cellpadding="3" cellspacing="3">

			<tr class="white">
				<td><input name="shot_make_samb" type="radio" value="0" <?php checked(0, get_settings('shot_make_samb')); ?> /> <?php _e('Do Not Use Thumbnail', 'shot'); ?></td>
				<td><?php _e('Simply an Image will be placed above texts', 'shot'); ?></td>
			</tr>

			<tr class="alternate">
				<td><input name="shot_make_samb" type="radio" value="1" <?php checked(1, get_settings('shot_make_samb')); ?> /> <?php _e('Use Thumbnail', 'shot'); ?></td>
				<td><?php _e('The following fields must be filled for this option.', 'shot'); ?></td>
			</tr>

			<tr class="white">
				<td><?php _e('The maximum length (px)', 'shot'); ?></td>
				<td><input name="shot_samb_size" type="text" value="<?php echo get_settings('shot_samb_size'); ?>" size="5" /> px</td>
			</tr>

			<tr class="alternate">
				<td><?php _e('Attributes for the IMG tag<br />(only when the thumbnail is used.)', 'shot'); ?></td>
				<td><input name="shot_ilink_att" type="text" value='<?php echo get_settings('shot_ilink_att'); ?>' size="45" /><br /><?php _e('Example : class="highslide" onclick="return hs.expand(this)"', 'shot'); ?></td>
			</tr>

		</table>

		<p><div class="submit"><input type="submit" name="update_shot_style" value="<?php _e('Save Layout Option', 'shot'); ?>"  style="font-weight:bold;" /></div></p>

		</form>
	</div>
<?php
}

function wp_shot_menu() {
	if (function_exists('add_options_page')) {
		add_options_page(__('WP-Shot Config', 'shot'), __('WP-Shot', 'shot'), 8, basename(__FILE__), 'wp_shot_subpanel');
	}
}

add_action('admin_menu', 'wp_shot_menu');
add_action('wp_head', 'shot_style');
add_action('wp_footer', 'shot_cron_image');

?>
