<?php
/*
Plugin Name: wp-tegaki
Plugin URI: http://wppluginsj.sourceforge.jp/wp-tegaki/
Description: Output Truetype font
Author: hiromasa
Version: 0.82
Author URI: http://hiromasa.zone.ne.jp/blog/
Special Thanks:
    Original "Tegaki Tag" Parser by Sa.Ga
    (http://blog2.atsj.net/2006/06/14/1623/)
*/

/*  Copyright 2007 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * THIS FILE IS CALLED ONLY.
 *****************************************************************************/

if(basename($_SERVER['SCRIPT_FILENAME']) == 'wp-tegaki.php') {
	die();
}

/******************************************************************************
 * WpBabel WordPress Plugin Framework Define
 *****************************************************************************/

require_once('wp-babel.php');

/******************************************************************************
 * WpTegaki Controller Class
 * 
 * @author     hiromasa
 * @version    0.82
 * 
 *****************************************************************************/
class WpTegakiController extends WpBabelController_01a {
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */
	function WpTegakiController() {
		
		$plugin_name = 'wp-tegaki';
		$plugin_panel_name = 'Tegaki';
		$access_level = 8;
		
		$this->initialize(
			$plugin_name,
			$plugin_panel_name,
			$access_level);
		
		$commonVO = new WPBabelSettingVO_01a();
		$commonVO->setParam('name', $plugin_name);
		$commonVO->setParam('version', get_bloginfo('version'));
		
		$this->wpbview = & new WpTegakiView($commonVO);
		$this->wpbmodel = & new WpTegakiModelFacard();
		
	}
	
	/**
	 * the_content filter
	 *  - 
	 * 
	 * @param $content
	 * @return $content
	 */
	function filterTegaki($content) {
		
		$settingVO = $this->getWpSetting();
		
		$tegaki = new WpTegaki($settingVO);
		$content = $tegaki->changeImage($content);
		
		return $content;
		
	}
	
	/**
	 * actionAdmin
	 *  - Defalut Action
	 * 
	 * @param none
	 * @return none
	 */
	function actionAdmin($settingVO, $requestVO) {
		
		$this->wpbview->actionAdmin($settingVO);
		
	}
	
	/**
	 * actionAdminSubmit
	 * 
	 * @param none
	 * @return none
	 */
	function actionAdminSubmit($settingVO, $requestVO) {
		
		$result = $this->wpbmodel->actionAdminSubmit(
			$settingVO, $requestVO);
		$this->updateWpSetting($result);
		$this->wpbview->actionAdminSubmit($result);
		
	}
	
}

/******************************************************************************
 * WpTegaki Model Facard Class
 * 
 * @author     hiromasa
 * @version    0.82
 * 
 *****************************************************************************/
class WpTegakiModelFacard extends WpBabelModelFacerd_01a {
	
	/**
	 * actionAdminSubmit
	 * 
	 * @param $settingVO
	 * @param $requestVO
	 */
	function actionAdminSubmit($settingVO, $requestVO) {
		
		$result = new WPBabelSettingVO_01a();
		
		$default_font    = $requestVO->getParam('default_font');
		$default_size    = $requestVO->getParam('default_size');
		$defalut_color   = $requestVO->getParam('defalut_color');
		$defalut_bgcolor = $requestVO->getParam('defalut_bgcolor');
		
		//TODO: Validation Check
		
		$result->setParam('default_font'   , $default_font);
		$result->setParam('default_size'   , $default_size);
		$result->setParam('defalut_color'  , $defalut_color);
		$result->setParam('defalut_bgcolor', $defalut_bgcolor);
		
		return $result;
		
	}
	
	/**
	 * setDefalutSetting
	 * 
	 * @param $settingVO
	 * @return none
	 */
	function setDefalutSetting() {
		
		$result = new WPBabelSettingVO_01a();
		
		$result->setParam('default_font', 'hogehoge.ttf');
		$result->setParam('default_size', '20');
		$result->setParam('defalut_color', '#000000');
		$result->setParam('defalut_bgcolor', '#ffffff');
		
		return $result;
		
	}
	
}

/******************************************************************************
 * WpTegaki View Class
 * 
 * @author     hiromasa
 * @version    0.82
 * 
 *****************************************************************************/
class WpTegakiView extends WpBabelView_01a {
	
	/**
	 * actionAdmin
	 *  - Defalut Action
	 * 
	 * @param none
	 * @return none
	 */
	function actionAdmin(&$mapVO) {
		
		$name = $this->commonVO->getParam('name');
		
		//TODO:
		//$img_src  = $this->commonVO->getParam('siteurl');
		$img_src  = get_settings('siteurl');
		$img_src .= '/wp-content/plugins/wp-tegaki/wp-tegaki-img.php';
		
		echo '<div class="wrap">' . "\n";
		echo '<form method="post">' . "\n";
		echo "<h2>$name " . __('デフォルトフォント設定') . "</h2>" . "\n";
		
		echo '<table class="optiontable">' . "\n";
		
		echo '<tr>';
		echo '<th scope="row">' . __('TrueType ファイル名'). '</th>';
		echo '<td><input name="default_font" type="text" id="default_font" value="'. $mapVO->getParam('default_font') . '" size="40" class="code" /></td>';
		echo '</tr>' . "\n";
		
		echo '<tr>';
		echo '<th scope="row">' . __('フォントサイズ'). '</th>';
		echo '<td><input name="default_size" type="text" id="default_size" value="'. $mapVO->getParam('default_size') . '" size="4" class="code" /></td>';
		echo '</tr>' . "\n";
		
		echo '<tr>';
		echo '<th scope="row">' . __('文字色'). '</th>';
		echo '<td><input name="defalut_color" type="text" id="defalut_color" value="'. $mapVO->getParam('defalut_color') . '" size="8" class="code" /></td>';
		echo '</tr>' . "\n";
		
		echo '<tr>';
		echo '<th scope="row">' . __('背景色'). '</th>';
		echo '<td><input name="defalut_bgcolor" type="text" id="defalut_bgcolor" value="'. $mapVO->getParam('defalut_bgcolor') . '" size="8" class="code" /></td>';
		echo '</tr>' . "\n";
		
		echo '<tr>';
		echo '<th scope="row">' . __('表示イメージ'). '</th>';
		echo '<td><img src="' . $img_src . '?tegaki_id=test-0" /></td>';
		echo '</tr>' . "\n";
		
		echo '</table>' . "\n";
		
		echo '<p class="submit"><input type="submit" name="submit" value="' .__('設定を更新する &raquo;') . '" />' . "\n";
		echo '<input type="hidden" name="action" value="submit" />';
		echo '</form>' . "\n";
		echo '</div>' . "\n";
		
	}
	
	function actionAdminSubmit(&$mapVO) {
		
		$this->putMessage(__('設定を更新しました'));
		$this->actionAdmin($mapVO);
		
	}
}

/******************************************************************************
 * WpTegaki
 *  - 
 * 
 * @author		hiromasa
 * @version		0.82
 * 
 *****************************************************************************/
class WpTegaki {
	
	var $img_src;
	var $blog_charset;
	
	var $default_value;
	
	function WpTegaki(&$settingVO) {
		
		$this->default_value['font'] =
			$settingVO->getParam('default_font');
		$this->default_value['size'] =
			$settingVO->getParam('default_size');
		$this->default_value['color'] =
			$settingVO->getParam('defalut_color');
		$this->default_value['bgcolor'] =
			$settingVO->getParam('defalut_bgcolor');
		$this->default_value['plugin_dir'] =
			$settingVO->getParam('plugin_dir');
		
		$this->blog_charset = $settingVO->getParam('blog_charset');
		$this->img_src  = $settingVO->getParam('siteurl');
		//TODO:
		$this->img_src .= '/wp-content/plugins/wp-tegaki/wp-tegaki-img.php';
		
	}
	
	function changeImage($content) {
		
		global $wpdb, $id, $page;
		
		$pattern = '/\[tegaki.*\](.*)\[\/tegaki\]/i';
		$matches = '';
		$img_src = $this->img_src . "?tegaki_id=$id";
		
		$content
			= mb_convert_encoding($content, "UTF-8", $this->blog_charset);
		
		$tegakiParser = & new WpTegakiTagParser(
			$content,
			$this->default_value['font'] ,
			$this->default_value['size'],
			$this->default_value['color'],
			$this->default_value['bgcolor'],
			$this->default_value['plugin_dir']);
		
		if(preg_match_all($pattern, $content, $matches)) {
			
			for ($i=0; $i<count($matches[0]); $i++) {
				
				$search_strings[$i]
					= '/' . preg_quote($matches[0][$i], '/') . '/';
				
				$moji   = $tegakiParser->getAttr('text', $i);
				$width  = $tegakiParser->getAttr('width', $i);
				$height = $tegakiParser->getAttr('height', $i);
				
				$img_src2 = $img_src . '-' . $i . "&amp;page=$page";
				$replace_string[$i]  = '<img src="' . $img_src2 . '"';
				$replace_string[$i] .= ' alt="'. $moji . '"';
				$replace_string[$i] .= ' width="'. $width . '"';
				$replace_string[$i] .= ' height="'. $height . '" />';
				
			}
			$content
				= preg_replace($search_strings, $replace_string, $content);
			
		}
		
		$content
			= mb_convert_encoding($content, $this->blog_charset, "UTF-8");
		
		return $content;
		
	}
	
}

/******************************************************************************
 * WpTegaki - Tag Parser
 *  - 
 * 
 * @author		hiromasa
 * @version		0.82
 * 
 *****************************************************************************/
class WpTegakiTagParser {
	
	var $attr;
	
	function WpTegakiTagParser(
		$text,
		$default_font,
		$default_size,
		$defalut_color,
		$default_bgcolor,
		$font_dir) {
		
		$this->attr = array();
		$this->parser(
			$text,
			$default_font,
			$default_size,
			$defalut_color,
			$default_bgcolor,
			$font_dir);
		
	}
	
	function parser(
		$text,
		$default_font,
		$default_size,
		$defalut_color,
		$default_bgcolor,
		$font_dir) {
		
		$pattern = '/\[tegaki(.*)\](.*)\[\/tegaki\]/i';
		$matches = '';
		
		preg_match_all($pattern, $text, $matches);
		
		for ($i=0; $i<count($matches[0]); $i++) {
			
			$this->setAttr('text', htmlspecialchars($matches[2][$i]), $i);
			$this->setAttr('font', $font_dir . $default_font, $i);
			$this->setAttr('size', $default_size, $i);
			$this->setAttr('color',
				$this->colorParser($defalut_color), $i);
			$this->setAttr('bgcolor',
				$this->colorParser($default_bgcolor), $i);
			$this->setAttr('font_dir', $font_dir , $i);
			
			$attr = htmlspecialchars($matches[1][$i]);
			$pattern2 = '/(\w+)\s*=\s*&quot;(.*?)&quot;/i';
			$matches2 = '';
			
			preg_match_all($pattern2, $attr, $matches2);
			
			for ($k=0; $k<count($matches2[0]); $k++) {
				$attr_name  = strtolower($matches2[1][$k]);
				$attr_name  = 'set_' . $matches2[1][$k];
				$attr_value = $matches2[2][$k];
				
				if(method_exists($this, $attr_name)) {
					$this->$attr_name($attr_value, $i);
				}
			}
			
			$this->makeSize(
				$this->getAttr('font', $i),
				$this->getAttr('size' ,$i),
				$this->getAttr('text' ,$i),
				$i);
			
		}
		
	}
	
	function set_size($attr_value, $number) {
		
		$this->setAttr('size', $attr_value, $number);
		
	}
	
	function set_font($attr_value, $number) {
		
		$font_dir = $this->getAttr('font_dir', $number);
		$this->setAttr('font', $font_dir . $attr_value, $number);
		
	}
	
	function set_color($attr_value, $number) {
		
		$colors = $this->colorParser($attr_value);
		$this->setAttr('color', $colors, $number);
		
	}
	
	function set_bgcolor($attr_value, $number) {
		
		$colors = $this->colorParser($attr_value);
		$this->setAttr('bgcolor', $colors, $number);
		
	}
	
	function getAttr($name, $number) {
		
		return $this->attr[$number][$name];
		
	}
	
	function setAttr($name, $value, $number) {
		
		$this->attr[$number][$name] = $value;
		
	}
	
	function colorParser($value) {
		
		$colors = array();
		
		if (preg_match('/^#[0-9a-fA-F]{6,6}$/', $value)) {
			$color_R = HexDec(substr($value, 1, 2));
			$color_G = HexDec(substr($value, 3, 2));
			$color_B = HexDec(substr($value, 5, 2));
		} elseif (preg_match('/^#[0-9a-fA-F]{3,3}$/', $value)) {
			$color_R = HexDec(substr($value, 1, 1)) * 17;
			$color_G = HexDec(substr($value, 2, 1)) * 17;
			$color_B = HexDec(substr($value, 3, 1)) * 17;
		}
		
		$colors = array($color_R, $color_G, $color_B);
		
		return $colors;
		
	}
	
	function makeSize($fontfile, $size, $text, $number) {
		
		//for GD by EUC-JP
		//$text
		//	= mb_convert_encoding($text, "EUC-JP", "UTF-8");
		
		$size = imagettfbbox($size, 0, $fontfile, $text);
		
		//TODO: MAGIC NUMBER
		$width  = $size[2] - $size[0] + 8;
		//TODO: MAGIC NUMBER
		$height = $size[3] - $size[5] + 8;
		
		$this->setAttr('width', $width, $number);
		$this->setAttr('height', $height, $number);
		
	}
	
}

/******************************************************************************
 * WpTegaki - function define
 *****************************************************************************/

$wptegaki = & new WpTegakiController();
add_action('admin_menu', array(&$wptegaki, 'addAdminPanel'));
add_filter('the_content', array(&$wptegaki, 'filterTegaki'), 1);

?>
