<?php
/*  Copyright 2007 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WpTegaki - Function Define and WordPress Interface Inclide
 *****************************************************************************/

require('../../../wp-blog-header.php');
$wptegakiimg = & new WpTegakiImage();

/******************************************************************************
 * WpTegakiImage - Output True Type
 *  - 
 * 
 * @author		hiromasa
 * @version		0.82
 * 
 *****************************************************************************/
class WpTegakiImage {
	
	var $blog_charset;
	
	function WpTegakiImage() {
		
		global $wpdb, $wptegaki, $multipage, $pages, $page;
		
		$settingVO = $wptegaki->getWpSetting();
		
		$this->blog_charset = $settingVO->getParam('blog_charset');
		
		$font       = $settingVO->getParam('default_font');
		$size       = $settingVO->getParam('default_size');
		$color      = $settingVO->getParam('defalut_color');
		$bgcolor    = $settingVO->getParam('defalut_bgcolor');
		$font_dir   = $settingVO->getParam('plugin_dir');
		
		$ids = addslashes($_GET['tegaki_id']);
		list($id, $number) = split('-', $ids);
		
		if($id != 'test') {
			if(!($post = &get_post($id))) return;
			setup_postdata($post);
			if($multipage != 0) {
				$content = $pages[$page - 1];
			} else {
				$content = $post->post_content;
			}
		} else {
			$number = 0;
			$content = '[tegaki]' . __('wp-tegaki の試験です') . '[/tegaki]';
		}
		
		$content = mb_convert_encoding($content, "UTF-8", $this->blog_charset);
		
		$tegaki = & new WpTegakiTagParser(
			$content,
			$font,
			$size,
			$color,
			$bgcolor,
			$font_dir);
		
		$text    = $tegaki->getAttr('text',   $number);
		$font    = $tegaki->getAttr('font',   $number);
		$size    = $tegaki->getAttr('size',   $number);
		$color   = $tegaki->getAttr('color',  $number);
		$bgcolor = $tegaki->getAttr('bgcolor',$number);
		$width   = $tegaki->getAttr('width',  $number);
		$height  = $tegaki->getAttr('height', $number);
		
		if($text != '') {
			$this->writeImage(
				$text,
				$font,
				$size,
				$color,
				$bgcolor,
				$width,
				$height);
		}
		
	}
	
	function writeImage(
		$text,
		$font,
		$font_size,
		$font_color,
		$background_color,
		$width,
		$height) {
		
		//for GD by EUC-JP
		//$text
		//	= mb_convert_encoding($text, "EUC-JP", "UTF-8");
		
		$im = imagecreate($width, $height);
		
		list($color_r, $color_g, $color_b) = $font_color;
		list($bgcolor_r, $bgcolor_g, $bgcolor_b) = $background_color;
		
		$bgcolor =
			imagecolorallocate($im, $bgcolor_r, $bgcolor_g, $bgcolor_b);
		$color =
			imagecolorallocate($im, $color_r, $color_g, $color_b);
		
		header("Content-type: image/png");
		
		imagettftext(
			$im, 
			$font_size,
			0,
			0,
			//TODO: MAGIC NUMBER
			$height - 8,
			$color,
			$font,
			$text);
		
		imagepng($im);
		imagedestroy($im);
		
	}
	
}
?>
