<?php
/******************************************************************************
 * WpBabel WordPress Plugin Framework (Testing)
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/

/*  Copyright 2006 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * THIS FILE IS CALLED ONLY.
 *****************************************************************************/

if(basename($_SERVER['SCRIPT_FILENAME']) == 'wp-babel.php') {
	die();
}

/******************************************************************************
 * WpBabel Controller Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WpBabelController_01a {
	
	var $wpbmodel;
	var $wpbview;
	
	var $plugin_name;
	var $plugin_panel_name;
	var $access_level;
	
	/**
	 * initialize
	 * 
	 * @param none
	 * @return none
	 */
	function initialize(
		$plugin_name = 'wp-babel',
		$plugin_panel_name = 'wp-babel',
		$access_level = 8) {
		
		$this->plugin_name = $plugin_name;
		$this->plugin_panel_name = $plugin_panel_name;
		$this->access_level = $access_level;
		
		$this->load_plugin_textdomain($this->plugin_name);
		
	}
	
	/**
	 * addAdminPanel
	 * 
	 * @param none
	 * @return none
	 */
	function addAdminPanel() {
		
		add_options_page(
			$this->plugin_name,
			$this->plugin_panel_name,
			$this->access_level,
			$this->plugin_name . '.php',
			array(&$this, 'actionAdminFacard')
		);
		
	}
	
	/**
	 * actionAdminFacard
	 * 
	 * @param none
	 * @return none
	 */
	function actionAdminFacard() {
		
		if(!is_admin()) return;
		
		$requestVO = new WPBabelHTTPRequestVO_01a();
		$settingVO = $this->getWpSetting();
		
		$action  = 'actionAdmin';
		$action .= $requestVO->getParam('action');
		$this->$action($settingVO, $requestVO);
		
	}
	
	/**
	 * setWpSetting
	 * 
	 * @param none
	 * @return none
	 */
	function writeWpSetting($settingVO) {
		
		$option_description = $this->plugin_name . " Options";
		
		add_option(
			$this->plugin_name,
			$settingVO,
			$option_description);
		
	}
	
	/**
	 * updateWpSetting
	 * 
	 * @param none
	 * @return none
	 */
	function updateWpSetting($settingVO) {
		
		$option_description = $this->plugin_name . " Options";
		
		update_option(
			$this->plugin_name,
			$settingVO,
			$option_description);
		
	}
	
	/**
	 * getWpSetting
	 * 
	 * @param none
	 * @return none
	 */
	function getWpSetting() {
		
		$option = get_option($this->plugin_name);
		
		if(!$option == false) {
			$settingVO = $option;
		} else {
			$settingVO = new WPBabelSettingVO_01a();
			$result = $this->wpbmodel->setDefalutSetting();
			$this->writeWpSetting($result);
		}
		
		$settingVO->setParam('blog_charset', get_settings('blog_charset'));
		$settingVO->setParam('siteurl', get_settings('siteurl'));
		$settingVO->
			setParam('plugin_dir', dirname(__FILE__) . '/');
		
		return $settingVO;
		
	}
	
	/**
	 * load_plugin_textdomain
	 * 
	 * @param $domain_name
	 * @return none
	 */
	function load_plugin_textdomain($domain_name) {
		
		$locale_name  = get_locale();
		$mofile_name  = dirname(__FILE__);
		$mofile_name .= "/$domain_name-$locale_name.mo";
		load_textdomain("$domain_name", $mofile_name);
		
	}
	
}

/******************************************************************************
 * WpBabel WpBabel Model Facerd Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WpBabelModelFacerd_01a {
	
	/**
	 * setDefalutSetting
	 * 
	 * @param $settingVO
	 * @return none
	 */
	function setDefalutSetting(&$settingVO) {
		
	}
	
}

/******************************************************************************
 * WpBabel View Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WpBabelView_01a {
	
	var $commonVO;
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */
	function WpBabelView_01a($commonVO = null) {
		
		$this->commonVO = $commonVO;
		
	}
	
	/**
	 * putMessage
	 * 
	 * @param $message
	 * @return none
	 */
	function putMessage($message) {
		
		$wp_version = '';
		if(isset($this->commonVO)) {
			$wp_version = $this->commonVO->getParam('version');
		}
		
		if(preg_match('/2.0/i',$wp_version)) {
			echo '<div id="message" class="updated fade">' . "\n";
			echo "<p><strong>$message</strong></p>" . "\n";
			echo '</div>' . "\n";
		} else {
			echo '<div class="updated">' . "\n";
			echo "<p><strong>$message</strong></p>" . "\n";
			echo '</div>' . "\n";
		}
		
	}
	
}
/******************************************************************************
 * WPBabel ValueObject Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WPBabelValueObject_01a {
	
	var $paramsMap = Array();
	
	/**
	 * setParam
	 * 
	 * @param $name
	 * @return none
	 */
	function setParam($name, $value) {
		
		$this->paramsMap[$name] = $value;
		
	}
	
	/**
	 * getParam
	 * 
	 * @param $name
	 * @return none
	 */
	function getParam($name) {
		
		return $this->paramsMap[$name];
		
	}
	
}

/******************************************************************************
 * WPBabel HTTPRequestVO Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WPBabelHTTPRequestVO_01a extends WPBabelValueObject_01a {
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */
	function WPBabelHTTPRequestVO_01a() {
		
		if(is_array($_REQUEST)) {
			foreach($_REQUEST as $name => $value) {
				$this->setParam($name, $value);
			}
		}
		
	}
	
}

/******************************************************************************
 * WPBabel SettingVO Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WPBabelSettingVO_01a extends WPBabelValueObject_01a {
	
}
?>