<?php
/*
Plugin Name: wp-ohayo
Plugin URI: http://wppluginsj.sourceforge.jp/wp-ohayo/
Description: converts the time of the comment into the image
Author: hiromasa
Version: 1.00
Author URI: http://hiromasa.zone.ne.jp/blog/
*/

/*  Copyright 2007 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
 * WpOhayo
 * 
 * @author		hiromasa
 * @version		1.00
 * 
 *****************************************************************************/
class WpOhayo {
	
	var $img_path;
	var $img_alt;
	var $img_size_width;
	var $img_size_height;
	
	function WpOhayo() {
		
		$site_url = get_option('siteurl');
		$img_root = "/wp-content/plugins/wp-ohayo/images/";
		
		$this->img_path[0] = $site_url . $img_root . "asa_s.png";
		$this->img_path[1] = $site_url . $img_root . "hiru_s.png";
		$this->img_path[2] = $site_url . $img_root . "yoru_s.png";
		
		$this->img_alt[0] = "Morning";
		$this->img_alt[1] = "Daytime";
		$this->img_alt[2] = "Nighttime";
		
		$this->img_size_width  = "26";
		$this->img_size_height = "26";
		
	}
	
	function rewriteCommentTime($time) {
		
		global $comment;
		
		$time = mysql2date('H:i', $comment->comment_date);
		$img_tag = $this->getOhayoImg($time);
		
		return $img_tag;
		
	}
	
	function rewritePostTime($time) {
		
		global $post;
		
		$time = mysql2date('H:i', $post->post_date);
		$img_tag = $this->getOhayoImg($time);
		
		return $img_tag;
		
	}
	
	function getOhayoImg($time) {
		
		if($time >= "05:00" && $time < "10:00") {
			$img = 0;
		}
		else if ($time >= "10:00" && $time < "18:00") {
			$img = 1;
		}
		else {
			$img = 2;
		}
		
		$img_tag = '<img ' .
			'src="'    . $this->img_path[$img]  . '" ' .
			'alt="'    . $this->img_alt[$img]   . '" '.
			'width="'  . $this->img_size_width  . '" '. 
			'height="' . $this->img_size_height . '" ' .
			'style="vertical-align: text-bottom;" />';
		
		return $img_tag;
		
	}
	
}

/******************************************************************************
 * WpOhayo - WordPress Interface Define
 *****************************************************************************/

$wpohayo = & new WpOhayo();

add_filter('get_comment_time', array(&$wpohayo, 'rewriteCommentTime'), 999);
//add_filter('get_the_time', array(&$wpohayo, 'rewritePostTime'), 999);
?>
