<?php
/*
Plugin Name: EntryKeywords
Plugin URI: http://wppluginsj.sourceforge.jp/entrykeywords/
Description: 記事ごとにキーワードを複数設定する
Author: よしとも
Version: 0.5
Author URI: http://blog.yoshitomo.org/
*/


// This file's encode is UTF-8. And language is Japanese.


/*  Copyright 2007  Yoshitomo  (email : See http://park15.wakwak.com/%7Eyoshitomo/aboutMail.html)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
使い方：
１．プラグインディレクトリにアップロード
２．管理画面で有効化
３．テンプレートにタグを挿入

　使用できるタグや仕様サンプルは管理画面のオプションにあります。
*/


if( class_exists('WpEntryKeywords') )
{
	$ywek = new WpEntryKeywords();
}

// メインクラス
class WpEntryKeywords
{
	var $i18nDomain = 'wp_EntryKeywords.yoshitomo.org';	// 国際化リソースドメイン
	var $customFieldKey = 'yo_keyword';					// カスタムフィールドのキー
	var $defaultSeparator = ' ';						// デフォルトキーワードセパレーター

	var $option;										// オプションクラスインスタンス

	/**
	 * コンストラクタ
	 *
	 * @param void
	 * @return object クラスオブジェクト
	 */
	function WpEntryKeywords()
	{
		// i18n
		load_plugin_textdomain($this->i18nDomain);

		// オプションクラスインスタンスの作成
		$this->option = get_option($this->customFieldKey);
		if ( $this->option )
		{
			// クラスの一致を確認
			if ( !is_object($this->option)  or  strtolower(get_class($this->option)) != strtolower('Option') )
			{
				$this->option = new Option();
			}
		}
		else
		{
			$this->option = new Option();
		}

		// Hooks
		add_action('admin_menu', array(&$this, '_addPage'));
		add_action('admin_head', array(&$this, '_addAdminCssLink'));

	}

	/**
	 * キーワードを得る
	 *
	 * @param string $param 次の形式でオプションを指定する　option1=value1&option2=value2
	 * @return mixd キーワードデーター
	 */
	function getKeyword($param = '')
	{
		global $post;

		// パラメーターによる上書き
		$this->option->optionOverwrite($param);

		// キーワードの取得
		$keywords = $this->_getKeywords($this->option->getOption('select'));

		// 結果
		switch ( $this->option->getOption('return') )
		{
			case 'array':
				return $keywords;
				break;
			case 'json':
				foreach ( $keywords as $data )
				{
					$js_keywords[] = '"' . addslashes($data) . '"';
				}
				return '[' . implode(', ', $js_keywords) . ']';
				break;
			default: // string
				// セパレーター
				switch ( $this->option->getOption('separator') )
				{
					case 'user':
						$separator = $this->option->getOption('user_separator');
						break;
					default: // default
						$separator = $this->defaultSeparator;
				}

				$return_value = implode($separator, $keywords);

				// エンコード
				switch ( $this->option->getOption('encode') )
				{
					case 'url':
						$return_value = urlencode($return_value);
						break;
					case 'none':
						break;
					default: // html
						$return_value = htmlspecialchars($return_value);
				}
				return $return_value;
		}
	}

	/**
	 * キーワードを文字列で出力する
	 *
	 * @param string $param パラメーター
	 * @return void
	 */
	function printKeyword($param = '')
	{
		$keyword = $this->getKeyword($param);
		if ( is_string($keyword) )
		{
			print $keyword;
		}
		elseif ( is_array($keyword) )
		{
			print_r($keyword);
		}
		else
		{
			var_dump($keyword);
		}
	}

	/**
	 * キーワードリストを得る
	 * @param void
	 * @return array キーワードリスト
	 */
	function _getKeywords()
	{
		global $post;

		$keywords_list = array();
		$keywords = get_post_meta($post->ID, $this->customFieldKey, false);
		if ( count($keywords) )							// キーワードが設定されていた場合・・・
		{
			foreach ( $keywords as $keyword )
			{
				$keywords_list = array_merge($keywords_list, preg_split("/\r\n|\r|\n/", rtrim($keyword)));
														// 改行で分割して取り込む
			}
		}
		else
		{
			switch ( $this->option->getOption('action') )
			{
				case 'category':
					foreach ( get_the_category() as $category_info )
					{
						$keywords_list[] = $category_info->cat_name;
					}
					break;
				case 'user':
					$keywords_list[] = $this->option->getOption('user_keyword');
					break;
				default: // none
			}
		}

		// キーワード選択
		$select = intval($this->option->getOption('select'));
		switch ( $select )
		{
			case 0;
				return $keywords_list;
				break;
			default: // 上限指定あり
				$randKey = array_rand($keywords_list, $select);
				switch ( $select )
				{
					case 1:
						return array($keywords_list[$randKey]);
						break;
					default: // 複数
						$rand_keyword_list = array();
						foreach ( $randKey as $key )
						{
							$rand_keyword_list[] = $keywords_list[$key];
						}
						return $rand_keyword_list;
				}
		}
	}

	/**
	 * 管理画面のヘッダに CSS へのリンクを追加する
	 */
	function _addAdminCssLink()
	{
		$dirs = explode('/', dirname(__FILE__));
		print('<link rel="stylesheet" type="text/css" href="' . get_bloginfo('wpurl') . '/wp-content/plugins/' . array_pop($dirs) . '/css/admin.css" />' . "\n");
	}

	/**
	 * 管理画面にページを追加する
	 *
	 * @return void
	 */
	function _addPage()
	{
		// オプションページの追加
		if ( function_exists('add_options_page') )
		{
			add_options_page(__('EntryKeywords オプション', $this->i18nDomain), __('EntryKeywords', $this->i18nDomain), 8, basename(__FILE__), array(&$this, '_optionPage'));
		}
	}

	/**
	 * 管理画面メニューのオプションページ
	 *
	 * @return void
	 */

	function _optionPage()
	{

		switch ( $_POST['op'] )
		{
			case 'set_option':
				// 強制的にエスケープ処理が入るので、使用する直前にアンエスケープしてやる
				foreach ( $_POST as $web_post_name => $web_post_value )
				{
					$_POST[$web_post_name] = stripslashes($web_post_value);
				}
				if ( $_POST['select'] == '' )
				{
					$_POST['select'] = 0;
				}
				$this->option->setOption('action', $_POST['action']);
				$this->option->setOption('user_keyword', $_POST['user_keyword']);
				$this->option->setOption('separator', $_POST['separator']);
				$this->option->setOption('user_separator', $_POST['user_separator']);
				$this->option->setOption('encode', $_POST['encode']);
				$this->option->setOption('return', $_POST['return']);
				$this->option->setOption('select', intval($_POST['select']));
				update_option($this->customFieldKey, $this->option);
				break;
			case 'reset_option':
				$this->option->resetOption();
				update_option($this->customFieldKey, $this->option);
				break;
			default: // not submited
		}

		// キーワードなしのときの動作
		$select_action = array();
		switch ( $this->option->getOption('action') )
		{
			case 'category':
				$select_action['category'] = ' checked="checked"';
				break;
			case 'user':
				$select_action['user'] = ' checked="checked"';
				break;
			default: // none
				$select_action['none'] = ' checked="checked"';
		}

		// セパレーター
		$select_separator = array();
		switch ( $this->option->getOption('separator') )
		{
			case 'user':
				$select_separator['user'] = ' checked="checked"';
				break;
			default: // none
				$select_separator['default'] = ' checked="checked"';
		}

		// エンコード
		$select_encode = array();
		switch ( $this->option->getOption('encode') )
		{
			case 'url':
				$select_encode['url'] = ' checked="checked"';
				break;
			case 'none':
				$select_encode['none'] = ' checked="checked"';
				break;
			default: // html
				$select_encode['html'] = ' checked="checked"';
		}

		// 実行結果
		$select_return = array();
		switch ( $this->option->getOption('return') )
		{
			case 'array':
				$select_return['array'] = ' checked="checked"';
				break;
			case 'json':
				$select_return['json'] = ' checked="checked"';
				break;
			default: // string
				$select_return['string'] = ' checked="checked"';
		}

		// プラグインオプション画面のコード出力
?>
<div class="wrap" id="EntryKeywords">
<h2><?php _e('設定', $this->i18nDomain); ?></h2>
<p><?php _e('設定の優先度は、1.パラメーター、2.この画面での設定、3.プラグインの初期値となっています。', $this->i18nDomain); ?></p>
<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
<fieldset>
<legend><?php _e('キーワードの取得数', $this->i18nDomain); ?></legend>
<p><?php _e('取得するキーワードの数の上限を設定します。0にするとすべて取得し、これがデフォルトです。', $this->i18nDomain); ?></p>
<p><?php _e('オプション名：<code>select</code>', $this->i18nDomain); ?>
<p><label for="select"><?php _e('取得数', $this->i18nDomain); ?></label><input type="text" name="select" id="select" value="<?php echo htmlspecialchars($this->option->getOption('select')); ?>" /></p>
</fieldset>

<fieldset>
<legend><?php _e('キーワードなしのときの動作', $this->i18nDomain); ?></legend>
<p><?php _e('記事にキーワードが設定されていなかったときの動作を選択してください。', $this->i18nDomain); ?></p>
<p><?php _e('オプション名：<code>action</code>', $this->i18nDomain); ?></p>
<ul>
<li>
<input type="radio" name="action" id="action_none" value="none"<?php echo $select_action['none']; ?> /><label for="action_none"><?php _e('なにもしない（デフォルト）', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>none</code>', $this->i18nDomain); ?>
</li>
<li>
<input type="radio" name="action" id="action_category" value="category"<?php echo $select_action['category']; ?> /><label for="action_category"><?php _e('カテゴリーを使う', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>category</code>', $this->i18nDomain); ?>
</li>
<li>
<input type="radio" name="action" id="action_user" value="user"<?php echo $select_action['user']; ?> /><label for="action_user"><?php _e('ユーザー指定のキーワードを使う', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>user</code>', $this->i18nDomain); ?>
</li>
</ul>
<p><label for="user_keyword"><?php _e('キーワードの指定', $this->i18nDomain); ?></label><input type="text" name="user_keyword" id="user_keyword" value="<?php echo htmlspecialchars($this->option->getOption('user_keyword')); ?>" />
<p><?php _e('オプション名：<code>user_keyword</code>', $this->i18nDomain); ?></p>
</fieldset>

<fieldset>
<legend><?php _e('リターン', $this->i18nDomain); ?></legend>
<p><?php _e('実行結果をどのように得たいか。', $this->i18nDomain); ?></p>
<p><?php _e('オプション名：<code>return</code>', $this->i18nDomain); ?></p>
<ul>
<li>
<input type="radio" name="return" id="return_string" value="string"<?php echo $select_return['string']; ?> /><label for="return_string"><?php _e('文字列（デフォルト）', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>string</code>', $this->i18nDomain); ?>
</li>
<li>
<input type="radio" name="return" id="return_array" value="array"<?php echo $select_return['array']; ?> /><label for="return_array"><?php _e('配列', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>array</code>', $this->i18nDomain); ?>
</li>
<li>
<input type="radio" name="return" id="return_json" value="json"<?php echo $select_return['json']; ?> /><label for="return_json"><?php _e('<abbr title="JavaScript Object Notation">JSON</abbr>', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>json</code>', $this->i18nDomain); ?>
</li>
</ul>
</fieldset>

<fieldset>
<legend><?php _e('セパレーター', $this->i18nDomain); ?></legend>
<p><?php _e('キーワードを区切るセパレーターとなる文字。このオプションは、文字列形式で結果を得る場合にのみ有効です。ユーザー指定で空欄にすると、セパレーターなしにできます。', $this->i18nDomain); ?></p>
<p><?php _e('オプション名：<code>separator</code>', $this->i18nDomain); ?>
<ul>
<li>
<input type="radio" name="separator" id="separator_default" value="default"<?php echo $select_separator['default']; ?> /><label for="separator_default"><?php _e('半角スペースを使う（デフォルト）', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>default</code>', $this->i18nDomain); ?>
</li>
<li>
<input type="radio" name="separator" id="separator_user" value="user"<?php echo $select_separator['user']; ?> /><label for="separator_user"><?php _e('ユーザー指定のセパレーターを使う', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>user</code>', $this->i18nDomain); ?>
</li>
</ul>
<p><label for="user_separator"><?php _e('セパレーターの指定', $this->i18nDomain); ?></label><input type="text" name="user_separator" id="user_separator" value="<?php echo htmlspecialchars($this->option->getOption('user_separator')); ?>" /></p>
<p><?php _e('オプション名：<code>user_separator</code>', $this->i18nDomain); ?></p>
</fieldset>

<fieldset>
<legend><?php _e('エンコード', $this->i18nDomain); ?></legend>
<p><?php _e('エンコード形式。このオプションは、文字列形式で結果を得る場合にのみ有効です。エンコードしない場合はセキュリティーホールにご注意ください。', $this->i18nDomain); ?></p>
<ul>
<li>
<input type="radio" name="encode" id="encode_html" value="html"<?php echo $select_encode['html']; ?> /><label for="encode_html"><?php _e('<abbr title="HyperText Markup Language">HTML </abbr>エンコード（デフォルト）', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>html</code>', $this->i18nDomain); ?>
</li>
<li>
<input type="radio" name="encode" id="encode_url" value="url"<?php echo $select_encode['url']; ?> /><label for="encode_url"><?php _e('<abbr title="Uniform Resource Locator">URL</abbr> エンコード', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>url</code>', $this->i18nDomain); ?>
</li>
<li>
<input type="radio" name="encode" id="encode_none" value="none"<?php echo $select_encode['none']; ?> /><label for="encode_none"><?php _e('エンコードしない', $this->i18nDomain); ?></label><br />
<?php _e('値：<code>none</code>', $this->i18nDomain); ?>
</li>
</ul>
</fieldset>
<p class="submit">
<input type="submit" value="<?php _e('設定を更新する &raquo;', $this->i18nDomain); ?>" />
</p>
<input type="hidden" name="op" value="set_option" />
</form>
<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
<p class="submit">
<input type="submit" value="<?php _e('設定をリセットする', $this->i18nDomain); ?>" />
</p>
<input type="hidden" name="op" value="reset_option" />
</form>

<h2><?php _e('パラメーター', $this->i18nDomain); ?></h2>
<p><?php _e('　テンプレートタグにパラメーターを与えることによって、管理画面での設定を上書きすることができます。パラメーターは、次のような形式の文字列です。', $this->i18nDomain); ?></p>
<p><samp title="<?php _e('パラメーターサンプルコード', $this->i18nDomain); ?>"><code><?php _e('option1=value1&amp;option2=value12&amp;option3=value13', $this->i18nDomain); ?></code></samp></p>
<p><?php _e('　パラメーターが同じオプションを複数含む場合は、最後のものが有効となります。', $this->i18nDomain); ?></p>

<h2><?php _e('テンプレートタグ', $this->i18nDomain); ?></h2>
<p><?php _e('　テンプレートファイルにタグを書くことで、好みの位置にキーワードを表示することができます。<a href="http://codex.xwd.jp/index.php/The_Loop" charset="UTF-8" title="WPJ_Codex">WordPress ループ</a>の中に書きます。', $this->i18nDomain); ?></p>
<h3><code>$ywek->getKeyword()</code></h3>
<p><?php _e('　キーワードを値として返します。独自の処理を加えたい場合にはこちらがお勧めです。', $this->i18nDomain); ?></p>
<h4><?php _e('サンプルコード', $this->i18nDomain); ?></h4>
<samp><code>&lt;?php echo $ywek->getKeyword('return=string&amp;encode=url&amp;separator= '); ?&gt;</code></samp>
<p><?php _e('　半角スペースをセパレーターとして使用し、<abbr title="Uniform Resource Locator">URL</abbr> エンコードした文字列を表示します。<abbr title="Common Gateway Interface">CGI</abbr> などに値を渡すときに便利です。', $this->i18nDomain); ?></p>
<samp><code>&lt;?php echo $ywek->getKeyword('return=json&amp;select=2'); ?&gt;</code></samp>
<p><?php _e('　最大2つまでのキーワードを <abbr title="JavaScript Object Notation">JSON</abbr> 形式で表示します。JavaScript に値を渡すのに便利です。', $this->i18nDomain); ?></p>
<h3><code>$ywek->printKeyword()</code></h3>
<p><?php _e('　キーワードを文字列形式で表示します。値を返す代わりに表示するようにした <code>getKeyword</code> で、同じパラメーターが使えます。', $this->i18nDomain); ?></p>
<h4><?php _e('サンプルコード', $this->i18nDomain); ?></h4>
<samp><code>&lt;?php $ywek->printKeyword('return=string&amp;encode=url&amp;separator= '); ?&gt;</code></samp>
<p><?php _e('　<code>getKeyword</code> の1つ目のサンプルを書き換えたものです。画面表示のための <code>echo</code> が不要になります。', $this->i18nDomain); ?></p>
<samp><code>&lt;?php $ywek->printKeyword('return=array&amp;encode=url&amp;separator= '); ?&gt;</code></samp>
<p><?php _e('　配列で返すように指定しています。この場合は、<abbr title="PHP: Hypertext Preprocessor">PHP</abbr> の組み込み関数 <code><a href="http://www.php.net/print_r" title="PHP オンラインマニュアル">print_r</a></code> によって表示されます。', $this->i18nDomain); ?></p>
<h2><?php _e('Tips', $this->i18nDomain); ?></h2>
<p><?php _e('　タグを使う部分を次のように <code>if</code> で囲むことで、プラグインがなくてもテンプレートがエラーにならずにすみます。', $this->i18nDomain); ?></p>
<samp><code>
&lt;?php if ( isset($ywek) ) : ?&gt;<br />
&lt;?php $ywek->printKeyword(); ?&gt;<br />
&lt;?php endif; ?&gt;
</code></samp>
</div>
<?php
	}
} // class WpEntryKeyword End


// プラグインオプションクラス
class Option
{
	var $options;										// プラグインオプション

	/**
	 * コンストラクタ
	 */
	function Option()
	{
	}

	/**
	 * 自分自身のプラグインオプション値を得る
	 *
	 * @param string $name オプション名
	 * @return mixed オプション値
	 *
	 */
	function getOption($name)
	{
		return $this->options[$name];
	}

	/**
	 * 自分自身のすべてのプラグインオプション値を得る
	 *
	 * @return mixed オプション値
	 *
	 */
	function getAllOptions()
	{
		return $this->options;
	}

	/**
	 * 自分自身のプラグインオプション値を設定する
	 *
	 * @param string $name オプション名
	 * @param mixed $value 値
	 * @return void
	 *
	 */
	function setOption($name, $value)
	{
		$this->options[$name] = $value;
	}

	/**
	 * 自分自身のプラグインオプション値をクリアする
	 *
	 * @return void
	 *
	 */
	function resetOption()
	{
		$this->options = array();
	}


	/**
	 * パラメーターによる上書き
	 *
	 * @param string $param パラメーター
	 * @return void
	 *
	 */
	function optionOverwrite($param = '')
	{
		// パラメーターオプションの初期化
		if ( $param != '' )
		{
			foreach ( explode('&', $param) as $option )
			{
				list($name, $value) = explode('=', $option);
				$this->setOption($name, $value);
			}
		}
	}
} // class Option End
?>