<?php
/*
Plugin Name: Feed Control Plus
Version:     1.0
Plugin URI:  http://yskin.net/projects/feed-control-plus/
Description: Allows you to control the feeds that WordPress generates. Add pages to feeds, set the rule for sort and exclude or include specific posts.
Author:      Yskin
Author URI:  http://yskin.net/

Thanks to Feed Control(http://www.silpstream.com/blog/).

License
=============================================================================
Copyright (C) 2006 yskin (email: yskins@gmail.com)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
//11.17设计
//11.22完工

register_activation_hook(__FILE__, 'fcp_activate');
register_deactivation_hook(__FILE__,'fcp_deactivate');

function fcp_activate() {
	if ( get_option("feedcontrolplus") == false ) {
		$options = array(
			'cat_feed_posts'   => intval(get_option('posts_per_rss')), //post limit in category feed
			'comments_per_rss' => intval(get_option('posts_per_rss')), //comment limit in comment feed
			'posts_per_rss'    => 10,      //post limit in main feed
			'what_to_show'     => 'posts', //posts or days
			'postsort'         => 0,       //post sort, 0=>publish date, 1=>modified date, 2=>post ID
			'page'             => false,   //Include page
			'pages_per_rss'    => 3,       //page limit in main feed
			'pagesort'         => 1,       //page sort, 0=>publish date, 1=>modified date, 2=>post ID
			'exclude'          => '',      //exclude ID
			'include'          => ''       //include ID
		);
		update_option("feedcontrolplus", $options);
	}
}

function fcp_deactivate() {
	//delete_option("feedcontrolplus");
}

load_plugin_textdomain('fcp');

add_filter('option_posts_per_rss', 'fcp_post_per_rss' );

function fcp_post_per_rss($value) {
	global $withcomments;

	if ( !is_feed() ) return $value; //admin page

	$fc = get_option('feedcontrolplus');
	if ( $withcomments == 1 ) return $fc['comments_per_rss']; //main comment feed and post comment feed
	if ( is_archive() ) return $fc['cat_feed_posts']; //categories feed
	return 999; //for <code>if ($items_count == get_settings('posts_per_rss'))</code> at the end of wp-rss2.php
}

add_filter('posts_request', 'fcp_posts_request');

function fcp_posts_request($request) {
	global $withcomments;
	if ( !is_feed() || ($withcomments==1) || is_attachment() || is_archive() || is_single() || is_page() || is_search() || is_home() || is_trackback() || is_404() || is_admin() || is_comments_popup() ) {
		return $request;
	} else {
		$fcp_pr = new Fcp_pr();
		return $fcp_pr->get_request($request);
	}
}

class Fcp_pr {
	var $fc;
	var $now;
	var $sort = array(
			0 => 'post_date_gmt',
			1 => 'post_modified_gmt',
			2 => 'ID'
		);
	var $where_exclude;

	function Fcp_pr() {
		global $wpdb;

		$this->fc = get_option('feedcontrolplus');
		$this->now = current_time('mysql', 1);

		//set where_exclude
		$where_exclude = '';
		if ( !empty($this->fc['exclude']) ) {
			$excludes = explode(',', $this->fc['exclude']);
			if ( count($excludes) ) {
				foreach ( $excludes as $exclude ) {
					if (strpos($exclude, '-')==false) {
						$where_exclude .= " AND $wpdb->posts.ID <> " . intval($exclude);
					} else {
						$pos   = strpos($exclude, '-');
						$first = intval( substr($exclude, 0, $pos) );
						$last  = intval( substr($exclude, $pos+1) );
						$where_exclude .= " AND ($wpdb->posts.ID < $first OR $wpdb->posts.ID > $last)";
					}
				}
			}
		}
		$this->where_exclude = $where_exclude;
	}

	function get_request($request) {
		$requests = array();

		$requests[] = $this->get_post();
		if ( $this->fc['page'] )
			$requests[] = $this->get_page();
		if ( !empty($this->fc['include']) )
			$requests[] = $this->get_include();

		$request = '(' . implode(') UNION (', $requests) . ')';

		return $request;
	}

	function get_post() {
		global $wpdb;

		$where = " AND post_date_gmt <= '{$this->now}'";
		$where .= " AND post_status = 'publish'";
		$where .= $this->where_exclude;
		$orderby = $this->sort[$this->fc['postsort']];

		if ( $this->fc['what_to_show'] == 'posts' ) {
			$limit = ' LIMIT 0, ' . $this->fc['posts_per_rss'];
		} else {
			$endrow = $this->fc['posts_per_rss'] - 1;
			$post_date = ($this->fc['postsort']==1) ? 'post_modified' : 'post_date';
			$end_date = $wpdb->get_var("SELECT min($post_date) FROM $wpdb->posts WHERE post_date_gmt <= '{$this->now}' AND post_status = 'publish'{$this->where_exclude} GROUP BY year($post_date), month($post_date), dayofmonth($post_date) ORDER BY $post_date DESC LIMIT $endrow,1");
			$where .= " AND $post_date >= '$end_date'";
			$limit = ' LIMIT 999'; //If don't add this, the SQL result order will be error. Fix MySQL UNION order error
		}

		return "SELECT DISTINCT * FROM $wpdb->posts WHERE 1=1$where GROUP BY ID ORDER BY $orderby DESC$limit";
		//SELECT DISTINCT * FROM wp_posts  WHERE 1=1 AND post_date_gmt <= '2006-11-18 12:03:59' AND (post_status = "publish" OR post_author = 1 AND post_status != 'draft' AND post_status != 'static') AND post_status != "attachment" GROUP BY  wp_posts.ID  ORDER BY post_date DESC LIMIT 0, 10
		//$request = " SELECT * FROM $wpdb->posts WHERE 1=1" . $where . " ORDER BY " . $orderby . " DESC LIMIT 0, " . $limit;
	}

	function get_page() {
		global $wpdb;

		$where = " AND post_date_gmt <= '{$this->now}'";
		$where .= " AND post_status = 'static'";
		$where .= $this->where_exclude;
		$orderby = $this->sort[$this->fc['pagesort']];

		return "SELECT DISTINCT * FROM $wpdb->posts WHERE 1=1$where GROUP BY ID ORDER BY $orderby DESC LIMIT 0, " . $this->fc['pages_per_rss'];
	}

	function get_include() {
		global $wpdb;

		$where = '';
		$includes = explode(',', $this->fc['include']);
		if ( count($includes) ) {
			foreach ( $includes as $include ) {
				if (strpos($include, '-')==false) {
					$where .= " OR $wpdb->posts.ID = " . intval($include);
				} else {
					$pos   = strpos($include, '-');
					$first = intval( substr($include, 0, $pos) );
					$last  = intval( substr($include, $pos+1) );
					$where .= " OR ($wpdb->posts.ID >= $first AND $wpdb->posts.ID <= $last)";
				}
			}
		}

		return "SELECT DISTINCT * FROM $wpdb->posts WHERE 1=0$where GROUP BY ID";
	}

} //end of class Fcp_pr

add_action('admin_menu', 'fcp_add_option_page');

function fcp_add_option_page() {
	if ( function_exists('add_options_page') ) {
		 add_options_page('Feed Control Plus Settings', 'Feed Control+', 8, __FILE__, 'fcp_option_page');
	}
}

function fcp_option_page() {
	global $wpdb;
	if ( isset($_POST['Submit']) ) {
		$options = array();
		$options['cat_feed_posts']   = (int) $_POST['cat_feed_posts'];
		$options['comments_per_rss'] = (int) $_POST['comments_per_rss'];
		$options['posts_per_rss']    = (int) $_POST['posts_per_rss'];
		$options['what_to_show']     = (string) $_POST['what_to_show'];
		$options['postsort']         = (int) $_POST['postsort'];
		$options['page']             = (bool) $_POST['page'];
		$options['pages_per_rss']    = (int) $_POST['pages_per_rss'];
		$options['pagesort']         = (int) $_POST['pagesort'];
		$options['exclude']          = fcp_option_optimize( (string) $_POST['exclude'] );
		$options['include']          = fcp_option_optimize( (string) $_POST['include'] );

		update_option('feedcontrolplus', $options);
?>
<div id="message" class="updated fade"><p><?php _e('Feed Control Plus settings updated...', 'fcp'); ?></p></div>
<?php
	}

	$fc = get_option('feedcontrolplus');
	$fcp_pr = new Fcp_pr();
?>

<div class='wrap'>
<h2 id="edit-settings"><?php _e('Feed Control Plus Settings', 'fcp') ?> <small class="quickjump"><a href="#preview-rss"><?php _e('RSS2 Preview', 'fcp') ?> &darr;</a></small></h2>
<em><?php _e('For information and new versions, visit <a href="http://yskin.net/projects/feed-control-plus/">this plugin\'s page</a>.', 'fcp') ?></em>

<form method="post" action="<?php echo $_SERVER["REQUEST_URI"]; ?>">

	<h3><?php _e('Category feed &amp; Comment feed', 'fcp') ?></h3>
	<table width="100%" border="0" cellspacing="0" cellpadding="6">

	<tr><th width="33%" valign="top" align="right" scope="row"><?php _e('Post limit in category feed:', 'fcp') ?></th><td valign="top">
		<input type="text" name="cat_feed_posts" size="3" style="text-align:center; padding-right:6px" value="<?php echo $fc['cat_feed_posts']; ?>" />
	</td></tr>

	<tr><th width="33%" valign="top" align="right" scope="row"><?php _e('Comment limit in comment feed:', 'fcp') ?></th><td valign="top">
		<input type="text" name="comments_per_rss" size="3" style="text-align:center; padding-right:6px" value="<?php echo $fc['comments_per_rss']; ?>" /><br />
		<?php _e('Affect main comment feed and per-post comment feed.', 'fcp') ?>
	</td></tr>

	</table>

	<hr />
	<em><?php printf( __('Setting below only affects the main feed of your blog. (i.e. %1$s and %2$s)', 'fcp'), get_bloginfo('rss2_url'), get_bloginfo('atom_url') ) ?> </em>

	<h3><?php _e('Post in feed', 'fcp') ?></h3>
	<table width="100%" border="0" cellspacing="0" cellpadding="6">

	<tr><th width="33%" valign="top" align="right" scope="row"><?php _e('Post limit:', 'fcp') ?></th><td valign="top">
	<input type="text" name="posts_per_rss" size="3" style="text-align:center; padding-right:6px" value="<?php echo $fc['posts_per_rss']; ?>" />
	<select name="what_to_show">
		<option value="posts"<?php selected('posts', $fc['what_to_show']); ?>><?php _e('posts', 'fcp') ?></option>
		<option value="days"<?php selected('days', $fc['what_to_show']); ?>><?php _e('days', 'fcp') ?></option>
	</select>
	</td></tr>

	<tr><th width="33%" valign="top" align="right" scope="row"><?php _e('Post sort by:', 'fcp') ?></th><td valign="top">
	<select name="postsort">
		<option value="0"<?php selected(0, $fc['postsort']); ?>><?php _e('publish date', 'fcp') ?></option>
		<option value="1"<?php selected(1, $fc['postsort']); ?>><?php _e('modified date', 'fcp') ?></option>
		<option value="2"<?php selected(2, $fc['postsort']); ?>><?php _e('post ID', 'fcp') ?></option>
	</select>
	</td></tr>
<?php
if ( !empty($fc['posts_per_rss']) ) {
	echo '<tr><th width="33%" valign="top" align="right" scope="row">' . __('Posts in feed:', 'fcp') . '</th><td valign="top">';
	$fcp_post_request = $fcp_pr->get_post();
	$result = $wpdb->get_results($fcp_post_request);
	$posts = fcp_get_id($result);
	foreach ( $posts as $id ) {
		$post = get_post($id);
		echo $id . '. <a href="' . get_permalink($id) . '" target="_blank">' . $post->post_title . '</a> <small>(' . ( ($fc['postsort']==1) ? (__('Modified at ', 'fcp') . mysql2date('Y-m-d G:i', $post->post_modified)) : (__('Publish at ', 'fcp') . mysql2date('Y-m-d G:i', $post->post_date)) ) . ')</small><br />';
	}
	echo '</td></tr>';
}
?>
	</table>

	<h3><?php _e('Page in feed', 'fcp') ?></h3>
	<table width="100%" border="0" cellspacing="0" cellpadding="6">

	<tr><th width="33%" valign="top" align="right" scope="row"><?php _e('Include pages:', 'fcp') ?></th><td valign="top">
		<input type="checkbox" name="page" value="checkbox"<?php checked(true, $fc['page']); ?> />
	</td></tr>

	<tr><th width="33%" valign="top" align="right" scope="row"><?php _e('Page limit:', 'fcp') ?></th><td valign="top">
		<input type="text" name="pages_per_rss" size="3" style="text-align:center; padding-right:6px" value="<?php echo $fc['pages_per_rss']; ?>" />
	</td></tr>

	<tr><th width="33%" valign="top" align="right" scope="row"><?php _e('Page sort by:', 'fcp') ?></th><td valign="top">
	<select name="pagesort">
		<option value="0"<?php selected(0, $fc['pagesort']); ?>><?php _e('publish date', 'fcp') ?></option>
		<option value="1"<?php selected(1, $fc['pagesort']); ?>><?php _e('modified date', 'fcp') ?></option>
		<option value="2"<?php selected(2, $fc['pagesort']); ?>><?php _e('post ID', 'fcp') ?></option>
	</select>
	</td></tr>

<?php
if ( $fc['page'] ) {
	echo '<tr><th width="33%" valign="top" align="right" scope="row">' . __('Pages in feed:', 'fcp') . '</th><td valign="top">';
	$fcp_page_request = $fcp_pr->get_page();
	$result = $wpdb->get_results($fcp_page_request);
	$pages = fcp_get_id($result);
	foreach ( $pages as $id ) {
		$post = get_post($id);
		echo $id . '. <a href="' . get_permalink($id) . '" target="_blank">' . $post->post_title . '</a> <small>(' . ( ($fc['postsort']!=1) ? (__('Publish at ', 'fcp') . mysql2date('Y-m-d G:i', $post->post_date)) : (__('Modified at ', 'fcp') . mysql2date('Y-m-d G:i', $post->post_modified)) ) . ')</small><br />';
	}
	echo '</td></tr>';
}
?>
	</table>

	<h3><?php _e('Exclude', 'fcp') ?></h3>
	<table width="100%" border="0" cellspacing="0" cellpadding="6">

	<tr><th width="33%" valign="top" align="right" scope="row"><?php _e('Exclude:', 'fcp') ?></th><td valign="top">
		<input type="text" name="exclude" size="50" value="<?php echo $fc['exclude']; ?>" /><br />
		<?php _e('Hide the posts or pages you don\'t want in the feed.', 'fcp') ?>
		<br />
		<?php _e('(To specify a range of IDs, separate the IDs with a hyphen. Separate multiple IDs or ranges of IDs with a comma or a space between each ID or range of IDs. Example: "4-8,9,11".)', 'fcp') ?>
	</td></tr>
<?php
$fcp_pr->where_exclude = ''; //clear exclude, and than get IDs.

$fcp_post_request = $fcp_pr->get_post();
$result = $wpdb->get_results($fcp_post_request);
$posts = fcp_get_id($result);

if ($fc['page']) {
	$fcp_page_request = $fcp_pr->get_page();
	$result = $wpdb->get_results($fcp_page_request);
	$pages = fcp_get_id($result);
}
$post_page = array_merge($posts, $pages);

if ( !empty($fc['exclude']) ) {
	echo '<tr><th width="33%" valign="top" align="right" scope="row">' . __('Excluded posts/pages:', 'fcp') . '</th><td valign="top">';

	$excludes = explode(',', $fc['exclude']);
	$excludes = fcp_spread($excludes);
	$exclude_tip = false;
	foreach ( $excludes as $id ) {
		$post = get_post($id);
		$id_style = '';
		if ( !in_array($id, $post_page) or (!$fc['page'] && ($post->post_status == 'static')) ) {
			$id_style = ' style="color:#A0A0A0"';
			$exclude_tip = true;
  		}
		echo "<span$id_style>" . $id . '.</span> <a href="' . get_permalink($id) . '" target="_blank">' . $post->post_title . '</a> <small>(' . fcp_posttype($post->post_status) . ')</small><br />';
	}

	echo '<br />';
	if ($exclude_tip) printf(__("The grey IDs are not in the newest %1\$s posts", 'fcp') . ( $fc['page'] ? (__(" and %2\$s pages", 'fcp')) : '' ) . __('.', 'fcp'), $fc['posts_per_rss'], $fc['pages_per_rss']);
	echo '</td></tr>';
}
?>
	</table>

	<h3><?php _e('Include', 'fcp') ?></h3>
	<table width="100%" border="0" cellspacing="0" cellpadding="6">

	<tr><th width="33%" valign="top" align="right" scope="row"><?php _e('Include:', 'fcp') ?></th><td valign="top">
		<input type="text" name="include" size="50" value="<?php echo $fc['include']; ?>" /><br />
		<?php _e('Include the posts or pages you want in the feed.', 'fcp') ?>
	</td></tr>
<?php
if ( !empty($fc['include']) ) {
	echo '<tr><th width="33%" valign="top" align="right" scope="row">' . __('Included posts/pages:', 'fcp') . '</th><td valign="top">';
	$includes = explode(',', $fc['include']);
	$includes = fcp_spread($includes);
	$include_tip = false;
	foreach ( $includes as $id ) {
		$post = get_post($id);
		$id_style = '';
		if ( in_array($id, $post_page) ) {
			$id_style = ' style="color:#A0A0A0"';
			$include_tip = true;
  		}
		echo "<span$id_style>" . $id . '.</span> <a href="' . get_permalink($id) . '" target="_blank">' . $post->post_title . '</a> <small>(' . fcp_posttype($post->post_status) . ')</small>' . ( (isset($excludes) && in_array($id, $excludes)) ? '<br /><span style="color:red">' . __('Warning: ID ', 'fcp') . $id . __(' is also excluded!', 'fcp') . '</span>' : '' ) . '<br />';
	}

	echo '<br />';
	if ($include_tip) printf(__("The grey IDs are now already in the newest %1\$s posts", 'fcp') . ( $fc['page'] ? (__(" and %2\$s pages", 'fcp')) : '' ) . __('.', 'fcp'), $fc['posts_per_rss'], $fc['pages_per_rss']);
	echo '</td></tr>';
}
?>

	</table>
<?php
//$fcp_pr = new Fcp_pr(); echo $fcp_pr->get_request(''); //debug
?>
	<p class="submit"><input type="submit" name="Submit" value="<?php _e('Update Options') ?> &raquo;" /></p>
</form>
</div>

<div id='preview' class='wrap'>
	<h2 id="preview-rss"><?php _e('RSS2 Preview' ,'fcp') ?></h2>
	<iframe src="<?php echo add_query_arg('preview', 'true', get_feed_link()); ?>" width="100%" height="600"></iframe>
</div>
<?php
} //End of fcp_add_option_page

//Check post type
function fcp_posttype($post_status) {
	$type = array(
		'publish'    => __('post', 'fcp'),
		'static'     => __('page', 'fcp'),
		'draft'      => __('draft', 'fcp'),
		'private'    => __('private', 'fcp'),
		'object'     => __('object', 'fcp'),
		'attachment' => __('attachment', 'fcp')
	);
	return isset($type[$post_status]) ? $type[$post_status] : $post_status;
}

//Optimize exclude string and include string.
function fcp_option_optimize($exclude) {
	$excludes = preg_split( '/[\s,]+/',preg_replace("/[^\s\d,-]/", '', $exclude) );
	$excludes = array_unique($excludes);
	sort($excludes);
	if ($excludes[0]=='') unset($excludes[0]);
	return implode($excludes, ',');
}

//Spread string into IDs.
function fcp_spread($ids) {
	$result = array();
	foreach ($ids as $id) {
		if ( strpos($id, '-')==false ) {
			$result[] = intval($id);
		} else {
			$pos   = strpos($id, '-');
			$first = intval( substr($id, 0, $pos) );
			$last  = intval( substr($id, $pos+1) );
			$result = array_merge( $result, range($first, $last) );
		}
	}
	return array_unique($result);
}

function fcp_get_id($result) {
	$ids = array();
	foreach ($result as $i => $id)
		$ids[$i] = $result[$i]->ID;
	return $ids;
}
?>