<?php
/* 
Plugin Name: wp-AT
Plugin URI: http://wppluginsj.sourceforge.jp/wp-at/
Description: wp-AT adds the ability to search and include items from AccessTrade to your entries. This plugin adds a button called "wp_AT" on the post page. Make sure to configure the plugin before using.  
Author: Sa.Ga
Version: 1.0 Beta 3
Author URI:  http://blog2.atsj.net/
*/

/**
 * wp-AT.php:
 * wp-AT main routine.
 * 
 * @author Sa.Ga
 * @version 1.0 Beta 3
 */

/*  Copyright 2006 Sa.Ga

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
 * WpKoyomi function define...
 */
if (class_exists('WP_AT')) {
	$wpAt = & new WP_AT();
}

/**
 * main class
 */
class WP_AT {

	var $version;
	var $wsType;
	var $wsVer;
	var $wsID;
	var $category1;
	var $category2;
	var $category3;
	var $category4;
	var $shop;
	var $search;
	var $priceMax;
	var $priceMin;
	var $row;
	var $page;
	var $sort1;
	var $sort2;
	var $sort3;

	/**
	 * main function of wp-AT
	 */
	function wp_AT() {
		require_once('class/wp-AT-function.php');
		// load i18n translations
		load_plugin_textdomain('wp_AT', 'wp-content/plugins/wp-AT');

		// initialize all the variables
		$this->version = '1.0';
		$this->plugin_home_url = 'http://wppluginsj.sourceforge.jp/wp-at/';
		$this->wsType = get_option('wpat_ws_type');
		$this->wsVer = get_option('wpat_ws_ver');
		$this->wsID = get_option('wpat_ws_id');
		$this->category1 = get_option('wpat_category1');
		$this->category2 = get_option('wpat_category2');
		$this->category3 = get_option('wpat_category3');
		$this->category4 = get_option('wpat_category4');
		$this->shop = get_option('wpat_shop');
		$this->search = get_option('wpat_search');
		$this->priceMax = get_option('wpat_price_max');
		$this->priceMin = get_option('wpat_price_min');
		$this->row = get_option('wpat_row');
		$this->page = get_option('wpat_page');
		$this->sort1 = get_option('wpat_sort1');
		$this->sort2 = get_option('wpat_sort2');
		$this->sort3 = get_option('wpat_sort3');

		// Set defaults if properties aren't set
		if (!$this->wsVer) {
			update_option('wpat_ws_ver', '1');
		}
		if (!$this->wsType) {
			update_option('wpat_ws_type', 'searchgoods');
		}
		if (!$this->wsID) {
			update_option('wpat_ws_id', '3D45BF6BAB4C7FADC650D67424922D9229056');
		}
		
		$wag = new WP_AT_GoodsList();
		$goodsTemplate = get_option('wpat_goods_template');
		if (!$goodsTemplate) {
			$wag->resetTemplate();
		}
	}

	/**
	 * user interface of admin page
	 */
	function adminPage() {

		require_once('class/wp-AT-function.php');
		$wac = new WP_AT_Contents();
		WP_AT_Contents::getCSS();

		if (isset($_POST['wpat_submitted'])) {
			update_option('wpat_ws_ver', $_POST['wpat_ws_ver']);
			update_option('wpat_ws_type', $_POST['wpat_ws_type']);
			update_option('wpat_ws_id', $_POST['wpat_ws_id']);
			//get any new variables
			$this->wp_AT();
			echo '<div class="updated"><p><strong>' . __('¸ޤ', 'wp_AT') . '</strong></p></div>';
		}

		$this->wsVer = get_option('wpat_ws_ver');
		$this->wsType = get_option('wpat_ws_type');
		$this->wsID = get_option('wpat_ws_id');

		$formaction = $_SERVER['PHP_SELF'] . "?page=wp-AT.php";

// Start outputting XHMTL
?>
	<div id="wpATSubMenu">
		<ul class="wpATTab">
			<li><a href="<?php echo $formaction ?>"<?php echo $_REQUEST['wpATTab'] == '' ? ' class="current"' : ''  ?>><?php _e('', 'wp_AT'); ?></a></li>
			<li><a href="<?php echo $formaction. '&wpATTab=goodsList' ?>"<?php echo $_REQUEST['wpATTab'] == 'goodsList' ? ' class="current"' : ''  ?>><?php _e('ʥꥹ', 'wp_AT'); ?></a></li>
		</ul>
	</div>
<?php
		switch ($_REQUEST['wpATTab']) {
			case 'goodsList':
?>
	<div id="wpATGoodsManager">
		<div class="wrap">
<?php
$was = new WP_AT_Search();
$data = $was->data;
$result = $was->result;
?>
<?php
if (isset($_REQUEST['addList'])) {
	$wag = new WP_AT_GoodsList();
	$errMsg = $wag->add($data);
	if ($errMsg) {
?>		
<div class="error">
<?php echo $errMsg ?>&nbsp;
</div>
<?php
	} else {
?>		
<div class="updated">
<?php _e('ꥹȤ˾ʤɲäޤ', 'wp_AT') ?>&nbsp;
<?php
		$wpAtGoodsList = get_option('wpat_goods_list');
		if (count($wpAtGoodsList) >= GOODS_LIST_MAX_SIZE) {
			$msg = __('ϿǡʥꥹȤη', 'wp_AT')
			. GOODS_LIST_MAX_SIZE
			. __('ãޤ', 'wp_AT');
			echo '<br />'. $msg;
		}
?>
</div>
<?php
	}
} elseif (isset($_REQUEST['doAction'])) {
	$wag = new WP_AT_GoodsList();
	if ($wag->editList($data)) {
?>		
<div class="updated">
<?php _e('ʥꥹȤ򹹿ޤ', 'wp_AT') ?>&nbsp;
</div>
<?php
	}
} elseif (isset($_REQUEST['editTemplate'])) {
	$wag = new WP_AT_GoodsList();
	if ($wag->editTemplate($data)) {
?>		
<div class="updated">
<?php _e('ʥꥹȥƥץ졼Ȥ򹹿ޤ', 'wp_AT') ?>&nbsp;
</div>
<?php
	}
} elseif (isset($_REQUEST['resetTemplate'])) {
	$wag = new WP_AT_GoodsList();
	$wag->resetTemplate();
?>		
<div class="updated">
<?php _e('ʥꥹȥƥץ졼Ȥޤ', 'wp_AT') ?>&nbsp;
</div>
<?php
}
?>
			<div id="wpATGoodsList">
				<div class="wrap">
					<h2><?php _e('ϿѤ߾ʥꥹȤΥץӥ塼', 'wp_AT') ?></h2>
<?php
					$goodsList = get_option('wpat_goods_list');
					$this->echoGoodsList($goodsList);
?>
				</div>
			</div>
			<div id="wpATGoodsListSetting">
			<h2><?php _e('ʸ', 'wp_AT'); ?></h2>
			<script type="text/javascript">
			<!--
			var viewSettings = new Array();
			// -->
			</script>
<form action="<?php echo $_SERVER['PHP_SELF'] ?>?page=wp-AT.php" method="post">
<div>
<?php $was->parseCategory($data['category']); ?>
<input type="hidden" name="row" value="10" />
<input type="hidden" name="wpATTab" value="goodsList" />
<input type="text" name="keyword" value="<?php echo $data['keyword'] ?>" size="32" maxlength="128" />
<input type="submit" name="search" value="<?php _e('ʸ', 'wp_AT'); ?>" />
</div>
</form>
<?php
if (isset($_REQUEST['search'])) {
	if ($result['errormsg'] != null) {
?>
<div class="error">
<?php echo $result['errorcode'] ?>&nbsp;
<?php echo $result['errormsg'] ?>
</div>
<?php
	} elseif (intval($result['totalcount']) == 0) {
?>
<div class="error">
<?php _e('ʤĤޤ', 'wp_AT'); ?>
</div>
<?php
	} else {
		$was->createPager($result, 'page=wp-AT.php&wpATTab=goodsList');
?>
<table>
<?php
		$resIDs = array();
		for ($i = 0; $i < count($result['goods']); $i++) {
			$item = $result['goods'][$i];
			$size = $was->calcImageSize($item['width'], $item['height']);
			$resID = ($result['currentpage'] - 1) * $data['row'] + $i + 1;
			$resIDs[] = $resID;
?>
<tr>
<th><?php echo $resID ?>.</th>
<td>
<div>
<span id="virtualToggle_id_<?php echo $resID ?>_setting"></span>
<?php echo $item['goodsname'] ?>
</div>
<div id="id_<?php echo $resID ?>_setting" class="wrap">
<p><?php _e('ȥ꡼̾ˤϼưǥ󥯤ޤޤޤ', 'wp_AT') ?></p>
<form id="id_<?php echo $resID ?>_form" action="<?php echo $_SERVER['PHP_SELF'] ?>?page=wp-AT.php" method="post">
<dl>
<dt><?php _e('', 'wp_AT') ?></dt>
<dd><a href="<?php echo $item['imageurl'] ?>" target="_blank"><img src="<?php echo $item['imageurl'] ?>" width="<?php echo $size['width'] ?>" height="<?php echo $size['height'] ?>" alt="<?php _e('[image] (full size)', 'wp_AT') ?>" /></a></dd>
<dt><?php _e('᡼', 'wp_AT') ?></dt>
<dd><?php echo $item['maker'] ?></dd>
<dt><?php _e('̾', 'wp_AT') ?></dt>
<dd><a href="<?php echo $item['linkcode'] ?>" target="_blank"><?php echo $item['goodsname'] ?></a></dd>
<dt><?php _e('ǹ', 'wp_AT') ?></dt>
<dd>&yen;<?php echo $item['price'] ?></dd>
<dt><?php _e('', 'wp_AT') ?></dt>
<dd><?php echo $item['explanation'] ?></dd>
<dt><?php _e('', 'wp_AT') ?></dt>
<dd><?php echo $item['goodscode'] ?></dd>
<dt><?php _e('JAN', 'wp_AT') ?></dt>
<dd><?php echo $item['jancode'] ?></dd>
<dt><?php _e('å̾', 'wp_AT') ?></dt>
<dd><?php echo $item['shopname'] ?></dd>
<dt><?php _e('󽷳ۡΨ', 'wp_AT') ?></dt>
<dd>&yen;<?php echo $item['reward'] ?> (<?php echo $item['rewardrate'] ?>%)</dd>
<dt><?php _e('Ǥե', 'wp_AT') ?></dt>
<dd><input type="text" name="userComment" value="" maxlength="256" style="width:100%;" /></dd>
</dl>
<div>
<input type="hidden" name="imageurl" value="<?php echo $item['imageurl'] ?>" />
<input type="hidden" name="maker" value="<?php echo $item['maker'] ?>" />
<input type="hidden" name="linkcode" value="<?php echo $item['linkcode'] ?>" />
<input type="hidden" name="goodsname" value="<?php echo $item['goodsname'] ?>" />
<input type="hidden" name="price" value="<?php echo $item['price'] ?>" />
<input type="hidden" name="explanation" value="<?php echo $item['explanation'] ?>" />
<input type="hidden" name="goodscode" value="<?php echo $item['goodscode'] ?>" />
<input type="hidden" name="jancode" value="<?php echo $item['jancode'] ?>" />
<input type="hidden" name="shopname" value="<?php echo $item['shopname'] ?>" />
<input type="hidden" name="width" value="<?php echo $item['width'] ?>" />
<input type="hidden" name="height" value="<?php echo $item['height'] ?>" />

<input type="hidden" name="row" value="10" />
<input type="hidden" name="wpATTab" value="goodsList" />
<input type="hidden" name="category" value="<?php echo $data['category'] ?>" />
<input type="hidden" name="keyword" value="<?php echo $data['keyword'] ?>" />
<input type="hidden" name="goodsPage" value="<?php echo $data['goodsPage'] ?>" />

<input type="hidden" name="search" value="2" />
<input type="submit" name="addList" value="<?php _e('ꥹȤϿ', 'wp_AT') ?>" />
</div>
</form>
</div>
</td>
</tr>
<?php
		}
?>
</table>
<script type="text/javascript">
<!--
function insertAtCursor(myField, myValue) {
	// IE support
	if (document.selection) {
		// only insert text for IE (not at cursor)
		myField.value += myValue;
	}
	// Mozilla/Netscape support
	else if (myField.selectionStart || myField.selectionStart == '0') {
		var startPos = myField.selectionStart;
		var endPos = myField.selectionEnd;
		myField.value = myField.value.substring(0, startPos)
			+ myValue
			+ myField.value.substring(endPos, myField.value.length);
	} else {
		myField.value += myValue;
	}
}
function generateHTMLCode(formObj) {
	var box = formObj.box;
	var htmlCode = formObj.htmlcode;
	var html = "";
	var checkedElse = false;
	if (box.length) {
		for (var i = 0; i < box.length; i++) {
			if (box[i].checked) {
				if (checkedElse) {
					html += "\n\n";
				} else {
					checkedElse = true;
				}
				html += box[i].value;
			}
		}
	} else {
		if (box.checked) {
			html = box.value;
		}
	}
	htmlCode.value = html;
	htmlCode.select();
}
// -->
</script>

<?php
		$wac->getJS($resIDs);
		$was->createPager($result, 'page=wp-AT.php&wpATTab=goodsList');
	}
?>

<?php
}
?>
			<h2><?php _e('ʥꥹȤ', 'wp_AT') ?></h2>
			<h3><?php _e('ϿѤ߾ʰ', 'wp_AT') ?></h3>
<?php
			if (count($goodsList) == 0) {
				echo '<div>';
				_e('ꥹȤ˾ʤϿƤޤ', 'wp_AT');
				echo '</div>';
			} else {
?>
			<form action="<?php echo $_SERVER['PHP_SELF'] ?>?page=wp-AT.php" method="post">
				<select size="<?php echo GOODS_LIST_MAX_SIZE ?>" name="goodsList">
<?php
				$cnt = 0;
				foreach ($goodsList as $line) {
					echo '<option value="'. $cnt. '"';
					if ($cnt == 0) {
						echo ' selected="selected"';
					}
					echo '>';
					echo $line['goodsname']. ' / '. $line['shopname'];
					echo '</option>';
					$cnt++;
				}
?>
				</select>
<div><?php _e('򤷤ʤФΥ¹Ԥޤ', 'wp_AT') ?></div>
<div>
				<select name="goodsAction">
<?php
				$optionList = array();
				$optionList[] = __('־˰ư', 'wp_AT');
				$optionList[] = __('1ܤξʤβ˰ư', 'wp_AT');
				$optionList[] = __('2ܤξʤβ˰ư', 'wp_AT');
				$optionList[] = __('3ܤξʤβ˰ư', 'wp_AT');
				$optionList[] = __('4ܤξʤβ˰ư', 'wp_AT');
				$optionList[] = __('5ܤξʤβ˰ư', 'wp_AT');
				$optionList[] = __('6ܤξʤβ˰ư', 'wp_AT');
				$optionList[] = __('7ܤξʤβ˰ư', 'wp_AT');
				$optionList[] = __('8ܤξʤβ˰ư', 'wp_AT');
				$optionList[] = __('9ܤξʤβ˰ư', 'wp_AT');
				$optionList[] = __('10ܤξʤβ˰ư', 'wp_AT');
				for ($i = 0; $i <= $cnt; $i++) {
					echo '<option value="'. $i. '"';
					if ($i == 0) {
						echo ' selected="selected"';
					}
					echo '>';
					echo $optionList[$i];
					echo '</option>';
				}
?>
				<option value="-1"><?php _e('ꥹȤ', 'wp_AT') ?></option>
				</select>
</div>
<div>
<input type="submit" name="doAction" value="<?php _e('¹Ԥ', 'wp_AT') ?>" />
<input type="hidden" name="wpATTab" value="goodsList" />
</div>
			</form>
<?php
			}
			$goodsTemplateList = get_option('wpat_goods_template');
			$beforeTemplate = str_replace('\"', '"', $goodsTemplateList[0]);
			$goodsTemplate = str_replace('\"', '"', $goodsTemplateList[1]);
			$afterTemplate = str_replace('\"', '"', $goodsTemplateList[2]);
?>

			<h3><?php _e('ʥꥹȤν', 'wp_AT'); ?></h3>
			<form action="<?php echo $_SERVER['PHP_SELF'] ?>?page=wp-AT.php" method="post">
			<p><?php _e('ʤϡHTMLɤԽ뤳ȤˤɽǤޤ', 'wp_AT') ?></p>
			<p><?php _e('֥˾ʥꥹȤȿǤˤϡȤΥơޡƥץ졼Ȥ˼εҤɲäޤ', 'wp_AT') ?></p>
			<p><code>&lt;?php if(isset($wpAt)) $wpAt->echoGoodsList(); ?&gt;</code></p>
<div>
			<label for="beforeTemplate"><?php _e('ʥꥹȤľղäHTML', 'wp_AT') ?></label>
			<textarea name="beforeTemplate" id="beforeTemplate"><?php echo $beforeTemplate ?></textarea>
</div>
<div>
			<label for="goodsTemplate"><?php _e('ʥꥹȤHTML', 'wp_AT') ?></label>
			<textarea name="goodsTemplate" id="goodsTemplate"><?php echo $goodsTemplate ?></textarea>
</div>
<div>
			<label for="afterTemplate"><?php _e('ʥꥹȤľղäHTML', 'wp_AT') ?></label>
			<textarea name="afterTemplate" id="afterTemplate"><?php echo $afterTemplate ?></textarea>
</div>
<div>
<input type="submit" name="editTemplate" value="<?php _e('ƥץ졼Ȥ', 'wp_AT') ?>" />
<input type="submit" name="resetTemplate" value="<?php _e('ƥץ졼Ȥν', 'wp_AT') ?>" />
<input type="hidden" name="wpATTab" value="goodsList" />
</div>
			<p><?php _e('Ѳǽʥƥץ졼Ȥϼ̤Ǥ', 'wp_AT') ?><br />
			<?php _e('־ʥꥹȡפǤΤ߻ѲǽǤ', 'wp_AT') ?></p>
			<table>
			<thead>
			<tr><th><?php _e('', 'wp_AT') ?></th><th><?php _e('', 'wp_AT') ?></th>
			</tr>
			</thead>
			<tbody>
			<tr>
			<th>%imageurl</th>
			<td><?php _e('URL', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%maker</th>
			<td><?php _e('᡼', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%linkcode</th>
			<td><?php _e('եꥨȥ󥯥', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%goodsname</th>
			<td><?php _e('̾', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%price</th>
			<td><?php _e('ǹ', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%explanation</th>
			<td><?php _e('', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%goodscode</th>
			<td><?php _e('', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%jancode</th>
			<td><?php _e('JAN', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%shopname</th>
			<td><?php _e('å̾', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%userComment</th>
			<td><?php _e('Ǥե', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%width</th>
			<td><?php _e('β', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%height</th>
			<td><?php _e('ι⤵', 'wp_AT') ?></td>
			</tr>
			<tr>
			<th>%customWidth</th>
			<td>
<?php
_e('Ĺդ', 'wp_AT');
echo IMAGE_MAXSIZE;
_e('ԥĶˡɽȤβ', 'wp_AT');
?>
			</td>
			</tr>
			<tr>
			<th>%customHeight</th>
			<td>
<?php
_e('Ĺդ', 'wp_AT');
echo IMAGE_MAXSIZE;
_e('ԥĶˡɽȤι⤵', 'wp_AT');
?>
			</td>
			</tr>
			</tbody>
			</table>
			</form>
			</div>
		</div>
	</div>
<?php
			break;
			default:
?>
	<div is="wpATAdminMain">
		<div class="wrap">
			<h2><?php _e('&quot;wp-AT&quot;δ', 'wp_AT'); ?></h2>
		
			<p><?php _e('AccessTrade WebService饢եꥨȾʤ򸡺ȥ꡼ƤǤ褦ˤޤ', 'wp_AT'); ?></p>

		<form name="wpAT_options" method="post" action="<?php echo $formaction; ?>">
		<input type="hidden" name="wpat_submitted" value="1" />
			<fieldset class="options">
				<legend>
					<label><?php _e('ѡȥʡϿƤʤϡ餫餪ߤ', 'wp_AT'); ?></label>
				</legend>
				<input type="button" name="entryToAT" value="<?php _e('ѡȥʡϿ', 'wp_AT'); ?>" onclick="window.open('http://www.accesstrade.net/at/c.html?rk=01001aqa000mf4');" />
			</fieldset>

			<fieldset class="options">
				<legend>
					<label><?php _e('餫鸡ƥι򤪤ʤޤ', 'wp_AT'); ?></label>
				</legend>
				<input type="button" name="updateCategories" value="<?php _e('ƥι', 'wp_AT'); ?>"
				onclick="window.open('../wp-content/plugins/wp-AT/updateCategoryList.php', 'wpAtSubWindow', 'width=480,height=320,scrollbars=no'); return false;" />
			</fieldset>

			<fieldset class="options">
				<legend>
					<label><?php _e('ѥåIDϤ¸ȡȥ꡼Ʋ̤˾ʸѤΥեबɽޤ', 'wp_AT'); ?></label>
				</legend>
				<table width="100%" cellspacing="2" cellpadding="5" class="editform">
				<tr>
					<th width="33%" valign="top" scope="row">
						<label for="wpat_ws_ver"><?php _e('С:', 'wp_AT'); ?></label>
					</th>
					<td>
						<div><input name="wpat_ws_ver" type="text" id="wpat_ws_ver" value="<?php echo $this->wsVer; ?>" size="20" maxlength="10" /></div>
					</td>
				</tr>
				<tr>
					<th width="33%" valign="top" scope="row">
						<label for="wpat_ws_type"><?php _e('ӥ:', 'wp_AT'); ?></label>
					</th>
					<td>
						<div><input name="wpat_ws_type" type="text" id="wpat_ws_type" value="<?php echo $this->wsType; ?>" size="20" maxlength="20" /></div>
					</td>
				</tr>
				<tr>
					<th width="33%" valign="top" scope="row">
						<label for="wpat_ws_id"><?php _e('WS_ID:', 'wp_AT'); ?></label>
					</th>
					<td>
						<div><input name="wpat_ws_id" type="text" id="wpat_ws_id" value="<?php echo $this->wsID; ?>" size="50" maxlength="37" /></div>
						<dl>
						<dt><?php _e('ڤա', 'wp_AT') ?></dt>
						<dd><?php _e('WS_IDפϡȥ졼ɴ̤˥󤷤ƤWebӥڡ˽񤫤ƤWS_IDϤƤ', 'wp_AT') ?></dd>
						</dl>
					</td>
				</tr>
				</table>
			</fieldset>
			<p class="submit">
				<input type="submit" name="info_update" value="<?php _e('򹹿 &raquo;', 'wp_AT'); ?>" />
			</p>
		</form>
		</div>
	</div>
<?php
		}
	}

	/**
	 * Adds javascript function to launch a new window for the search page
	 */
	function addHead() {
		if( (!strstr($_SERVER['PHP_SELF'], 'post.php')
				&& !strstr($_SERVER['PHP_SELF'], 'page-new.php')
				) || $_GET["action"] == 'editcomment') {
	        return 0;
		}
	    ?>
			<script type="text/javascript">
			<!--
			function wpAtPopup(link, windowname) {
				if (!window.focus) return true;
				var href;
				if (typeof(link) == "string")
					href = link;
				else
					href = link.href;
				window.open(href, windowname, "width=600,height=600,scrollbars=yes");
				return false;
			}
			//-->
			</script>
	    <?php
	}

	/**
	 * open a new window for the search page
	 */
	function addLink() {
		if( (!strstr($_SERVER['PHP_SELF'], 'post.php')
				&& !strstr($_SERVER['PHP_SELF'], 'page-new.php')
				) || $_GET["action"] == 'editcomment' ) {
			return 0;
		}
		?>
	    	<div id="wp_AT" style="margin-bottom:10px;">
			<a href="../wp-content/plugins/wp-AT/index.php" onclick="return wpAtPopup(this, 'SearchAT');" target="_blank"><?php _e('AccessTradeξʥ󥯤', 'wp_AT') ?></a>
			</div>
			<script type="text/javascript">
			<!--
				var pingBack = document.getElementById("pingback");
				if (pingBack == null)
					var pingBack = document.getElementById("post_pingback");
				var wpAtLink = document.getElementById("wp_AT");
				pingBack.parentNode.insertBefore(wpAtLink, pingBack);
			//-->
			</script>
		<?php
	}

	/**
	 * wake up admin page
	 */
	function callAdminPage() {
		global $wp_AT;
		add_options_page(__('wp-AT Options', 'wp_AT'),
			__('wp-AT', 'wp_AT'), 10,
			basename(__FILE__), array(&$wp_AT, 'adminPage'));
	}

	/**
	 * display goods list
	 */
	function echoGoodsList($goodsList = null) {
		if ($goodsList == null) {
			$goodsList = get_option('wpat_goods_list');		
		}
		$was = new WP_AT_Search();
		$goodsTemplateList = get_option('wpat_goods_template');
		$beforeTemplate = str_replace('\"', '"', $goodsTemplateList[0]);
		$goodsTemplate = str_replace('\"', '"', $goodsTemplateList[1]);
		$afterTemplate = str_replace('\"', '"', $goodsTemplateList[2]);
	
		if ($goodsList == null || count($goodsList) == 0) {
			echo '<div>';
			_e('ꥹȤ˾ʤϿƤޤ', 'wp_AT');
			echo '</div>';
		} else {
			echo $beforeTemplate;
			foreach ($goodsList as $line) {
				$thisLine = $goodsTemplate;
				$thisLine = str_replace('%imageurl', trim($line['imageurl']), $thisLine);
				$thisLine = str_replace('%maker', trim($line['maker']), $thisLine);
				$thisLine = str_replace('%linkcode', trim($line['linkcode']), $thisLine);
				$thisLine = str_replace('%goodsname', trim($line['goodsname']), $thisLine);
				$thisLine = str_replace('%price', trim($line['price']), $thisLine);
				$thisLine = str_replace('%explanation', trim($line['explanation']), $thisLine);
				$thisLine = str_replace('%goodscode', trim($line['goodscode']), $thisLine);
				$thisLine = str_replace('%jancode', trim($line['jancode']), $thisLine);
				$thisLine = str_replace('%shopname', trim($line['shopname']), $thisLine);
				$thisLine = str_replace('%userComment',  trim($line['userComment']), $thisLine);
				$thisLine = str_replace('%width', trim($line['width']), $thisLine);
				$thisLine = str_replace('%height', trim($line['height']), $thisLine);
				$size = $was->calcImageSize($line['width'], $line['height']);
				$thisLine = str_replace('%customWidth', $size['width'], $thisLine);
				$thisLine = str_replace('%customHeight', $size['height'], $thisLine);
				echo $thisLine;
			}
			echo $afterTemplate;
		}
	}
}

// Add actions to call the function
add_action('plugins_loaded', create_function('$a', 'global $wp_AT; $wp_AT = new WP_AT;'));
add_action('admin_head', array(&$wp_AT, 'addHead'));
// add_action('simple_edit_form', array(&$wp_AT, 'addLink'));
// add_action('edit_form_advanced', array(&$wp_AT, 'addLink'));
add_action('admin_footer', array(&$wp_AT, 'addLink'));
add_action('admin_menu', array(&$wp_AT, 'callAdminPage'));

?>
