<?php
/*
Plugin Name: wp-mosquito
Plugin URI: http://wppluginsj.sourceforge.jp/wp-mosquito/
Description: The fastest, the lightest archive plugin for WordPress,
Author: hiromasa
Version: 1.30
Author URI: http://hiromasa.zone.ne.jp/blog/
Special Thanks: aka (http://plasticdreams.org/)
Special Thanks: kohaku (http://www.orioa.com/)
Special Thanks: tenpura
Bug Report: Sa.Ga (http://blog2.atsj.net/)
Bug Report: tackr9 (http://www.la-pensee.net/blog/2007/01/08/edit-wp-mosquito)
**/

/*  Copyright 2006 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WpMosquito
 * 
 * @author		hiromasa
 * @version		1.30
 * 
 *****************************************************************************/
class WpMosquito {
	
	var $cache_enable = false;
	var $cache_dir;
	var $permalink;
	var $homelink;
	var $file_pointer;
	
	/**
	 * the constructor
	 * 
	 * @param none
	 * @return none
	 */
	function WpMosquito() {
		
		$this->cache_dir = dirname(__FILE__) . '/cache/';
		
		if(is_dir($this->cache_dir)) {
			$this->cache_enable = true;
		}
		if(!preg_match('/wp-mosquito\/cache/', $this->cache_dir)) {
			$this->cache_enable = false;
		}
		
		if($this->cache_enable) return;
		
		$this->permalink = get_settings('permalink_structure');
		$this->homelink  = get_settings('home');
		
	}
	
	/**
	 * WpMosquito template tag
	 * 
	 * @param $header_open
	 * @param $header_close
	 * @param $from
	 * @param $to
	 * @param $format
	 * @return $none
	 */
	function mosquito_archive($header, $from, $to, $format) {
		
		$cache_filename =
			$this->cache_dir . md5($header . $from . $to . $format) . '.dat';
		
		if($this->cache_enable) {
			if(file_exists($cache_filename)) {
				echo "<!-- wp-mosquito cache start -->\n";
				@readfile($cache_filename);
				echo "<!-- wp-mosquito cache end -->\n";
				return;
			}
		}
		
		$header_open  = $header;
		preg_match('/<([0-9a-zA-Z]+)/', $header_open, $res);
		$header_close = '</'. $res[1]. '>';
		
		if($this->cache_enable) {
			if(!$this->file_pointer = fopen($cache_filename, 'w')) {
				$this->cache_enable = false;
			}
		}
		
		$this->makeArchive($header_open, $header_close, $from, $to, $format);
		
		if($this->cache_enable) {
			fclose($this->file_pointer);
		}
		
	}
	
	/**
	 * delete cache action
	 * 
	 * @param $none
	 * @return $none
	 */
	function deleteCache() {
		
		if(!$this->cache_enable) return;
		
		$cache_dir = opendir($this->cache_dir);
		while(($filename = readdir($cache_dir)) != false ) {
			if(is_file($this->cache_dir . $filename)) {
				 unlink($this->cache_dir . $filename);
			}
		}
		closedir($cache_dir);
		
	}
	
	/**
	 * make archive
	 * 
	 * @param $header_open
	 * @param $header_close
	 * @param $from
	 * @param $to
	 * @param $format
	 * @return none
	 */
	function makeArchive($header_open, $header_close, $from, $to, $format) {
		
		global $wpdb;
		
		$query =
			"SELECT " .
				"distinct year(post_date) as year " .
			"FROM " .
				"$wpdb->posts " .
			"WHERE " .
				"post_status='publish' AND " .
				"post_password='' AND " .
				$this->makeFromToSQL($from, $to) .
			"ORDER BY " .
				"year desc;";
		$years = $wpdb->get_results($query);
		
		if($years == '') return;
		
		foreach($years as $year) {
			
			$query =
				"SELECT " .
					"ID, " .
					"post_date, " .
					"post_name, " .
					"post_title, " .
					"post_author, " .
					"post_category, " .
					"year(post_date)  as year, " .
					"month(post_date) as month, " .
					"DATE_FORMAT(post_date, '%d') as day " .
				"FROM " .
					"$wpdb->posts " .
				"WHERE " .
					"year(post_date)='$year->year'  AND " .
					"post_status='publish'          AND " .
					"post_password='' AND " .
					$this->makeFromToSQL($from, $to) .
				"ORDER BY " .
					"post_date desc";
			$year_entrys = $wpdb->get_results($query);
			
			$outputHead = '';
			foreach($year_entrys as $entry) {
				
				$lm = strftime(
					$format,
					strtotime("$entry->month/$entry->day/$entry->year"));
				
				if($outputHead != "$header_open$lm$header_close\n") {
					if($outputHead != '') $this->outputHtml("</ol>\n") ;
					$outputHead = "$header_open$lm$header_close\n";
					$this->outputHtml($outputHead);
					$this->outputHtml("<ol>\n");
				}
				
				$link = get_permalink($entry);
				
				$this->outputHtml(
					"<li><a href=\"$link\">$entry->post_title</a></li>\n");
				
			}
			$this->outputHtml("</ol>\n");
		}
		
	}
	
	/**
	 * make from/to SQL statement
	 * 
	 * @param $from
	 * @param $to
	 * @return $sql
	 */
	function makeFromToSQL($from, $to) {
		
		if($from != '') {
			$fsql =  "post_date >= '$from 00:00:00'";
		}
		if($to == '') {
			$tsql =  "post_date <= NOW()";
		} else {
			$to = date('Y-m-d', strtotime("$to +1 day"));
			$tsql =  "post_date < '$to 00:00:00'";
		}
		
		if($fsql != '' && $tsql != '') {
			$sql = $fsql . ' AND ' . $tsql . ' ';
		} else {
			$sql = $fsql . $tsql . ' ';
		}
		
		return $sql;
		
	}
	
	/**
	 * output screen and cache file
	 * 
	 * @param $content
	 * @return none
	 */
	function outputHtml($content) {
		
		if($this->cache_enable) {
			fputs($this->file_pointer, $content);
		}
		echo $content;
		
	}
	
}

/******************************************************************************
 * WpMosquito - WordPress Interface Define
 *****************************************************************************/

$wpMosquito = & new WpMosquito();

add_action('publish_post', array(&$wpMosquito, 'deleteCache'));
add_action('edit_post', array(&$wpMosquito, 'deleteCache'));
add_action('delete_post', array(&$wpMosquito, 'deleteCache'));

if(!function_exists('mosquito_archive')) {
	function mosquito_archive(
		$header = '<h3>',
		$from = '',
		$to = '',
		$format = '%B %Y') {
		
		global $wpMosquito;
		$wpMosquito->mosquito_archive($header, $from, $to, $format);
		
	}
}

?>