<?php
/*
Plugin Name: wp-kumonosu
Plugin URI: http://wppluginsj.sourceforge.jp/wp-kumonosu/
Description: make kumonosu from comment and trackback
Author: hiromasa
Version: 0.4
Author URI: http://hiromasa.zone.ne.jp/blog/
*/

/*  Copyright 2006 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WpKumonosu
 * 
 * @author		hiromasa
 * @version		0.4
 * 
 *****************************************************************************/
class WpKumonosu {
	
	var $view;
	var $model;
	var $request;
	
	var $plugin_name;
	var $plugin_uri;
	
	/**
	 * the constructor
	 * 
	 * @param none
	 * @return none
	 */
	function WpKumonosu() {
		
		$this->plugin_name = 'wp-kumonosu';
		
		$this->plugin_uri  = get_settings('home');
		$this->plugin_uri .= '/wp-content/plugins/wp-kumonosu/';
		
		$this->request = new WpKumonosuHTTPRequestVO();
		
		$this->model = $this->getModelObject();
		$this->view  = new WpKumonosuView();
		
	}
	
	/**
	 * getModelObject
	 * 
	 * @param none
	 * @return $model
	 */
	function getModelObject() {
		
		$option = $this->getWpOption();
		
		$model = null;
		//PHP 4.0 Bug?
		if(strtolower(get_class($option)) == strtolower('WpKumonosuModel_V10')) {
			$model = $option;
		} else {
			$model = new WpKumonosuModel_V10();
			$this->writeWpOption($model);
		}
		
		return $model;
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function addAdminMenu() {
		
		add_options_page(
			'Kumonosu',
			'Kumonosu',
			8,
			'wp-kumonosu.php',
			array(&$this, 'executeAdmin')
		);
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function addAdminHead() {
		
		$this->view->echoAdminHead($this->plugin_uri);
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function executeAdmin() {
		
		$action = $this->request->getParam('action');
		
		if($action == 'navigate' || $action == '') {
			
			$scr = $this->request->getParam('scr');
			
			if($scr == '' || $scr == '0') {
				$links = $this->model->getSelectedLink();
				$this->view->echoSelectedSite($links, false);
			}
			if($scr == '1') {
				$links = $this->model->getLink();
				$date = $this->model->getMakeDate();
				$this->view->echoAllSite($links, $date, false);
			}
			
		}
		
		if($action == 'analyze') {
			$this->model->makeLinks();
			$value = $this->model->getLink();
			$date = $this->model->getMakeDate();
			$this->updateWpOption($this->model);
			$this->view->echoAllSite($value, $date, true);
		}
		
		if($action == 'select') {
			$this->model->markLinks($this->request);
			$this->updateWpOption($this->model);
			$links = $this->model->getSelectedLink();
			$this->view->echoSelectedSite($links, true);
		}
		
	}
	
	/**
	 * getWpOption
	 * 
	 * @param none
	 * @return $OptionValue
	 */
	function getWpOption() {
		
		$option = get_option($this->plugin_name);
		
		if(!$option == false) {
			$OptionValue = $option;
		} else {
			$OptionValue = false;
		}
		
		return $OptionValue;
		
	}
	
	/**
	 * setWpOption
	 * 
	 * @param none
	 * @return none
	 */
	function writeWpOption($OptionValue) {
		
		$option_description = $this->plugin_name . " Options";
		$OptionValue = $OptionValue;
		
		add_option(
			$this->plugin_name,
			$OptionValue,
			$option_description);
		
	}
	
	/**
	 * updateWpOption
	 * 
	 * @param none
	 * @return none
	 */
	function updateWpOption($OptionValue) {
		
		$option_description = $this->plugin_name . " Options";
		$OptionValue = $OptionValue;
		
		update_option(
			$this->plugin_name,
			$OptionValue,
			$option_description);
		
	}
	
}

/******************************************************************************
 * WpKumonosuModel_V10
 * 
 * @author		hiromasa
 * @version		0.4
 * 
 *****************************************************************************/
class WpKumonosuModel_V10 {
	
	var $links = array();
	var $version;
	var $makedata;
	
	/**
	 * the constructor
	 * 
	 * @param none
	 * @return none
	 */
	function WpKumonosuModel_V10() {
		
		$this->version = 'Kumonosu/1.0';
		
	}
	
	/**
	 * make link
	 * 
	 * @param none
	 * @return none
	 */
	function makeLinks() {
		
		global $wpdb;
		
		$oldLinks = $this->links;
		$this->links = array();
		
		$sql =
			  '(SELECT'
			. '     comment.comment_author as author,'
			. '     comment.comment_author_url as author_url,'
			. '     count(comment.comment_author) as comment_count,'
			        /* MySQL 4.0 Hack */
			. '     \'00000\' as trackback_count,'
			. '     SUBSTRING_INDEX(REPLACE(comment.comment_author_url, \'http://\', \'\'), \'/\', 1) as hostname'
			. ' FROM'
			. "     $wpdb->comments as comment"
			. ' WHERE'
			. '     comment_approved = \'1\' AND'
			. '     comment_author_url <> \'\' AND'
			. '     comment_type = \'\''
			. ' GROUP BY'
			. '     hostname'
			. ' ORDER BY'
			. '     comment_date DESC'
			. ')'
			. ' UNION'
			. '(SELECT'
			. '     trackback.comment_author as author,'
			. '     trackback.comment_author_url as author_url,'
			. '     \'\' as comment_count,'
			. '     count(trackback.comment_author) as trackback_count,'
			. '     SUBSTRING_INDEX(REPLACE(trackback.comment_author_url, \'http://\', \'\'), \'/\', 1) as hostname'
			. ' FROM'
			. "     $wpdb->comments as trackback"
			. ' WHERE'
			. '     trackback.comment_approved = \'1\' AND'
			. '     trackback.comment_author_url <> \'\' AND'
			. '     trackback.comment_type = \'trackback\''
			. ' GROUP BY'
			. '     hostname'
			. ' ORDER BY'
			. '     comment_date DESC'
			. ')';
		
		$hosts = $wpdb->get_results($sql);
		
		if($hosts == '') return;
		
		// TODO:
		foreach($hosts as $host) {
			
			if($host->hostname != '' && $this->links[$host->hostname]['hostname'] == '')
				$this->links[$host->hostname]['hostname'] = $host->hostname;
			
			if($host->author != '' && $this->links[$host->hostname]['author'] == '') {
				/* Mie chan Special :-) */
				if(preg_match('/^M\'s/', $host->author)) {
					$this->links[$host->hostname]['author'] = 'Mie';
				} else {
					$this->links[$host->hostname]['author'] = $host->author;
				}
			}
			
			if($host->author_url != '' && $this->links[$host->hostname]['author_url'] == '')
				$this->links[$host->hostname]['author_url'] = $host->author_url;
			
			if($host->comment_count != '' && $this->links[$host->hostname]['comment_count'] == '') {
				$this->links[$host->hostname]['comment_count'] = $host->comment_count;
				$this->links[$host->hostname]['all_count'] += $host->comment_count;
			}
			
			if($host->trackback_count != '00000') {
				$this->links[$host->hostname]['trackback_count'] = $host->trackback_count;
				$this->links[$host->hostname]['all_count'] += $host->trackback_count;
			}
			
			foreach($oldLinks as $oldHost) {
				if($oldHost['hostname'] == $this->links[$host->hostname]['hostname']) {
					$this->links[$host->hostname]['checked'] = $oldHost['checked'];
					break;
				}
			}
			
		}
		
		usort($this->links, array($this, 'usort_compare'));
		
		$this->makedata = mktime();
		
	}
	
	/**
	 * usort callback function
	 * 
	 * @param $arg1
	 * @param $arg2
	 * @return bool
	 */
	function usort_compare($arg1, $arg2) {
		
		if ($arg1['all_count'] == $arg2['all_count']) {
		    return 0;
		}
		return ($arg1['all_count'] < $arg2['all_count']) ? +1 : -1;
		
	}
	
	/**
	 * mark links
	 * 
	 * @param $requset
	 * @return none
	 */
	function markLinks($request) {
		
		$hosts = $request->getParam('chk_host');
		
		// TODO:
		for($i=0 ; $i<count($this->links); $i++) {
			$this->links[$i]['checked'] = false;
			if(count($hosts) == 0) continue;
			foreach($hosts as $host) {
				if($this->links[$i]['hostname'] == $host) {
					$this->links[$i]['checked'] = true;
					$find = true;
					break;
				}
			}
		}
		
	}
	
	/**
	 * getSelectedLink
	 * 
	 * @param none
	 * @return $links
	 */
	function getSelectedLink() {
		
		$links = array();
		
		for($i=0 ; $i<count($this->links); $i++) {
			if($this->links[$i]['checked']) {
				$links[] = $this->links[$i];
			}
		}
		
		return $links;
		
	}
	
	/**
	 * value getter
	 * 
	 * @param $hostname
	 * @param $key
	 * @return $value
	 */
	function getLink($hostname = '', $key = '') {
		
		if($hostname == '') return $this->links;
		
		$value = $this->links[$hostname][$key];
		if($value = '') $value = false;
		
		return $value;
		
	}
	
	/**
	 * value getter
	 * 
	 * @param none
	 * @return $date
	 */
	function getMakeDate() {
		
		$date = '';
		if($this->makedata != '') {
			$date = date('y/m/d H:i:s', $this->makedata);
		}
		
		return $date;
		
	}
	
}

/******************************************************************************
 * WpKumonosuView
 * 
 * @author		hiromasa
 * @version		0.4
 * 
 *****************************************************************************/
class WpKumonosuView {
	
	/**
	 * Output Admin Header
	 * 
	 * @param $url
	 * @return none
	 */
	function echoAdminHead($url) {
		
		echo '<link type="text/css" rel="stylesheet" href="';
		echo $url . 'wp-kumonosu.css" />' . "\n";;
		
		echo '<script type="text/javascript" src="';
		echo $url . 'wp-kumonosu.js">';
		echo '</script>'  . "\n";
		
	}
	
	/**
	 * Output Admin HTML
	 * 
	 * @param $vo
	 * @return none
	 */
	function echoAllSite($value, $date, $make_flag = false) {
		
		if($make_flag) {
			$this->echoMessage('ブログからリンクの解析を行い「サイトの選択」に最新情報を表示しました。');
		}
		
		$this->echoAdminHeader(1);
		
		echo '<h3 id="header3">リンクの解析</h3>';
		
		echo '<form name="analyze" method="post">' . "\n";
		
		if(count($value) == 0) {
			echo '<p>これよりこのブログからリンクの解析を行います。';
			echo 'Analyze ボタンを押下してください。</p>' . "\n";
		} else {
			echo "<p>以下のリンク解析は $date に行われました。";
			echo 'ブログから最新の情報を取得する場合は Analyze ボタンを押下してください。</p>' . "\n";
		}
		
		echo '<p class="submit">' . "\n";
		echo '<input type="submit" name="analyze" value="Analyze &raquo;" />' . "\n";
		echo '</p>' . "\n";
		
		echo '<input type="hidden" id="action" name="action" value="analyze" />' . "\n";
		echo '</form>' . "\n";
		
		if(count($value) == 0) {
			$this->echoAdminFooter();
			return;
		}
		
		echo '<h3 id="header3">サイトの選択</h3>' . "\n";
		
		echo '<form name="select" method="post">' . "\n";
		
		echo '<p><a href="#" onclick="kumo_change_scr(0);">Selected Sites</a> に表示するサイトを選択して';
		echo ' Select Site ボタンを押下してください。</p>';
		
		echo '<p class="submit">' . "\n";
		echo '<input type="submit" value="Select Site &raquo;" />' . "\n";
		echo '</p>' . "\n";
		
		$this->echoLinks($value);
		
		echo '<p class="submit">' . "\n";
		echo '<input type="submit" value="Select Site &raquo;" />' . "\n";
		echo '</p>' . "\n";
		
		echo '<input type="hidden" id="action" name="action" value="select" />' . "\n";
		echo '</form>' . "\n";
		
		$this->echoAdminFooter();
		
	}
	
	function echoSelectedSite($links, $select_flag) {
		
		if($select_flag) {
			$this->echoMessage('選択したサイトを反映しました。');
		}
		
		$this->echoAdminHeader(0);
		
		if(count($links) == 0) {
			echo '<p>選択されたサイトはありません。 ';
			echo '<a href="#" onclick="kumo_change_scr(1);">All Sites</a> からサイトを選択してください。</p>';
		} else {
			$this->echoSelectedSiteTable($links);
		}
		
		$this->echoAdminFooter();
		
	}
	
	function echoSelectedSiteTable($links) {
		
		$ret_max = 5;
		
		echo '<div id="kumonosuclip">';
		echo "(C)lip : ";
		echo '<input type="text" id="clip" size="60" value="" />' . "\n";
		echo '</div>';
		
		echo "<table cellspacing=\"0\" style=\"width: 100%;\">\n";
		echo '<tr>' . "\n";
		
		$ret_count = 0;
		for($i=0; $i<count($links); $i++) {
			
			$author_url = $links[$i]['author_url'];
			$author = $links[$i]['author'];
			
			echo "<td>\n";
			echo "<table cellspacing=\"0\" style=\"width: 100%;text-align: center;padding-bottom: 1em\">\n";
			echo "<tr><td>";
			echo "<a href=\"$author_url\" style=\"border: 0;\">";
			echo "<img src=\"http://img.simpleapi.net/small/$author_url\" />";
			echo "</a>";
			echo "</td></tr>\n";
			echo "<tr>";
			echo "<td><span id=\"author_$i\"><a href=\"$author_url\">$author さん</a></span> (<a href=\"#\" onclick=\"kumo_linkcopy($i);\">C</a>)</td>";
			echo "</tr>\n";
			echo "</table>\n";
			echo '</td>' . "\n";
			
			if($ret_count < $ret_max - 1) {
				$ret_count++;
			} else {
				echo '</tr>' . "\n";
				echo '<tr>' . "\n";
				$ret_count = 0;
			}
			
		}
		
		echo '</tr>' . "\n";
		echo '</table>' . "\n";
	}
	
	function echoAdminHeader($scr) {
		
		echo '<div class="wrap">' . "\n";
		echo '<h2>kumonosu</h2>' . "\n";
		
		echo '<form name="navigate" method="post">' . "\n";
		
		echo '<ul id="kumonosumenu">' . "\n";
		if($scr == 1) {
			echo '<li><a href="#" onclick="kumo_change_scr(0);">Selected Sites</a></li>';
			echo '<li><a href="#" onclick="kumo_change_scr(1);" class="current">All Sites</a></li>';
		} else {
			echo '<li><a href="#" onclick="kumo_change_scr(0);" class="current">Selected Sites</a></li>';
			echo '<li><a href="#" onclick="kumo_change_scr(1);">All Sites</a></li>';
		}
		echo '</ul>' . "\n";
		
		echo '<input type="hidden" id="scr" name="scr" value="" />' . "\n";
		echo '<input type="hidden" id="action" name="action" value="navigate" />' . "\n";
		
		echo '</form>' . "\n";
	}
	
	function echoAdminFooter() {
		
		echo '</div>' . "\n";
		
	}
	
	function echoMessage($message) {
		
		echo '<div id="message" class="updated fade">' . "\n";
		echo "<p><strong>$message</strong></p>" . "\n";
		echo '</div>' . "\n";
		
	}
	
	/**
	 * Output Link HTML
	 * 
	 * @param $links
	 * @return none
	 */
	function echoLinks($links) {
		
		echo "<table cellspacing=\"0\" style=\"width: 100%;\">\n";
		echo "<tr>\n";
		echo "\t<th style=\"width: 4em;\">check</th>\n";
		echo "\t<th>author</th>\n";
		echo "\t<th style=\"width: 10em;\">hostname</th>\n";
		echo "\t<th style=\"width: 3em;\">all</th>\n";
		echo "\t<th style=\"width: 3em;\">com</th>\n";
		echo "\t<th style=\"width: 3em;\">tra</th>\n";
		echo "</tr>\n";
		
		$line_color = false;
		foreach($links as $link) {
			
			if($link['hostname'] == '') continue;
			
			if($line_color) {
				echo "<tr>\n";
				$line_color = false;
			} else {
				echo "<tr style=\"background-color: #f9f9f9;\">\n";
				$line_color = true;
			}
			
			$chk = '';
			if($link['checked']) $chk = 'checked';
			
			echo "\t<td style=\"text-align: center;\">";
			echo "<input type=\"checkbox\" name=\"chk_host[]\" value=\"${link['hostname']}\" $chk />";
			echo "</td>\n";
			echo "\t<td><a href=\"${link['author_url']}\">${link['author']}</a></td>\n";
			echo "\t<td>${link['hostname']}</td>\n";
			echo "\t<td>${link['all_count']}</td>\n";
			echo "\t<td>${link['comment_count']}</td>\n";
			echo "\t<td>${link['trackback_count']}</td>\n";
			echo "</tr>\n";
			
		}
		echo "</table>\n";
		
	}
	
}

/******************************************************************************
 * ValueObject Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WpKumonosuValueObject {
	
	var $paramsMap = Array();
	
	/**
	 * setParam
	 * 
	 * @param $name
	 * @return none
	 */
	function setParam($name, $value) {
		
		$this->paramsMap[$name] = $value;
		
	}
	
	/**
	 * getParam
	 * 
	 * @param $name
	 * @return none
	 */
	function getParam($name) {
		
		return $this->paramsMap[$name];
		
	}
	
}

/******************************************************************************
 * HTTPRequestVO Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WpKumonosuHTTPRequestVO extends WpKumonosuValueObject {
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */
	function WpKumonosuHTTPRequestVO() {
		
		if(is_array($_REQUEST)) {
			foreach($_REQUEST as $name => $value) {
				$this->setParam($name, $value);
			}
		}
		
	}
	
}

/******************************************************************************
 * WpKumonosu - WordPress Interface Define
 *****************************************************************************/

if(is_admin()) {
	$wpKumonosu = & new WpKumonosu();
	add_action('admin_head', array(&$wpKumonosu, 'addAdminHead'));
	add_action('admin_menu', array(&$wpKumonosu, 'addAdminMenu'));
}

?>