<?php
/**
 * updateCategoryList.php:
 * wp-AT user interface for update goods categories.
 * 
 * @author Sa.Ga
 * @version 1.0 Beta 2
 */

/*  Copyright 2006 Sa.Ga

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

require_once('../../../wp-config.php');
include_once(ABSPATH . '/wp-includes/version.php');
require_once (ABSPATH . '/wp-includes/wp-l10n.php');
require_once (ABSPATH . '/wp-admin/admin-functions.php');

require_once('class/wp-AT-function.php');

$wsVer = get_option('wpat_ws_ver');
$wsType = 'geteccategory';
$wsID = get_option('wpat_ws_id');

define('ATWS_URL', 'http://xml.accesstrade.net/at/ws.html');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>WordPress &rsaquo;&rsaquo; <?php _e('wp-AT', 'wp_AT'); ?></title>
<link rel="stylesheet" href="../../../wp-admin/wp-admin.css" type="text/css" />
<link rel="shortcut icon" href="../../../wp-images/wp-favicon.png" />
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo get_settings('blog_charset');?>" />
<script type="text/javascript">
<!--
window.focus();
// -->
</script>
<script type="text/javascript" src="../wp-includes/js/fat.js"></script>
</head>
<body>
<div id="wphead">
<h1><?php _e('wp-AT', 'wp_AT'); ?> <span>(<a href="javascript:window.close()"><?php _e('閉じる', 'wp_AT'); ?> &raquo;</a>)</span></h1>
</div>
<?php
if (isset($_POST['reload'])) {
//    require_once 'class/ATWS_Parser.php';
	require_once 'class/wp-AT-parser.php';
    $resource = ATWS_URL
    	. '?ws_ver='. $wsVer. '&ws_id='. $wsID. '&ws_type='. $wsType;
//    $atws = new ATWS_Parser($resource);
//    $atws->parse();
//    $result = $atws->getResult();
	$result = readXML($resource);
	$categoryList = __(',全て', 'wp_AT');
    for ($i = 0; $i < count($result['categorydata']); $i++) {
        $data = $result['categorydata'][$i];
        $categoryList .= convToBlogCharset(
			"\n". $data['categorycode']. ','. $data['categoryname']);
    }
	update_option('wpat_category_list', $categoryList);
	echo '<div class="updated"><p><strong>' . __('カテゴリリストを更新しました。', 'wp_AT') . '</strong></p></div>';
}
?>
<div class="wrap">
<form name="wpAT_updateCategory" method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
<input type="hidden" name="reload" value="1" />
	<fieldset class="options">
		<legend>
			<label><?php _e('カテゴリリストの更新', 'wp_AT'); ?></label>
		</legend>
		<p><?php _e('ご登録されている情報で、カテゴリリストの更新をおこないます。', 'wp_AT'); ?></p>
		<p><?php _e('プラグイン導入時や、新しいカテゴリの提携先が増えた際にボタンを押してください。', 'wp_AT'); ?></p>
		<input type="submit" value="<?php _e('更新', 'wp_AT'); ?> &raquo;" />
	</fieldset>
</form>
</div>
</body>
</html>
<?
/**
 * convert character encoding to your blog-charset.
 * @param variable $str
 */
function convToBlogCharset($str) {
	$charset = get_settings('blog_charset');
	if (!strpos($charset, 'UTF-8')) {
		if (function_exists('mb_convert_encoding')) {
			$str = mb_convert_encoding($str, $charset, 'UTF-8');
		}
	}
	return $str;
}
?>
