<?php
/**
 * wp-AT-parser.php:
 * XML Parser for AccessTrade Web Service
 * 
 * @author Sa.Ga
 * @version 1.0 Beta 2
 */

/*  Copyright 2006 Sa.Ga

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
 * This file is called only.
 */
if(basename($_SERVER['SCRIPT_FILENAME']) == 'wp-AT-parser.php') {
	die();
}

/** Buffer */
$buffer = array();

/** Buffer Position */
$nodeIDs = array();

/** Current Element on these functions */
$currentElement = '';

/** Active second level node */
$activeNode = '';

/** Top Level Node */
$topLevelNode = 'AllResult';

/**
 * Read XML file from AccessTrade Web Service.
 * @param string $url
 */
function readXML($url) {

	global $buffer;

	$bufferSize = 4096;

	$parser = xml_parser_create();
	if (!$parser) {
		// Error Report
		$errMsg = "XML Parser Error!";
//		updateReport($postID, $errMsg);
		return false;
	}

	// Read from XML
	xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, false);
	xml_set_element_handler($parser,
		'start_element_handler', 'end_element_handler');
	xml_set_character_data_handler($parser, 'character_data_handler');
	xml_set_default_handler($parser, 'default_handler');

	// Open XML Document
	$fp = fopen($url, 'r');
	if ($fp) {
		while ($fin = fread($fp, $bufferSize)) {
			if (!xml_parse($parser, $fin, feof($fp))) {
				// Error Report
				$errMsg = "XML Parser Error!";
//				updateReport($postID, $errMsg);
				return false;
			}
		}
	} else {
		// Error Report
		$errMsg = "Failure to open XML file! : " . $url;
//		updateReport($postID, $errMsg);
		return false;
	}
	// Release XML Parser
	xml_parser_free($parser);
	return $buffer;
}

/**
 * Start element handler (used by XML Parser)
 * @param $parser XML Parser
 * @param $name Element name
 * @param $attrs Arrays of attributes
 */
function start_element_handler($parser, $name, $attrs) {

	global $nodeIDs, $topLevelNode, $currentElement, $activeNode;

	$secondLevelNodes = array('Request', 'Goods', 'CategoryData');

	if ($name == $topLevelNode) {
		$currentElement = "";
	} else {
		foreach ($secondLevelNodes as $node) {
			if ($name == $node) {
				$activeNode = $node;
				if (!$nodeIDs["$activeNode"]) {
					$nodeIDs["$activeNode"] = 0;
				}
				break;
			}
		}
		$currentElement = $name;
	}
}

/**
 * End element handler (used by XML Parser)
 * @param $parser XML Parser
 * @param $name Element name
 */
function end_element_handler($parser, $name) {

	global $nodeIDs, $currentElement, $activeNode;

	if ($name == $activeNode) {
		$nodeIDs["$activeNode"]++;
		$activeNode = '';
	}
	$currentElement = '';
}

/**
 * Character data handler (used by XML Parser)
 * @param $parser XML Parser
 * @param $chrdata Body String read by XML Parser
 */
function character_data_handler($parser, $chrdata) {

	global $nodeIDs, $buffer, $currentElement, $activeNode;

	$tag = null;

	if ($activeNode) {
		if ($activeNode == 'Request') {
			$tag = & $buffer[strtolower($activeNode)][strtolower($currentElement)];
		} else {
			$tag = & $buffer[strtolower($activeNode)][$nodeIDs["$activeNode"]][strtolower($currentElement)];
		}
	} elseif ($currentElement)  {
		$tag = & $buffer[strtolower($currentElement)];
	}
	if ($tag) {
		$tag .= htmlspecialchars(
			mb_convert_encoding($chrdata, get_settings('blog_charset'), 'auto'));
	} else {
		$tag = htmlspecialchars(
			mb_convert_encoding($chrdata, get_settings('blog_charset'), 'auto'));
	}
}

/**
 * Default handler (used by XML Parser)
 * @param $parser XML Parser
 * @param $nodedata Node data
 */
function default_handler($parser, $nodedata) {
}

?>
