<?php
/* 
Plugin Name: wp-koyomi
Plugin URI: http://wppluginsj.sourceforge.jp/wp-koyomi/
Description: This plug-in converts post-date (Gregorian date) into old calendar of Japan and the six‐day Buddhist cycle. 
Author: Sa.Ga
Version: 1.0
Author URI:  http://blog2.atsj.net/
Special Thanks:
	- H.Takano: the author of "QREKI.AWK" AWK Script
		[http://www.vector.co.jp/soft/dos/personal/se016093.html].
	- N.Ueno: the creqator of "qreki.pl" Perl Script
		[http://www3.biwako.ne.jp/~nobuaki/qreki/].
*/

/*  Copyright 2006 Sa.Ga

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * *** How to use of this plug-in ***
 * 
 * 1. Upload the **whole "wp-koyomi" folder** to your plugins directory
 *    and activate it from your WordPress control panel.
 * 
 * 2. Edit one or some theme files [e.g. "index.php"].
 *    If you want to use the WordPress theme editor,
 *    please go to **Presentation > Theme Editor** in your Wordpress menu.
 * 
 * 3. Please insert the following code in the template
 *    according to information that you want to have it display. 
 * 
 *    If you want to display the day of old calendar of Japan:
 *    <?php if(isset($WpKoyomi)) $WpKoyomi->kyureki(); ?> 
 * 
 *    If you want to display the six‐day Buddhist cycle of the day:
 *    <?php if(isset($WpKoyomi)) $WpKoyomi->rokuyo(); ?>
 * 
 *    If you want to display the "24sekki" of the day:
 *    <?php if(isset($WpKoyomi)) $WpKoyomi->_24sekki(); ?> 
 */

/*
 *        *** WANTED!! ***
 * - one Japanese-English translator
 */

require_once('qreki.php');

/**
 * WpKoyomi function define...
 */
if (class_exists('WpKoyomi') && class_exists('Qreki')) {
	$WpKoyomi = & new WpKoyomi();
	$Qreki = & new Qreki();
}

/**
 * hte Main Class of "wp-koyomi".
 * @author Sa.Ga
 * @version 0.9.0
 */
class WpKoyomi {

	var $charset;

	/**
	 * the constructor
	 */
	function WpKoyomi() {
		$this->charset = get_settings('blog_charset');
	}

	/**
	 * echo the result of $this->getKyureki().
	 * @param string $prefix [optional]
	 * @param string $suffix [optional]
	 */
	function kyureki($prefix = '', $suffix = '') {
		$str = $this->getKyureki();
		if ($str != '') {
			echo $prefix. $str. $suffix;
		}
	}

	/**
	 * echo the result of $this->getRokuyo().
	 * @param string $prefix [optional]
	 * @param string $suffix [optional]
	 */
	function rokuyo($prefix = '', $suffix = '') {
		$str = $this->getRokuyo();
		if ($str != '') {
			echo $prefix. $str. $suffix;
		}
	}

	/**
	 * echo the result of $this->get24sekki().
	 * @param string $prefix [optional]
	 * @param string $suffix [optional]
	 */
	function _24sekki($prefix = '', $suffix = '') {
		$str = $this->get24sekki();
		if ($str != '') {
			echo $prefix. $str. $suffix;
		}
	}

	/**
	 * convert post-date (Gregorian date) into old calendar of Japan.
	 */
	function getKyureki() {
		global $post, $Qreki;
		$gyear = mysql2date('Y', $post->post_date);
		$gmonth = mysql2date('m', $post->post_date);
		$gday = mysql2date('d', $post->post_date);

		$kyureki = $Qreki->calcKyureki($gyear, $gmonth, $gday);
		$qYear = $kyureki[0];
		$uruu = $kyureki[1];
		$qMonth = $kyureki[2];
		$qDay = $kyureki[3];
		$sUruu = ($uruu == 1 ? '閏' : '');
		$sqMonth = ($qMonth < 10 ? '0'. $qMonth : $qMonth);
		$sqDay = ($qDay < 10 ? '0'. $qDay : $qDay);
		$qStr = $qYear. '年'. $sUruu. $sqMonth. '月'. $sqDay. '日';

		return $this->convToBlogCharset($qStr);
	}

	/**
	 * convert post-date (Gregorian date) into the six‐day Buddhist cycle.
	 */
	function getRokuyo() {
		global $post, $Qreki;
		$gyear = mysql2date('Y', $post->post_date);
		$gmonth = mysql2date('m', $post->post_date);
		$gday = mysql2date('d', $post->post_date);

		$kyureki = $Qreki->calcKyureki($gyear, $gmonth, $gday);
		$qYear = $kyureki[0];
		$uruu = $kyureki[1];
		$qMonth = $kyureki[2];
		$qDay = $kyureki[3];
		$rokuyoArray = array('大安', '赤口', '先勝', '友引', '先負', '仏滅');
		
		return $this->convToBlogCharset($rokuyoArray[$Qreki->rokuyou($qMonth, $qDay)]);
	}

	/**
	 * if the post-date (Gregorian date) is one of the "24sekki" day,
	 * get "24sekki" word of this day.
	 */
	function get24sekki() {
		global $post, $Qreki;

		$wordOf24sekki = null;

		$gyear = mysql2date('Y', $post->post_date);
		$gmonth = mysql2date('m', $post->post_date);
		$gday = mysql2date('d', $post->post_date);

		$wordOf24sekki = $Qreki->check_24sekki($gyear, $gmonth, $gday);
		if ($wordOf24sekki != null) {
			$wordOf24sekki = $this->convToBlogCharset($wordOf24sekki);
		}
		return $wordOf24sekki;
	}

	/**
	 * convert character encoding to your blog-charset.
	 * @param variable $str
	 */
	function convToBlogCharset($str) {
		if (!strpos($this->charset, 'UTF-8')) {
			if (function_exists('mb_convert_encoding')) {
				$str = mb_convert_encoding($str, $this->charset, 'UTF-8');
			}
		}
		return $str;
	}
}
?>
