<?php
/*
Plugin Name: wp-otenki
Plugin URI: http://wppluginsj.sourceforge.jp/wp-otenki/
Description: Add weather meta information by <a href="http://weather.livedoor.com/weather_hacks/webservice.html">LWWS</a>
Author: hiromasa
Version: 1.12
Author URI: http://hiromasa.zone.ne.jp/blog/
*/

/*  Copyright 2006 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * 設定
 *****************************************************************************/

/*
 * ここで取得するお天気の場所を設定してください(下のURLから調べられます)
 * 
 *  http://weather.livedoor.com/forecast/rss/forecastmap.xml
 *  例) 4: Sapporo
 */
define('WPOTENKI_LOCATION', '4');

/*
 * メタ名称（通常はこのままで問題ありません）
 */
define('WPOTENKI_METANAME', 'wpotenki');
define('WPOTENKI_EX_METANAME', 'wpotenki_area');

/******************************************************************************
 * THIS FILE IS CALLED ONLY.
 *****************************************************************************/

if(basename($_SERVER['SCRIPT_FILENAME']) == 'wp-otenki.php') {
	die();
}

/******************************************************************************
 * WpOtenki Class
 * 
 * @author     hiromasa
 * @version    1.12
 * 
 *****************************************************************************/
class WpOtenki {
	
	/**
	 * WordPress の add_action 登録メソッド関数（投稿時用）
	 * 
	 * @param $postID
	 * @return $postID
	 */
	function actionOtenki($postID) {
		
		/* メタ情報変更の時は追加しない */
		if(isset($_POST['updatemeta'])) return;
		if(isset($_POST['deletemeta'])) return;
		
		/* "今日"のポストの時だけ天気を取得 */
		$post = get_post($postID);
		$post_date = date("Y/m/d", strtotime($post->post_date));
		$now_date = date("Y/m/d");
		if($post_date != $now_date) return;
		
		/* とりあえずメタをダミー登録する */
		$meta['otenki'] = 'loading';
		add_post_meta($postID, WPOTENKI_METANAME, $meta, true);
		
		/* 非同期でもうひとつ WordPress を起動してお天気メタ追加 */
		$this->executeOtenki($postID);
		
		return $postID;
		
	}
	
	/**
	 * 非同期でもうひとつ WordPress を起動するメソッド
	 * 
	 * @param $postID
	 * @return none
	 */
	function executeOtenki($postID) {
		
		$errno = '';
		$errstr = '';
		
		$ping_url
			= get_settings('siteurl') .
				'/wp-content/plugins/wp-otenki/wp-otenki-execute.php';
		$parts = parse_url($ping_url);
		$argyle = @ fsockopen(
				$parts['host'],
				$_SERVER['SERVER_PORT'],
				$errno,
				$errstr,
				0.01);
		
		if ($argyle) {
			fputs($argyle, "GET {$parts['path']}?" .
				"otenki_id=" . $postID . '&' .
				"time=" . time() .
				" HTTP/1.0\r\nHost: {$_SERVER['HTTP_HOST']}\r\n\r\n");
		}
		
	}
	
	/**
	 * WordPress の add_action 登録メソッド関数（画面出力用）
	 * 
	 * @param none
	 * @return none
	 */
	function echoOtenki() {
		
		$otenki = get_post_custom_values(WPOTENKI_METANAME);
		$otenki = unserialize($otenki[0]);
		
		if($otenki['otenki'] == '') return;
		if($otenki['otenki'] == 'loading') return;
		
		echo
			'<img src="' . $otenki['mark'] . '"' .
			' style="border: 0; margin:0; padding:0; vertical-align: baseline;"' . 
			' alt="' .$otenki['otenki']  . '" height="20px" />';
		
		if($otenki['max'] != '' && $otenki['min'] != '') {
			echo '(' . $otenki['max'] . '/' . $otenki['min'] . ')';
		}
		
	}
	
}

/******************************************************************************
 * WpOtenki - WordPress Interface Define
 *****************************************************************************/

$wpotenki = & new WpOtenki();

add_action('publish_post', array(&$wpotenki, 'actionOtenki'), 99);
add_action('wp-otenki', array(&$wpotenki, 'echoOtenki'));

?>
