<?php
/*  Copyright 2006 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WordPress Interface Inclide
 *****************************************************************************/

require_once('../../../wp-config.php');

/******************************************************************************
 * miniXML Parser Define
 *****************************************************************************/

if(!defined(MINIXML_VERSION)) {
	require_once('minixml.inc.php');
}

/******************************************************************************
 * WpOtenki Execute Class
 * 
 * @author     hiromasa
 * @version    1.12
 * 
 *****************************************************************************/
class WpOtenkiEx {
	
	var $location;
	var $request_uri;
	
	/**
	 * コンストラクタ（初期化・呼び出しチェック）
	 * 
	 * @param none
	 * @return none
	 */
	function WpOtenkiEx() {
		
		$postid = addslashes($_GET['otenki_id']);
		if(!is_numeric($postid)) return;
		if(!($post = &get_post($postid))) return;
		
		$this->location = $this->getLWWSarea($postid);
		$this->request_uri
			= "http://weather.livedoor.com/forecast/webservice/rest/v1?";
		$this->request_uri
			.="city=". $this->location . "&day=today";
		
		$post_date = date("Y/m/d", strtotime($post->post_date));
		$now_date = date("Y/m/d");
		if($post_date != $now_date) return;
		
		$otenki = get_post_meta($postid, WPOTENKI_METANAME, true);
		if($otenki['otenki'] == '') return;
		
		$this->addOtenki($postid);
		
	}
	
	/**
	 * LWWS から"今日"のお天気を取得するメソッド
	 * 
	 * @param $postid
	 * @return none
	 */
	function addOtenki($postid) {
		
		$xmlDoc = new MiniXMLDoc();
		
		$buffer = file_get_contents($this->request_uri);
		$xmlDoc->fromString($buffer);
		$buffer = $xmlDoc->toArray();
		
		// miniXML パーサのバグ(?)のため取得ツリーが少し違います
		$tenki = $buffer['lwws']['location'][0]['telop'];
		$max = $buffer['lwws']['location'][0]['temperature']['max']['celsius'];
		$min = $buffer['lwws']['location'][0]['temperature']['min']['celsius'];
		$mark = $buffer['lwws']['location'][0]['image']['url'];
		$title = $buffer['lwws']['location'][0]['title'][0];
		
		$tenki
			= mb_convert_encoding($tenki ,get_settings('blog_charset'), 'UTF-8');
		$title
			= mb_convert_encoding($title ,get_settings('blog_charset'), 'UTF-8');
		
		$meta['otenki'] = $tenki;
		$meta['max'] = $max;
		$meta['min'] = $min;
		$meta['mark'] = $mark;
		$meta['title'] = $title;
		
		update_post_meta($postid, WPOTENKI_METANAME, $meta);
		
	}
	
	/**
	 * LWWS のエリア番号を返すメソッド
	 * 
	 * @param $postid
	 * @return lwws_area
	 */
	function getLWWSarea($postid) {
		
		$lwws_area = WPOTENKI_LOCATION;
		$wpotenki_area = get_post_meta($postid, WPOTENKI_EX_METANAME, true);
		
		if($wpotenki_area != '') {
			/* 数字のみのID 指定 */
			if(is_numeric($wpotenki_area)) {
				$lwws_area = $wpotenki_area;
			}
			/* ezbridge format! (wp-eznavi By Sa.Ga) */
			if(preg_match('/^id=/', $wpotenki_area)) {
				list($id, $city, $lat, $long, $comment)
					= split(';', $wpotenki_area, 5);
				list($dummy, $lwws_area)
					= split('=', $id, 2);
			}
		}
		
		return $lwws_area;
		
	}
	
}

/******************************************************************************
 * WpOtenki - WordPress Interface Define
 *****************************************************************************/

$wpotenkiex = & new WpOtenkiEx();

?>
