<?php

function organizer_plug_pages() {
	if(organizer_check_organizer()){
		add_menu_page("Ogranizer","Organizer",1,"organizer/page/index.php");
		if(organizer_check_organizer_upload()){
			add_submenu_page("organizer/page/index.php", 'Upload', 'Upload', 1, 'organizer/page/upload.php');
		}
		if(organizer_check_organizer_directory()){
			add_submenu_page("organizer/page/index.php", 'Directory', 'Directory', 1, 'organizer/page/dir.php');
		}
		if(organizer_check_organizer_option()){
			add_submenu_page("organizer/page/index.php", 'Users', 'Users',1, 'organizer/page/users.php');
			add_submenu_page("organizer/page/index.php", 'Option', 'Option',1, 'organizer/page/options.php');
		}
		add_submenu_page("organizer/page/index.php", 'View file', 'View file',100, 'organizer/page/view.php');
		add_submenu_page("organizer/page/index.php", 'Resize', 'Resize',100, 'organizer/page/resize.php');
	}
}

function organizer_install_organizer(){
	add_option('organizer_installed', '1', 'Organizer Installed', 'yes');
	add_option('organizer_version', '1.0', 'Organizer Installed Version', 'yes');
	add_option('organizer_list_page', '25', 'Organizer list files per page', 'yes');
	add_option('organizer_filetypes', 'jpg jpeg gif png zip rar txt tar doc xls pdf html htm mp3 wav mid avi wma wmv php', 'Organizer file types', 'yes');
}

function organizer_initialize(){
	global $organizer_dirs,$organizer_files_dir,$organizer_files_path,$organizer_path,$user_login;
	global $organizer_upload_limit,$organizer_extensions,$organizer_quota,$upload_path;
	$user_setting = organizer_get_user_setting($user_login);
	if(get_settings('upload_path')!=''){
		$upload_path = get_settings('upload_path');
	}else{
		$upload_path = 'wp-content/uploads';
	}
	if($user_setting){
		if($user_setting[$user_login]['access']==0){
			$upload_path_user = $upload_path .'/'.sanitize_title_with_dashes($user_login);
			$upload_path_user_a = organizer_fix_windows_path(ABSPATH.$upload_path_user);
			if(!file_exists($upload_path_user_a)){
				if(is_writable(organizer_fix_windows_path(ABSPATH.$upload_path))){
					@mkdir($upload_path_user_a,0777);
					@chmod($upload_path_user_a,0777);
					$upload_path = $upload_path .'/'.sanitize_title_with_dashes($user_login);
				}
			}else{
				$upload_path = $upload_path .'/'.sanitize_title_with_dashes($user_login);
			}
		}
		$organizer_extensions=$user_setting[$user_login]['extension'];
		$organizer_upload_limit=$user_setting[$user_login]['uploadsize'];
		$organizer_quota=$user_setting[$user_login]['uploadquota'];
	}else{
		$organizer_extensions=get_settings('organizer_filetypes');
		$organizer_upload_limit=0;
		$organizer_quota=0;
	}
	$organizer_path =  organizer_fix_windows_path(dirname(__FILE__));
	$organizer_path = str_replace($_SERVER['DOCUMENT_ROOT'],"",$organizer_path);
	$organizer_path = organizer_fix_organizer_path(organizer_fix_windows_path($organizer_path));
	$organizer_files_dir = organizer_fix_windows_path(ABSPATH.$upload_path);
	$organizer_upload_dir_url_parts = parse_url(get_settings('siteurl').'/'.$upload_path);
	$organizer_files_path = organizer_fix_windows_path($organizer_upload_dir_url_parts['path']);
	$organizer_dirs = organizer_get_directories($organizer_files_dir);
}

function organizer_add_files_to_admin_head(){
	global $organizer_path;
	print "<script type=\"text/javascript\" src=\"/$organizer_path/general.js\"></script>\n";;
	print "<link rel=\"stylesheet\" href=\"/$organizer_path/general.css\" type=\"text/css\" />\n";
}

function organizer_die_no_permision(){
	print '<div class="wrap">'.__('Access denied','organizer').'</div>';
	include_once('admin-footer.php');
	die();
}

function organizer_capabilities($caps) {
	$caps[] = 'Organizer';
	$caps[] = 'Organizer Rename';
	$caps[] = 'Organizer Copy';
	$caps[] = 'Organizer Delete';
	$caps[] = 'Organizer Resize';
	$caps[] = 'Organizer Directory';
	$caps[] = 'Organizer Upload';
	$caps[] = 'Organizer Option';
	return $caps;
}

function organizer_check_organizer(){
	if(current_user_can ('activate_plugins') || current_user_can ('Organizer') ){
		return true;
	}else {
		return false;
	}
}
function organizer_check_organizer_rename(){
	if(current_user_can ('activate_plugins') || current_user_can ('Organizer Rename') ){
		return true;
	}else {
		return false;
	}
}
function organizer_check_organizer_copy(){
	if(current_user_can ('activate_plugins') || current_user_can ('Organizer Copy') ){
		return true;
	}else {
		return false;
	}
}
function organizer_check_organizer_delete(){
	if(current_user_can ('activate_plugins') || current_user_can ('Organizer Delete') ){
		return true;
	}else {
		return false;
	}
}
function organizer_check_organizer_resize(){
	if(current_user_can ('activate_plugins') || current_user_can ('Organizer Resize') ){
		return true;
	}else {
		return false;
	}
}
function organizer_check_organizer_directory(){
	if(current_user_can ('activate_plugins') || current_user_can ('Organizer Directory') ){
		return true;
	}else {
		return false;
	}
}
function organizer_check_organizer_upload(){
	if(current_user_can ('activate_plugins') || current_user_can ('Organizer Upload') ){
		return true;
	}else {
		return false;
	}
}
function organizer_check_organizer_option(){
	if(current_user_can ('activate_plugins') || current_user_can ('Organizer Option') ){
		return true;
	}else {
		return false;
	}
}

function organizer_fix_windows_path($path){
	$path = str_replace("\\","/",$path);
	$path = str_replace("//","/",$path);
	$path = str_replace("//","/",$path);
	$path = str_replace("//","/",$path);
	if(substr($path, -1)=='/'){
		$path = substr($path,0,strlen($path)-1);
	}
	return $path;
}

function organizer_fix_organizer_path($path){
	if(substr($path, 0, 1)=='/'){
		$path = substr($path,1);
	}
	if(substr($path, -1)=='/'){
		$path = substr($path,0,strlen($path)-1);
	}
	return $path;
}

function organizer_get_directories($path){
	$folders  = array();
	$i = 0;
	if ($handle = opendir($path)){
		while ( false !== ($file = readdir($handle)) ){
			if (filetype($path."/".$file) == 'dir'){
				if ($file != '..' && $file != '.' && $file != '' && (substr($file,0,1) != '.')){
					$folders[$i] = organizer_fix_windows_path($path."/".$file);
					$i++;
				}
			}
		}
		closedir($handle);
		for ( $u = 0; $u < $i; $u++ ){
			if ($handle = opendir($folders[$u])){
				while ( false !== ($file = readdir($handle)) ){
					if (filetype($folders[$u]."/".$file) == 'dir'){
						if ($file != '..' && $file != '.' && $file != '' && (substr($file,0,1) != '.')){
							$folders[$i] = organizer_fix_windows_path($folders[$u]."/".$file);
							$i++;
						}
					}
				}
				closedir($handle);
			}
		}
	}
	$folder_without_path=array("/");
	foreach($folders as $folder){
		$folder_without_path[]=str_replace($path,"",$folder);
	}
	return $folder_without_path;
}

function organizer_generate_list($listname,$list,$value,$extras=''){
	$retval = "<select name=\"$listname\" id=\"$listname\" $extras>\n";
	foreach ($list as $key => $val){
		$selected = ($key==$value)? 'selected' : '';
		$retval .= "<option value=\"$key\" $selected>$val</option>\n";
	}
	$retval .= "</select>\n";
	print $retval;
}

function organizer_get_file_ext($filename){
	$file_parts=pathinfo($filename);
	return  $file_parts['extension'];
}

function organizer_get_file_icon($filename){
	global $file_icons,$organizer_path;
	$file_ext = organizer_get_file_ext($filename);
	$file_icons_ext = array_keys($file_icons);
	$index = 0;
	foreach ($file_icons_ext as $key => $value){
		if(strpos($value,$file_ext)!==false){
			$index=$key;
		}
	}
	return "<img src=\"/$organizer_path/icons/".$file_icons[$file_icons_ext[$index]][0]."\" alt=\"".$file_icons[$file_icons_ext[$index]][1]."\" height=\"48\" width=\"48\" />";
}

function organizer_is_valid_name($name){
	if(ereg('[^[:space:]a-zA-Z0-9_.-]{1,}', $name)){
		return false;
	}else{
		return true;
	}
}

function organizer_get_users_settings(){
	if(get_settings('organizer_users_settings')){
		$setting_data = get_settings('organizer_users_settings');
		if (!is_array($setting_data)) {
			return array();
		}else{
			return $setting_data;
		}
	}else{
		return array();
	}
}

function organizer_get_user_setting($user_id){
	foreach(organizer_get_users_settings() as $key => $value){
		if(key($value)==$user_id){
			return $value;
		}
	}
	return array();
}

function organizer_add_user_settings($setting_array,$user_setting){
	array_push($setting_array, $user_setting);
	update_option('organizer_users_settings',$setting_array);
}

function organizer_delete_user_setting($user_id){
	$removed_settings=array();
	foreach(organizer_get_users_settings() as $key => $value){
		if(key($value)!=$user_id){
			array_push($removed_settings,$value);
		}
		update_option('organizer_users_settings',$removed_settings);
	}
}

function organizer_check_ext($filename){
	global $organizer_extensions;
	$scan_ext = explode(" ",$organizer_extensions);
	foreach ($scan_ext as $value){
		$testExt = "\.".$value."$";
		if (eregi($testExt, $filename)){
			return true;
		}
	}
	return false;
}

function organizer_get_directory_size($path){
	$dir_r = organizer_get_directories($path);
	$total_size = 0;
	foreach($dir_r as $dir){
		$scandir = organizer_fix_windows_path( $path.'/'.$dir);
		$dir_handle = opendir($scandir);
		while((false!==($file=readdir($dir_handle)))){
			if($file!="." and $file !=".." and organizer_check_ext($file)){
				$total_size = $total_size + filesize($scandir.'/'.$file);
			}
		}
		closedir($dir_handle);
	}
	return $total_size;	
}

?>
