<?php
if(!organizer_check_organizer()){
	organizer_die_no_permision();
}

if(!organizer_check_organizer_directory()){
	organizer_die_no_permision();
}

if(isset($_POST['create'])){
	$dirname = stripslashes(trim($_POST['dirname']));
	$directory = intval($_POST['directory']);
	if($dirname!=''){
		if(organizer_is_valid_name(($dirname))){
			$create_dir = organizer_fix_windows_path($organizer_files_dir.'/'.$organizer_dirs[$directory].'/'.$dirname);
			if(@mkdir($create_dir,0777)){
				@chmod($create_dir,0777);
				$dirname='';
				$directory=0;
				$organizer_dirs = organizer_get_directories($organizer_files_dir);
				$msg = __('Directory created','organizer');
			}else{
				$msg = __('Directory creation failed','organizer');
			}
		}else{
			$msg = __('Directory name contains invalid characters','organizer');
		}
	}else{
		$msg = __('Directory name cannot be empty','organizer');
	}
}
if(isset($_POST['rename'])){
	$newdirname = stripslashes(trim($_POST['newdirname']));
	$newdirectory = intval($_POST['newdirectory']);
	if($newdirname!=''){
		if(organizer_is_valid_name(($newdirname))){
			$remove_dir=organizer_fix_windows_path($organizer_files_dir.'/'.$organizer_dirs[$newdirectory+1]);
			$create_dir_prefix = implode("/",array_slice(explode("/",$remove_dir),0,count(explode("/",$remove_dir))-1));
			if(@rmdir($remove_dir)){
				if(@mkdir(organizer_fix_windows_path($create_dir_prefix.'/'.$newdirname),0777)){
					@chmod(organizer_fix_windows_path($create_dir_prefix.'/'.$newdirname),0777);
					$newdirectory=0;
					$newdirname='';
					$organizer_dirs = organizer_get_directories($organizer_files_dir);
					$msg = __('Directory renamed','organizer');
				}
			}else{
				$msg = __('Cannot rename directory','organizer');
			}
		}else{
			$msg = __('Directory name contains invalid characters','organizer');
		}
	}else{
		$msg = __('Directory name cannot be empty','organizer');
	}
}
if(isset($_POST['remove'])){
	$removedirectory = intval($_POST['removedirectory']);
	$remove_dir=organizer_fix_windows_path($organizer_files_dir.'/'.$organizer_dirs[$removedirectory+1]);
	if(@rmdir($remove_dir)){
		$organizer_dirs = organizer_get_directories($organizer_files_dir);
		$removedirectory=0;
		$msg = __('Directory removed','organizer');
	}else{
		$msg = __('Cannot delete directory','organizer');
	}
}
$this_page_url = "admin.php?page=organizer/page/dir.php";
?>
<?php if ($msg!='') : ?>
<div id="message" class="updated fade"><p><strong><?php print $msg; ?></strong></p></div>
<?php endif; ?>
<form name="frmdir" id="frmdir" method="POST" action="<?php print $this_page_url; ?>"> 
<div class="wrap">
<h2><?php _e('Create Directory','organizer'); ?></h2>
<table cellpadding="2" cellspacing="2" width="100%" border="0">
	<tr>
		<td align="right" width="30%"><?php _e('Create in','organizer'); ?> : </td>
		<td><?php print organizer_generate_list("directory",$organizer_dirs,$directory); ?></td>
	</tr>
	<tr>
		<td align="right" width="30%"><?php _e('Directory Name','organizer'); ?> : </td>
		<td><input type="text" name="dirname" id="dirname" size="30" maxlength="25" value="<?php print $dirname; ?>" /></td>
	</tr>
</table>
	<p class="submit">
	  <input type="submit" name="create" value="<?php _e('Create Directory','organizer') ?> &raquo;" />
	</p>
<h2><?php _e('Rename Directory','organizer'); ?></h2>
<table cellpadding="2" cellspacing="2" width="100%" border="0">
	<tr>
		<td align="right" width="30%"><?php _e('Rename directory','organizer'); ?> : </td>
		<td><?php print organizer_generate_list("newdirectory",array_slice($organizer_dirs,1),$newdirectory); ?></td>
	</tr>
	<tr>
		<td align="right" width="30%"><?php _e('Note','organizer'); ?> : </td>
		<td><?php _e('Only empty directory can be renamed','organizer'); ?></td>
	</tr>
	<tr>
		<td align="right" width="30%"><?php _e('Directory Name','organizer'); ?> : </td>
		<td><input type="text" name="newdirname" id="newdirname" size="30" maxlength="25" value="<?php print $newdirname; ?>" /></td>
	</tr>
</table>
	<p class="submit">
	  <input type="submit" name="rename" value="<?php _e('Rename Directory','organizer') ?> &raquo;" />
	</p>
<h2><?php _e('Remove Directory','organizer'); ?></h2>
<table cellpadding="2" cellspacing="2" width="100%" border="0">
	<tr>
		<td align="right" width="30%"><?php _e('Remove directory','organizer'); ?> : </td>
		<td><?php print organizer_generate_list("removedirectory",array_slice($organizer_dirs,1),$removedirectory); ?></td>
	</tr>
	<tr>
		<td align="right" width="30%"><?php _e('Note','organizer'); ?> : </td>
		<td><?php _e('Only empty directory can be deleted','organizer'); ?></td>
	</tr>
</table>
	<p class="submit">
	  <input type="submit" name="remove" value="<?php _e('Remove Directory','organizer') ?> &raquo;" />
	</p>
</div>
</form>