<?php
define('WP_INSTALLING', true);
require_once('../wpj-wizard.php');
require_once('../wp-includes/functions.php');

if (!file_exists('../wp-config-sample.php'))
	wpj_die(_LANG_WA_CONFIG_GUIDE2, "WordPress &rsaquo; Error");

$configFile = file('../wp-config-sample.php');

$my_dirname = dirname(__FILE__);
$dir_list = explode("/", $my_dirname);
$dummy = array_pop($dir_list);
$inst_path = implode("/", $dir_list);

if (!is_writable('../')) wpj_die(sprintf(_LANG_WA_CONFIG_GUIDE3, $inst_path), "WordPress &rsaquo; Error");

if (isset($_GET['step']))
	$step = $_GET['step'];
else
	$step = 0;
header( 'Content-Type: text/html; charset=utf-8' );
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>WordPress &rsaquo; Setup Configuration File</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<style media="screen" type="text/css">
	<!--
	html {
		background: #fff;
	}
	body {
		background: #fff;
		color: #000;
		font: 90%/175% Osaka, Verdana, sans-serif;
		margin-left: 15%;
		margin-right: 15%;	}

	h1 {
		color: #006;
		font-size: 18px;
		font-weight: lighter;
	}

	h2 {
		font-size: 16px;
	}

	p, li, dt {
		line-height: 140%;
		padding-bottom: 2px;
	}

	ul, ol {
		padding: 5px 5px 5px 20px;
	}
	#logo {
		margin-bottom: 2em;
	}
	.step a, .step input {
		font-size: 2em;
	}
	td input {
		font-size: 1.5em;
	}
	.step {
		text-align: right;
	}

	th {
		background-color: #f7f7f7;
		text-align: left;
		padding-left: 3px;
	}

	#footer {
		text-align: center;
		border-top: 1px solid #ccc;
		padding-top: 1em;
		font-style: italic;
	}
	-->
	</style>
</head>
<body>
<h1 id="logo"><img alt="WordPress" src="images/wordpress-logo.png" /></h1>
<?php
// Check if wp-config.php has been created
if (file_exists('../wp-config.php'))
	die(_LANG_WA_CONFIG_GUIDE1);

switch($step) {
	case 0:
?>

<p><?php echo _LANG_WA_CONFIG_GUIDE4; ?></p>
<ol>
	<li><?php echo _LANG_WA_CONFIG_DATABASE; ?></li>
	<li><?php echo _LANG_WA_CONFIG_USERNAME; ?></li>
	<li><?php echo _LANG_WA_CONFIG_PASSWORD; ?></li>
	<li><?php echo _LANG_WA_CONFIG_LOCALHOST; ?></li>
	<li><?php echo _LANG_WA_CONFIG_PREFIX; ?></li>
</ol>
<p><?php echo _LANG_WA_CONFIG_GUIDE5; ?></p>
<?php
	break;

	case 1:
?>
<form method="post" action="setup-config.php?step=2"> 
  <p><?php echo _LANG_WA_CONFIG_GUIDE6; ?></p>
  <table> 
    <tr> 
      <th scope="row" width="40%"><?php echo _LANG_WA_CONFIG_DATABASE; ?></th>
      <td><input name="dbname" type="text" size="25" value="wordpress" /></td> 
    </tr> 
    <tr> 
      <td colspan="2"><?php echo _LANG_WA_CONFIG_GUIDE7; ?><br /><br /></td> 
       </tr> 
       <tr> 
         <th scope="row"><?php echo _LANG_WA_CONFIG_USERNAME; ?></th> 
      <td><input name="uname" type="text" size="25" value="username" /></td> 
    </tr> 
    <tr> 
      <td colspan="2"><?php echo _LANG_WA_CONFIG_GUIDE8; ?><br /><br /></td> 
       </tr> 
       <tr> 
         <th scope="row"><?php echo _LANG_WA_CONFIG_PASSWORD; ?></th> 
      <td><input name="pwd" type="text" size="25" value="password" /></td> 
    </tr> 
    <tr> 
      <td colspan="2"><?php echo _LANG_WA_CONFIG_GUIDE9; ?><br /><br /></td> 
       </tr> 
       <tr> 
         <th scope="row"><?php echo _LANG_WA_CONFIG_LOCALHOST; ?></th> 
      <td><input name="dbhost" type="text" size="25" value="localhost" /></td> 
    </tr>
    <tr>
      <td colspan="2"><?php echo _LANG_WA_CONFIG_GUIDE10; ?><br /><br /></td> 
       </tr> 
       <tr> 
         <th scope="row"><?php echo _LANG_WA_CONFIG_PREFIX; ?></th> 
      <td><input name="prefix" type="text" id="prefix" value="wp_" size="25" /></td>
      </tr> 
      <tr> 
         <td colspan="2"><?php echo _LANG_WA_CONFIG_GUIDE11; ?><br /><br /></td>
    </tr> 
    <tr>
      <th scope="row"><?php echo _LANG_WA_CONFIG_ENCODE; ?></th>
      <td>
<select name="encode">
        <option value="ja_EUC" selected>EUC-JP</option>
        <option value="ja_UTF">UTF-8</option>
        <option value="ja_SJIS">Shift_JIS</option>
</select>
      </td>
    </tr>
    <tr>
      <td colspan="2"><?php echo _LANG_WA_CONFIG_GUIDE13; ?>
      <ul>
        <li><?php echo _LANG_WA_CONFIG_GUIDE14; ?></li>
        <li><?php echo _LANG_WA_CONFIG_GUIDE15; ?></li>
        <li><?php echo _LANG_WA_CONFIG_GUIDE16; ?></li>
      </ul>
      <?php echo _LANG_WA_CONFIG_GUIDE17; ?></td>
    </tr>
  </table>
  <p align="right"><input name="submit" type="submit" value="Submit" /></p>
</form>
<?php
	break;

	case 2:
	$dbname  = trim($_POST['dbname']);
	$uname   = trim($_POST['uname']);
	$passwrd = trim($_POST['pwd']);
	$dbhost  = trim($_POST['dbhost']);
	$prefix  = trim($_POST['prefix']);
	if (empty($prefix)) $prefix = 'wp_';
	$local_file = $_POST['encode'];

	if($local_file == 'ja_EUC') {
		$mb_setting = 'EUC-JP';
	} elseif($local_file == 'ja_SJIS') {
		$mb_setting = 'Shift_JIS';
	} else {
		$mb_setting = 'UTF-8';
	}

	// Test the db connection.
	define('DB_NAME', $dbname);
	define('DB_USER', $uname);
	define('DB_PASSWORD', $passwrd);
	define('DB_HOST', $dbhost);

	// We'll fail here if the values are no good.
	require_once('../wp-includes/wp-db.php');
	$handle = fopen('../wp-config.php', 'w');

	foreach ($configFile as $line_num => $line) {
		switch (substr($line,0,16)) {
			case "define('DB_NAME'":
				fwrite($handle, str_replace("wordpress", $dbname, $line));
				break;
			case "define('DB_USER'":
				fwrite($handle, str_replace("'username'", "'$uname'", $line));
				break;
			case "define('DB_PASSW":
				fwrite($handle, str_replace("'password'", "'$passwrd'", $line));
				break;
			case "define('DB_HOST'":
				fwrite($handle, str_replace("localhost", $dbhost, $line));
				break;
			case '$table_prefix  =':
				fwrite($handle, str_replace('wp_', $prefix, $line));
				break;
			case "define ('WPLANG'": 
				fwrite($handle, str_replace("mo_file", $local_file, $line)); 
				break; 
			case "mb_internal_enco": 
				fwrite($handle, str_replace("UTF-8", $mb_setting, $line)); 
				break; 
			default:
				fwrite($handle, $line);
		}
	}
	fclose($handle);
	chmod('../wp-config.php', 0604);
?>
<p><?php echo _LANG_WA_CONFIG_GUIDE12; ?></p>
<?php
	break;
}
?>
<p id="footer"><a href="http://wordpress.org/">WordPress</a>, personal publishing platform.</p>
</body>
</html>
