package net.yher.waft.controller;

import java.net.URL;

import net.yher.waft.controller.URLMap;
import net.yher.waft.controller.URLMapTable;

import junit.framework.TestCase;

public class URLMapTableTest extends TestCase {
	public void testConstruct() {
		URL source = ClassLoader.getSystemResource("net/yher/waft/controller/test_map");
		new URLMapTable(source);
	}
	
	public void testFind() throws Exception {
		URL source = ClassLoader.getSystemResource("net/yher/waft/controller/test_map");
		URLMapTable  table = new URLMapTable(source);
		URLMap matchedMap = table.find("/task/13/");
		assertNotNull(matchedMap);
		assertEquals("OK:13:detail", matchedMap.invokeAction(null, null));

		matchedMap = table.find("/another/hoge_13%12/");
		assertNotNull(matchedMap);
		assertEquals("OK:hoge_13%12:another", matchedMap.invokeAction(null, null));
	
		matchedMap = table.find("/task/41/print");
		assertNotNull(matchedMap);
		assertEquals("OK:41:print", matchedMap.invokeAction(null, null));
	}
}
