
/**
 * Copyright (c) 2006, yher.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher.workstyle.torque.bean;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;


                    
/**
 * This class was autogenerated by Torque on:
 *
 * [Sat Dec 09 17:06:33 JST 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TaskFileRelationBean
 */
@SuppressWarnings("unused")
public abstract class BaseTaskFileRelationBean
    implements Serializable
{

    /**
     * whether the bean or its underlying object has changed
     * since last reading from the database
     */
    private boolean modified = true;

    /**
     * false if the underlying object has been read from the database,
     * true otherwise
     */
    private boolean isNew = true;

  
    /** The value for the taskId field */
    private int taskId;
  
    /** The value for the fileId field */
    private int fileId;


    /**
     * sets whether the bean exists in the database
     */
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }

    /**
     * returns whether the bean exists in the database
     */
    public boolean isNew()
    {
        return this.isNew;
    }

    /**
     * sets whether the bean or the object it was created from
     * was modified since the object was last read from the database
     */
    public void setModified(boolean isModified)
    {
        this.modified = isModified;
    }

    /**
     * returns whether the bean or the object it was created from
     * was modified since the object was last read from the database
     */
    public boolean isModified()
    {
        return this.modified;
    }


    /**
     * Get the TaskId
     *
     * @return int
     */
    public int getTaskId ()
    {
        return taskId;
    }

    /**
     * Set the value of TaskId
     *
     * @param v new value
     */
    public void setTaskId(int v)
    {
  
        this.taskId = v;
        setModified(true);

    }

    /**
     * Get the FileId
     *
     * @return int
     */
    public int getFileId ()
    {
        return fileId;
    }

    /**
     * Set the value of FileId
     *
     * @param v new value
     */
    public void setFileId(int v)
    {
  
        this.fileId = v;
        setModified(true);

    }

      
    
                  
    
        private TaskBean aTaskBean;

    /**
     * sets an associated TaskBean object
     *
     * @param v TaskBean
     */
    public void setTaskBean(TaskBean v)
    {
            if (v == null)
        {
                          setTaskId( 0);
              }
        else
        {
            setTaskId(v.getTaskId());
        }
            aTaskBean = v;
    }

                        
    /**
     * Get the associated TaskBean object
     *
     * @return the associated TaskBean object
     */
    public TaskBean getTaskBean()
    {
        return aTaskBean;
    }

  
    
                  
    
        private FileInfoBean aFileInfoBean;

    /**
     * sets an associated FileInfoBean object
     *
     * @param v FileInfoBean
     */
    public void setFileInfoBean(FileInfoBean v)
    {
            if (v == null)
        {
                          setFileId( 0);
              }
        else
        {
            setFileId(v.getFileId());
        }
            aFileInfoBean = v;
    }

                        
    /**
     * Get the associated FileInfoBean object
     *
     * @return the associated FileInfoBean object
     */
    public FileInfoBean getFileInfoBean()
    {
        return aFileInfoBean;
    }

  

        }
