package net.yher.workstyle.action.tagType.rest;

import javax.servlet.http.HttpServletRequest;

import net.yher.commons.struts.Validator;
import net.yher.workstyle.Properties;
import net.yher.workstyle.action.tagType.SelectForm;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

public class ChangeStyleForm extends SelectForm {
	private String styleClass;

	@Override
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		super.reset(mapping, request);
		styleClass = "";
	}

	@Override
	public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
		Validator validator = new Validator(super.validate(mapping, request));
		validator.verifyRequired(Properties.STYLE, styleClass);
		validator.verifyMaxLength(Properties.STYLE, styleClass, 10);
		return validator.getErrors();
	}

	public String getStyleClass() {
		return styleClass;
	}

	public void setStyleClass(String name) {
		this.styleClass = name;
	}
}
