package net.yher.waft.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

public class URLMapTable {
	private URL source = null;
	private long lastModified = 0;
	private List<URLMapPattern> patternList;
	public URLMapTable(URL source) {
		this.source= source;
		this.patternList = new ArrayList<URLMapPattern>();
	}
	
	private synchronized void load() {
		try {
			URLConnection con = source.openConnection();
			long modified = con.getLastModified();
			if (modified <= this.lastModified) {
				return;
			}
			synchronized (patternList) {
                patternList.clear();
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                String line = "";
                while ((line = in.readLine()) != null) {
                    if (StringUtils.isBlank(line)) continue;
                	patternList.add(new URLMapPattern(line));
                }
            }
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public synchronized URLMap find(String url) {
        load();
        for (URLMapPattern pattern : patternList) {
            URLMap map = pattern.matcher(url);
            if (map.isMatch()) return map;
        }
        return null;
	}
}
