package net.yher.waft.controller;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;

import java.io.IOException;
import java.util.regex.Pattern;

import org.codehaus.groovy.control.CompilationFailedException;

public class URLMapPattern {
	private static GroovyClassLoader loader = new GroovyClassLoader(URLMapPattern.class.getClassLoader());
	private static boolean release = false;
	
	private Pattern urlPattern = null;
	private String className = "";
	private String classFile = "";
	private String method = "";
	private String argumentJSON = "";
	
	public URLMapPattern(String line) {
		String data[] = line.split("[\t]");
		if (data.length < 3) {
			throw new IllegalArgumentException("line: " + line);
		}
		this.urlPattern = Pattern.compile(data[0]);
		this.className = data[1];
		this.classFile = this.className.replaceAll("\\.", "/") + ".groovy";
		this.method = data[2];
		if (data.length > 3) {
			this.argumentJSON = data[3];
		}
	}
	/**
	 * return URLMap which maches with input relativeURL.
	 * @param url
	 * @return
	 */
	public URLMap matcher(String relativeURL) {
		return new URLMap(this, relativeURL);
	}
	public GroovyObject getGroovyObject() throws InstantiationException, IllegalAccessException, CompilationFailedException, IOException, ClassNotFoundException {
		Class cls = null;
		if (release) {
			cls = loader.loadClass(this.className, true, true);
		} else {
//			cls = loader.parseClass(ClassLoader.getSystemResourceAsStream(this.classFile));
			cls = loader.parseClass(this.getClass().getClassLoader().getResourceAsStream(this.classFile));
		}
		return (GroovyObject)cls.newInstance();
	}
	public boolean hasArgument() {
		return argumentJSON != null && argumentJSON.length() > 0;
	}
	public String getArgumentJSON() {
		return argumentJSON;
	}
	public String getClassName() {
		return className;
	}
	public Pattern getUrlPattern() {
		return urlPattern;
	}
	public String getMethod() {
		return method;
	}
	public String getClassFile() {
		return classFile;
	}
	public static boolean isRelease() {
		return release;
	}
	public static void setRelease(boolean release) {
		URLMapPattern.release = release;
	}
	
}
