package net.yher.waft.controller;

import java.io.IOException;
import java.util.regex.Matcher;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class URLMap {
	private URLMapPattern urlMapPattern;
	private boolean match = false;
	private Object argument = null;
	
	public URLMap(URLMapPattern pattern, String relativeURL) {
		if (!relativeURL.endsWith("/"))
			relativeURL += "/";
		this.urlMapPattern = pattern;
		Matcher matcher = pattern.getUrlPattern().matcher(relativeURL);
		this.match = matcher.matches();
		if (this.match && pattern.hasArgument()) {
			String argumentJSON = matcher.replaceAll(pattern.getArgumentJSON());
			String normalized = argumentJSON.trim().toUpperCase();
			if (normalized.startsWith("{") && normalized.endsWith("}"))
				this.argument = new JSONObject(argumentJSON);
			else if (normalized.startsWith("[") && normalized.endsWith("]"))
				this.argument = new JSONArray(argumentJSON);
			else if (normalized.equals("TRUE") || normalized.equals("FALSE"))
				this.argument = Boolean.valueOf(normalized);
			else if (StringUtils.isNumeric(normalized))
				this.argument = new Integer(normalized);
			else if (normalized.matches("^\\d+\\.\\d+$"))
				this.argument = Double.valueOf(normalized);
			else
				this.argument = argumentJSON;
			
		}
	}

	public boolean isMatch() {
		return match;
	}
	public String invokeAction(HttpServletRequest request, HttpServletResponse response) throws ServletException, InstantiationException, IllegalAccessException, CompilationFailedException, IOException, ClassNotFoundException {
		Object arg[] = new Object[]{request, response};
		if (this.argument != null)
			arg = new Object[]{request, response, this.argument};
		Object result = this.urlMapPattern.getGroovyObject().invokeMethod(this.urlMapPattern.getMethod(), arg);
		return (String)result;
	}
}
