/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.control.SourceUnit;

public class ClassCompletionVerifier
extends ClassCodeVisitorSupport {
    private ClassNode currentClass;
    private SourceUnit source;

    public ClassCompletionVerifier(SourceUnit source) {
        this.source = source;
    }

    public ClassNode getClassNode() {
        return this.currentClass;
    }

    public void visitClass(ClassNode node) {
        ClassNode oldClass = this.currentClass;
        this.currentClass = node;
        this.checkImplementsAndExtends(node);
        if (this.source != null && !this.source.getErrorCollector().hasErrors()) {
            this.checkClassForIncorrectModifiers(node);
            this.checkClassForOverwritingFinal(node);
            this.checkMethodsForIncorrectModifiers(node);
            this.checkMethodsForOverwritingFinal(node);
            this.checkNoAbstractMethodsNonabstractClass(node);
        }
        super.visitClass(node);
        this.currentClass = oldClass;
    }

    private void checkNoAbstractMethodsNonabstractClass(ClassNode node) {
        if (Modifier.isAbstract(node.getModifiers())) {
            return;
        }
        List abstractMethods = node.getAbstractMethods();
        if (abstractMethods == null) {
            return;
        }
        Iterator iter = abstractMethods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            String methodName = method.getTypeDescriptor();
            this.addError("Can't have an abstract method in a non-abstract class. The class '" + node.getName() + "' must be declared abstract or" + " the method '" + methodName + "' must be implemented.", node);
        }
    }

    private void checkClassForIncorrectModifiers(ClassNode node) {
        this.checkClassForAbstractAndFinal(node);
        this.checkClassForOtherModifiers(node);
    }

    private void checkClassForAbstractAndFinal(ClassNode node) {
        if (!Modifier.isAbstract(node.getModifiers())) {
            return;
        }
        if (!Modifier.isFinal(node.getModifiers())) {
            return;
        }
        if (node.isInterface()) {
            this.addError("The interface '" + node.getName() + "' must not be final. It is by definition abstract.", node);
        } else {
            this.addError("The class '" + node.getName() + "' must not be both final and abstract.", node);
        }
    }

    private void checkClassForOtherModifiers(ClassNode node) {
        this.checkClassForModifier(node, Modifier.isTransient(node.getModifiers()), "transient");
        this.checkClassForModifier(node, Modifier.isVolatile(node.getModifiers()), "volatile");
    }

    private void checkClassForModifier(ClassNode node, boolean condition, String modifierName) {
        if (!condition) {
            return;
        }
        this.addError("The " + (node.isInterface() ? "interface" : "class") + " '" + node.getName() + "' has an incorrect modifier " + modifierName + ".", node);
    }

    private void checkAbstractDeclaration(MethodNode methodNode) {
        if (!Modifier.isAbstract(methodNode.getModifiers())) {
            return;
        }
        if (Modifier.isAbstract(this.currentClass.getModifiers())) {
            return;
        }
        this.addError("Can't have an abstract method in a non-abstract class. The class '" + this.currentClass.getName() + "' must be declared abstract or the method '" + methodNode.getTypeDescriptor() + "' must not be abstract.", methodNode);
    }

    private void checkClassForOverwritingFinal(ClassNode cn) {
        ClassNode superCN = cn.getSuperClass();
        if (superCN == null) {
            return;
        }
        if (!Modifier.isFinal(superCN.getModifiers())) {
            return;
        }
        StringBuffer msg = new StringBuffer();
        msg.append("You are not allowed to overwrite the final class ");
        msg.append(superCN.getName());
        msg.append(".");
        this.addError(msg.toString(), cn);
    }

    private void checkImplementsAndExtends(ClassNode node) {
        ClassNode cn = node.getSuperClass();
        if (cn.isInterface() && !node.isInterface()) {
            this.addError("You are not allowed to extend the Interface " + cn.getName() + ", use implements instead.", node);
        }
        ClassNode[] interfaces = node.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            cn = interfaces[i];
            if (cn.isInterface()) continue;
            this.addError("You are not allowed to implement the Class " + cn.getName() + ", use extends instead.", node);
        }
    }

    private void checkMethodsForIncorrectModifiers(ClassNode cn) {
        if (!cn.isInterface()) {
            return;
        }
        List methods = cn.getMethods();
        Iterator cnIter = methods.iterator();
        while (cnIter.hasNext()) {
            MethodNode method = (MethodNode)cnIter.next();
            if (Modifier.isFinal(method.getModifiers())) {
                this.addError("Method '" + method.getName() + "' from Interface '" + cn.getName() + "' must not be final. It is by definition abstract.", method);
            }
            if (!Modifier.isStatic(method.getModifiers()) || this.isConstructor(method)) continue;
            this.addError("Method '" + method.getName() + "' from Interface '" + cn.getName() + "' must not be static. Only fields may be static in an interface.", method);
        }
    }

    private boolean isConstructor(MethodNode method) {
        return method.getName().equals("<clinit>");
    }

    private void checkMethodsForOverwritingFinal(ClassNode cn) {
        List methods = cn.getMethods();
        Iterator cnIter = methods.iterator();
        while (cnIter.hasNext()) {
            MethodNode method = (MethodNode)cnIter.next();
            Parameter[] params = method.getParameters();
            for (ClassNode superCN = cn.getSuperClass(); superCN != null; superCN = superCN.getSuperClass()) {
                List superMethods = superCN.getMethods(method.getName());
                Iterator iter = superMethods.iterator();
                while (iter.hasNext()) {
                    MethodNode superMethod = (MethodNode)iter.next();
                    Parameter[] superParams = superMethod.getParameters();
                    if (!this.hasEqualParameterTypes(params, superParams)) continue;
                    if (!Modifier.isFinal(superMethod.getModifiers())) {
                        return;
                    }
                    this.addInvalidUseOfFinalError(method, params, superCN);
                    return;
                }
            }
        }
    }

    private void addInvalidUseOfFinalError(MethodNode method, Parameter[] parameters, ClassNode superCN) {
        StringBuffer msg = new StringBuffer();
        msg.append("You are not allowed to overwrite the final method ").append(method.getName());
        msg.append("(");
        boolean needsComma = false;
        for (int i = 0; i < parameters.length; ++i) {
            if (needsComma) {
                msg.append(",");
            } else {
                needsComma = true;
            }
            msg.append(parameters[i].getType());
        }
        msg.append(") from class ").append(superCN.getName());
        msg.append(".");
        this.addError(msg.toString(), method);
    }

    private boolean hasEqualParameterTypes(Parameter[] first, Parameter[] second) {
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            String st;
            String ft = first[i].getType().getName();
            if (ft.equals(st = second[i].getType().getName())) continue;
            return false;
        }
        return true;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        ClassNode type = call.getType();
        if (Modifier.isAbstract(type.getModifiers())) {
            this.addError("You cannot create an instance from the abstract class " + type.getName() + ".", call);
        }
        super.visitConstructorCallExpression(call);
    }

    public void visitMethod(MethodNode node) {
        this.checkAbstractDeclaration(node);
        this.checkRepetitiveMethod(node);
        super.visitMethod(node);
    }

    private void checkRepetitiveMethod(MethodNode node) {
        if (this.isConstructor(node)) {
            return;
        }
        List methods = this.currentClass.getMethods(node.getName());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Parameter[] p2;
            Parameter[] p1;
            MethodNode element = (MethodNode)iter.next();
            if (element == node || !element.getDeclaringClass().equals(node.getDeclaringClass()) || (p1 = node.getParameters()).length != (p2 = element.getParameters()).length) continue;
            this.addErrorIfParamsAndReturnTypeEqual(p2, p1, node, element);
        }
    }

    private void addErrorIfParamsAndReturnTypeEqual(Parameter[] p2, Parameter[] p1, MethodNode node, MethodNode element) {
        boolean isEqual = true;
        for (int i = 0; i < p2.length; ++i) {
            isEqual &= p1[i].equals(p2[i]);
        }
        if (isEqual &= node.getReturnType().equals(element.getReturnType())) {
            this.addError("Repetitive method name/signature for method " + node.getName() + " in class " + this.currentClass.getName() + ".", node);
        }
    }

    public void visitField(FieldNode node) {
        if (this.currentClass.getField(node.getName()) != node) {
            this.addError("The field " + node.getName() + " is declared multiple times.", node);
        }
        this.checkInterfaceFieldModifiers(node);
        super.visitField(node);
    }

    private void checkInterfaceFieldModifiers(FieldNode node) {
        if (!this.currentClass.isInterface()) {
            return;
        }
        if ((node.getModifiers() & 0x19) == 0) {
            this.addError("The field " + node.getName() + " is not 'public final static' but part of the interface " + this.currentClass.getName() + ".", node);
        }
    }

    public void visitBinaryExpression(BinaryExpression expression) {
        if (expression.getOperation().getType() == 30 && expression.getRightExpression() instanceof MapEntryExpression) {
            this.addError("You tried to use a map entry for an index operation, this is not allowed. Maybe something should be set in parentheses or a comma is missing?", expression.getRightExpression());
        }
        super.visitBinaryExpression(expression);
    }

    public void visitCatchStatement(CatchStatement cs) {
        if (!cs.getExceptionType().isDerivedFrom(ClassHelper.make(Throwable.class))) {
            this.addError("Catch statement parameter type is not a subclass of Throwable.", cs);
        }
        super.visitCatchStatement(cs);
    }
}

