/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.Interceptor;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import groovy.lang.MetaClassRegistry;
import java.beans.IntrospectionException;
import org.codehaus.groovy.runtime.InvokerHelper;

public class ProxyMetaClass
extends MetaClassImpl {
    protected MetaClass adaptee = null;
    protected Interceptor interceptor = null;

    public static ProxyMetaClass getInstance(Class theClass) throws IntrospectionException {
        MetaClassRegistry metaRegistry = InvokerHelper.getInstance().getMetaRegistry();
        MetaClass meta = metaRegistry.getMetaClass(theClass);
        return new ProxyMetaClass(metaRegistry, theClass, meta);
    }

    public ProxyMetaClass(MetaClassRegistry registry, Class theClass, MetaClass adaptee) throws IntrospectionException {
        super(registry, theClass);
        this.adaptee = adaptee;
        if (null == adaptee) {
            throw new IllegalArgumentException("adaptee must not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void use(Closure closure) {
        this.registry.setMetaClass(this.theClass, this);
        try {
            closure.call();
        }
        finally {
            this.registry.setMetaClass(this.theClass, this.adaptee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void use(GroovyObject object, Closure closure) {
        object.setMetaClass(this);
        try {
            closure.call();
        }
        finally {
            object.setMetaClass(this.adaptee);
        }
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public Object invokeMethod(final Object object, final String methodName, final Object[] arguments) {
        return this.doCall(object, methodName, arguments, this.interceptor, new Callable(){

            public Object call() {
                return ProxyMetaClass.this.adaptee.invokeMethod(object, methodName, arguments);
            }
        });
    }

    public Object invokeStaticMethod(final Object object, final String methodName, final Object[] arguments) {
        return this.doCall(object, methodName, arguments, this.interceptor, new Callable(){

            public Object call() {
                return ProxyMetaClass.this.adaptee.invokeStaticMethod(object, methodName, arguments);
            }
        });
    }

    public Object invokeConstructor(final Object[] arguments) {
        return this.doCall(this.theClass, "ctor", arguments, this.interceptor, new Callable(){

            public Object call() {
                return ProxyMetaClass.this.adaptee.invokeConstructor(arguments);
            }
        });
    }

    private Object doCall(Object object, String methodName, Object[] arguments, Interceptor interceptor, Callable howToInvoke) {
        if (null == interceptor) {
            return howToInvoke.call();
        }
        Object result = interceptor.beforeInvoke(object, methodName, arguments);
        if (interceptor.doInvoke()) {
            result = howToInvoke.call();
        }
        result = interceptor.afterInvoke(object, methodName, arguments, result);
        return result;
    }

    private static interface Callable {
        public Object call();
    }
}

