/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.threads;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.threads.IThreadPoolRunnable;

public class ThreadPool {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$utils$threads$ThreadPool == null ? (class$org$apache$jcs$utils$threads$ThreadPool = ThreadPool.class$("org.apache.jcs.utils.threads.ThreadPool")) : class$org$apache$jcs$utils$threads$ThreadPool));
    public static final int MAX_THREADS = 200;
    public static final int MAX_SPARE_THREADS = 50;
    public static final int MIN_SPARE_THREADS = 4;
    public static final int WORK_WAIT_TIMEOUT = 60000;
    protected Vector pool;
    protected MonitorRunnable monitor;
    protected int maxThreads = 200;
    protected int minSpareThreads = 4;
    protected int maxSpareThreads = 50;
    protected int currentThreadCount = 0;
    protected int currentThreadsBusy = 0;
    protected boolean stopThePool = false;
    static boolean logfull = true;
    static /* synthetic */ Class class$org$apache$jcs$utils$threads$ThreadPool;

    public synchronized void start() {
        this.stopThePool = false;
        this.currentThreadCount = 0;
        this.currentThreadsBusy = 0;
        this.maxThreads = 200;
        this.maxSpareThreads = 50;
        this.minSpareThreads = 4;
        this.adjustLimits();
        this.openThreads(this.minSpareThreads);
        this.monitor = new MonitorRunnable(this);
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    public int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    public void setMaxSpareThreads(int maxSpareThreads) {
        this.maxSpareThreads = maxSpareThreads;
    }

    public int getMaxSpareThreads() {
        return this.maxSpareThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runIt(IThreadPoolRunnable r) {
        if (null == r) {
            throw new NullPointerException();
        }
        if (0 == this.currentThreadCount || this.stopThePool) {
            throw new IllegalStateException();
        }
        ControlRunnable c = null;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.currentThreadsBusy == this.currentThreadCount) {
                if (this.currentThreadCount < this.maxThreads) {
                    int toOpen = this.currentThreadCount + this.minSpareThreads;
                    this.openThreads(toOpen);
                } else {
                    ThreadPool.logFull(log, this.currentThreadCount, this.maxThreads);
                    while (this.currentThreadsBusy == this.currentThreadCount) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            log.error((Object)"Unexpected exception", (Throwable)e);
                        }
                        if (0 != this.currentThreadCount && !this.stopThePool) continue;
                        throw new IllegalStateException();
                    }
                }
            }
            c = (ControlRunnable)this.pool.lastElement();
            this.pool.removeElement(c);
            ++this.currentThreadsBusy;
        }
        c.runIt(r);
    }

    public static void logFull(Log log, int currentThreadCount, int maxThreads) {
        if (logfull) {
            log.debug((Object)("All threads are busy, waiting. Please increase maxThreads or check the servlet status" + currentThreadCount + " " + maxThreads));
            logfull = false;
        }
    }

    public synchronized void shutdown() {
        if (!this.stopThePool) {
            this.stopThePool = true;
            this.monitor.terminate();
            this.monitor = null;
            for (int i = 0; i < this.currentThreadCount - this.currentThreadsBusy; ++i) {
                try {
                    ((ControlRunnable)this.pool.elementAt(i)).terminate();
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"Ignored exception while shutting down thread pool");
                }
            }
            this.currentThreadCount = 0;
            this.currentThreadsBusy = 0;
            this.pool = null;
            this.notifyAll();
        }
    }

    protected synchronized void checkSpareControllers() {
        if (this.stopThePool) {
            return;
        }
        if (this.currentThreadCount - this.currentThreadsBusy > this.maxSpareThreads) {
            int toFree = this.currentThreadCount - this.currentThreadsBusy - this.maxSpareThreads;
            for (int i = 0; i < toFree; ++i) {
                ControlRunnable c = (ControlRunnable)this.pool.firstElement();
                this.pool.removeElement(c);
                c.terminate();
                --this.currentThreadCount;
            }
        }
    }

    protected synchronized void returnController(ControlRunnable c) {
        if (0 == this.currentThreadCount || this.stopThePool) {
            c.terminate();
            return;
        }
        --this.currentThreadsBusy;
        this.pool.addElement(c);
        this.notify();
    }

    protected synchronized void notifyThreadEnd(ControlRunnable c) {
        --this.currentThreadsBusy;
        --this.currentThreadCount;
        this.notify();
    }

    protected void adjustLimits() {
        if (this.maxThreads <= 0) {
            this.maxThreads = 200;
        }
        if (this.maxSpareThreads >= this.maxThreads) {
            this.maxSpareThreads = this.maxThreads;
        }
        if (this.maxSpareThreads <= 0) {
            this.maxSpareThreads = 1 == this.maxThreads ? 1 : this.maxThreads / 2;
        }
        if (this.minSpareThreads > this.maxSpareThreads) {
            this.minSpareThreads = this.maxSpareThreads;
        }
        if (this.minSpareThreads <= 0) {
            this.minSpareThreads = 1 == this.maxSpareThreads ? 1 : this.maxSpareThreads / 2;
        }
    }

    protected void openThreads(int toOpen) {
        if (toOpen > this.maxThreads) {
            toOpen = this.maxThreads;
        }
        if (0 == this.currentThreadCount) {
            this.pool = new Vector(toOpen);
        }
        for (int i = this.currentThreadCount; i < toOpen; ++i) {
            this.pool.addElement(new ControlRunnable(this));
        }
        this.currentThreadCount = toOpen;
    }

    void log(String s) {
        log.debug((Object)s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ControlRunnable
    implements Runnable {
        ThreadPool p;
        Thread t;
        IThreadPoolRunnable toRun = null;
        boolean shouldTerminate = false;
        boolean shouldRun = false;
        boolean noThData;
        Object[] thData = null;

        ControlRunnable(ThreadPool p) {
            this.p = p;
            this.t = new Thread(this);
            this.t.start();
            this.noThData = true;
            this.thData = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: while (true) {
                try {
                    do {
                        Object var4_4;
                        ControlRunnable controlRunnable = this;
                        synchronized (controlRunnable) {
                            if (!this.shouldRun && !this.shouldTerminate) {
                                this.wait();
                            }
                        }
                        if (this.toRun == null) {
                            log.debug((Object)"No toRun ???");
                        }
                        if (this.shouldTerminate) {
                            log.debug((Object)"Terminate");
                            break block9;
                        }
                        try {
                            block16: {
                                try {
                                    if (this.noThData) {
                                        log.debug((Object)"Getting new thread data");
                                        this.thData = this.toRun.getInitData();
                                        this.noThData = false;
                                    }
                                    if (!this.shouldRun) break block16;
                                    this.toRun.runIt(this.thData);
                                }
                                catch (Throwable t) {
                                    log.error((Object)("Caught exception executing " + this.toRun.toString() + ", terminating thread"));
                                    this.shouldTerminate = true;
                                    this.shouldRun = false;
                                    this.p.notifyThreadEnd(this);
                                    var4_4 = null;
                                    if (!this.shouldRun) continue;
                                    this.shouldRun = false;
                                    this.p.returnController(this);
                                    continue;
                                }
                            }
                            var4_4 = null;
                            if (!this.shouldRun) continue;
                            this.shouldRun = false;
                            this.p.returnController(this);
                        }
                        catch (Throwable throwable) {
                            var4_4 = null;
                            if (this.shouldRun) {
                                this.shouldRun = false;
                                this.p.returnController(this);
                            }
                            throw throwable;
                        }
                    } while (!this.shouldTerminate);
                }
                catch (InterruptedException ie) {
                    log.error((Object)"Unexpected exception", (Throwable)ie);
                    continue;
                }
                break;
            }
        }

        public synchronized void runIt(IThreadPoolRunnable toRun) {
            if (toRun == null) {
                throw new NullPointerException("No Runnable");
            }
            this.toRun = toRun;
            this.shouldRun = true;
            this.notify();
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }
    }

    class MonitorRunnable
    implements Runnable {
        ThreadPool p;
        Thread t;
        boolean shouldTerminate = false;

        MonitorRunnable(ThreadPool p) {
            this.p = p;
            this.t = new Thread(this);
            this.t.setName("MonitorRunnable");
            this.t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block5: while (true) {
                try {
                    while (true) {
                        MonitorRunnable monitorRunnable = this;
                        synchronized (monitorRunnable) {
                            this.wait(60000L);
                        }
                        if (this.shouldTerminate) break block5;
                        this.p.checkSpareControllers();
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Unexpected exception");
                    continue;
                }
                break;
            }
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }
    }
}

