/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.transform.XmlToAppData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.texen.ant.TexenTask;

public class TorqueDataModelTask
extends TexenTask {
    protected String xmlFile;
    protected List filesets = new ArrayList();
    protected List dataModels = new ArrayList();
    protected Context context;
    protected Hashtable dataModelDbMap;
    protected Hashtable databaseNames;
    protected String sqldbmap;
    private String targetDatabase;
    private String targetPackage;

    public void setSqlDbMap(String sqldbmap) {
        this.sqldbmap = this.project.resolveFile(sqldbmap).toString();
    }

    public String getSqlDbMap() {
        return this.sqldbmap;
    }

    public List getDataModels() {
        return this.dataModels;
    }

    public Hashtable getDataModelDbMap() {
        return this.dataModelDbMap;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String xmlFile) {
        this.xmlFile = this.project.resolveFile(xmlFile).toString();
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    public void setTargetDatabase(String v) {
        this.targetDatabase = v;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public void setTargetPackage(String v) {
        this.targetPackage = v;
    }

    public Context initControlContext() throws Exception {
        if (this.xmlFile == null && this.filesets.isEmpty()) {
            throw new BuildException("You must specify an XML schema or fileset of XML schemas!");
        }
        try {
            XmlToAppData xmlParser;
            if (this.xmlFile != null) {
                xmlParser = new XmlToAppData(this.getTargetDatabase(), this.getTargetPackage());
                Database ad = xmlParser.parseFile(this.xmlFile);
                ad.setFileName(this.grokName(this.xmlFile));
                this.dataModels.add(ad);
            } else {
                for (int i = 0; i < this.filesets.size(); ++i) {
                    FileSet fs = (FileSet)this.filesets.get(i);
                    DirectoryScanner ds = fs.getDirectoryScanner(this.project);
                    File srcDir = fs.getDir(this.project);
                    String[] dataModelFiles = ds.getIncludedFiles();
                    for (int j = 0; j < dataModelFiles.length; ++j) {
                        File f = new File(srcDir, dataModelFiles[j]);
                        xmlParser = new XmlToAppData(this.getTargetDatabase(), this.getTargetPackage());
                        Database ad = xmlParser.parseFile(f.toString());
                        ad.setFileName(this.grokName(f.toString()));
                        this.dataModels.add(ad);
                    }
                }
            }
            Iterator i = this.dataModels.iterator();
            this.databaseNames = new Hashtable();
            this.dataModelDbMap = new Hashtable();
            while (i.hasNext()) {
                Database database = (Database)i.next();
                this.databaseNames.put(database.getName(), database.getName());
                this.dataModelDbMap.put(database.getFileName(), database.getName());
            }
        }
        catch (EngineException ee) {
            throw new BuildException((Throwable)((Object)ee));
        }
        this.context = new VelocityContext();
        this.context.put("dataModels", (Object)this.dataModels);
        this.context.put("databaseNames", (Object)this.databaseNames);
        this.context.put("targetDatabase", (Object)this.targetDatabase);
        this.context.put("targetPackage", (Object)this.targetPackage);
        return this.context;
    }

    private String grokName(String xmlFile) {
        String name = "data-model";
        int i = xmlFile.lastIndexOf(System.getProperty("file.separator"));
        if (i != -1) {
            int j = xmlFile.lastIndexOf(46);
            name = ++i < j ? xmlFile.substring(i, j) : xmlFile.substring(i);
        }
        return name;
    }

    public void setContextProperties(String file) {
        super.setContextProperties(file);
        Hashtable env = super.getProject().getProperties();
        Iterator i = env.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith("torque.")) continue;
            String newKey = key.substring("torque.".length());
            int j = newKey.indexOf(".");
            while (j != -1) {
                newKey = newKey.substring(0, j) + StringUtils.capitalize((String)newKey.substring(j + 1));
                j = newKey.indexOf(".");
            }
            this.contextProperties.setProperty(newKey, env.get(key));
        }
    }
}

