/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.torque.task.TorqueDataModelTask;
import org.apache.velocity.anakia.Escape;
import org.apache.velocity.context.Context;

public class TorqueDataDumpTask
extends TorqueDataModelTask {
    private String databaseName;
    private String databaseUrl;
    private String databaseDriver;
    private String databaseUser;
    private String databasePassword;
    private Connection conn;
    private Statement stmt;

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String v) {
        this.databaseName = v;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public void setDatabaseUrl(String v) {
        this.databaseUrl = v;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseDriver(String v) {
        this.databaseDriver = v;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String v) {
        this.databaseUser = v;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String v) {
        this.databasePassword = v;
    }

    public Context initControlContext() throws Exception {
        super.initControlContext();
        this.context.put("dataset", (Object)"all");
        this.log("Torque - TorqueDataDump starting");
        this.log("Your DB settings are:");
        this.log("driver: " + this.databaseDriver);
        this.log("URL: " + this.databaseUrl);
        this.log("user: " + this.databaseUser);
        try {
            Class.forName(this.databaseDriver);
            this.log("DB driver instantiated sucessfully", 4);
            this.conn = DriverManager.getConnection(this.databaseUrl, this.databaseUser, this.databasePassword);
            this.stmt = this.conn.createStatement(1004, 1008);
            this.log("DB connection established", 4);
            this.context.put("tableTool", (Object)new TableTool());
        }
        catch (SQLException se) {
            System.err.println("SQLException while connecting to DB:");
            se.printStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("cannot load driver:");
            cnfe.printStackTrace();
        }
        this.context.put("escape", (Object)new Escape());
        return this.context;
    }

    protected void cleanup() throws Exception {
        if (this.stmt != null) {
            this.stmt.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public class TableTool
    implements Iterator {
        private ResultSet rs;

        public TableTool() {
        }

        protected TableTool(ResultSet rs) throws Exception {
            this.rs = rs;
        }

        public TableTool fetch(String tableName) throws Exception {
            TorqueDataDumpTask.this.log("Fetching data for table " + tableName, 2);
            return new TableTool(TorqueDataDumpTask.this.stmt.executeQuery("SELECT * FROM " + tableName));
        }

        public boolean hasNext() {
            try {
                boolean validRow = this.rs.next();
                this.rs.previous();
                return validRow;
            }
            catch (Exception se) {
                System.err.println("Exception :");
                se.printStackTrace();
                return false;
            }
        }

        public Object next() throws NoSuchElementException {
            try {
                System.out.print(".");
                this.rs.next();
            }
            catch (Exception se) {
                System.err.println("Exception while iterating:");
                se.printStackTrace();
                throw new NoSuchElementException(se.getMessage());
            }
            return this;
        }

        public String get(String columnName) {
            try {
                return this.rs.getString(columnName);
            }
            catch (Exception se) {
                TorqueDataDumpTask.this.log("Exception fetching value " + columnName + ": " + se.getMessage(), 0);
                return null;
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

