/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BatchUpdateException;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.CrossConverters;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.MaterialPreparedStatement;
import org.apache.derby.client.am.ParameterMetaData;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.QueryTimerTask;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Statement;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement,
PreparedStatementCallbackInterface {
    public MaterialPreparedStatement materialPreparedStatement_ = null;
    public String sql_;
    public boolean outputRegistered_ = false;
    public Object[] parameters_;
    boolean[] parameterSet_;
    boolean[] parameterRegistered_;
    public ColumnMetaData parameterMetaData_;
    String positionedUpdateCursorName_ = null;
    boolean listenToUnitOfWork_ = false;

    void setInput(int n, Object object) {
        this.parameters_[n - 1] = object;
        this.parameterSet_[n - 1] = true;
    }

    private void initPreparedStatement() {
        this.materialPreparedStatement_ = null;
        this.sql_ = null;
        this.outputRegistered_ = false;
        this.parameters_ = null;
        this.parameterSet_ = null;
        this.parameterRegistered_ = null;
        this.parameterMetaData_ = null;
        this.isAutoCommittableStatement_ = true;
        this.isPreparedStatement_ = true;
    }

    protected void initResetPreparedStatement() {
        this.outputRegistered_ = false;
        this.isPreparedStatement_ = true;
        if (this.parameterMetaData_ != null) {
            this.resetParameters();
        }
    }

    public void reset(boolean bl) throws SqlException {
        if (bl) {
            this.connection_.resetPrepareStatement(this);
        } else {
            super.initResetPreparedStatement();
            this.initResetPreparedStatement();
        }
    }

    private void resetParameters() {
        for (int i = 0; i < this.parameterMetaData_.columns_; ++i) {
            this.parameters_[i] = null;
            this.parameterSet_[i] = false;
            this.parameterRegistered_[i] = false;
        }
    }

    public PreparedStatement(Agent agent, Connection connection, String string, Section section) throws SqlException {
        super(agent, connection);
        this.initPreparedStatement(string, section);
    }

    public void resetPreparedStatement(Agent agent, Connection connection, String string, Section section) throws SqlException {
        super.resetStatement(agent, connection);
        this.initPreparedStatement();
        this.initPreparedStatement(string, section);
    }

    private void initPreparedStatement(String string, Section section) throws SqlException {
        this.sql_ = string;
        this.isPreparedStatement_ = true;
        this.parseSqlAndSetSqlModes(this.sql_);
        this.section_ = section;
    }

    public PreparedStatement(Agent agent, Connection connection, String string, int n, int n2, int n3, int n4, String[] stringArray) throws SqlException {
        super(agent, connection, n, n2, n3, n4, stringArray);
        this.initPreparedStatement(string);
    }

    public void resetPreparedStatement(Agent agent, Connection connection, String string, int n, int n2, int n3, int n4, String[] stringArray) throws SqlException {
        super.resetStatement(agent, connection, n, n2, n3, n4, stringArray);
        this.initPreparedStatement();
        this.initPreparedStatement(string);
    }

    private void initPreparedStatement(String string) throws SqlException {
        String[] stringArray;
        this.sql_ = super.escape(string);
        this.parseSqlAndSetSqlModes(this.sql_);
        this.isPreparedStatement_ = true;
        String string2 = null;
        if ((this.sqlUpdateMode_ == 64 || this.sqlUpdateMode_ == 128) && (stringArray = this.extractCursorNameFromWhereCurrentOf(this.sql_)) != null) {
            string2 = stringArray[0];
            this.sql_ = stringArray[1];
        }
        if (string2 != null) {
            this.positionedUpdateCursorName_ = string2;
            this.section_ = this.agent_.sectionManager_.getPositionedUpdateSection(string2, false);
            if (this.section_ == null) {
                throw new SqlException(this.agent_.logWriter_, "Invalid cursor name \"" + string2 + "\" in the Update/Delete statement.");
            }
            if (this.section_.getClientCursorName() != null && string2.compareTo(this.section_.getClientCursorName()) == 0) {
                this.sql_ = this.substituteClientCursorNameWithServerCursorName(this.sql_, this.section_);
            }
        } else {
            this.section_ = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
        }
    }

    public void resetPreparedStatement(Agent agent, Connection connection, String string, Section section, ColumnMetaData columnMetaData, ColumnMetaData columnMetaData2) throws SqlException {
        this.resetPreparedStatement(agent, connection, string, section);
        this.initPreparedStatement(columnMetaData, columnMetaData2);
    }

    private void initPreparedStatement(ColumnMetaData columnMetaData, ColumnMetaData columnMetaData2) throws SqlException {
        this.isPreparedStatement_ = true;
        this.parameterMetaData_ = columnMetaData;
        this.resultSetMetaData_ = columnMetaData2;
        if (this.parameterMetaData_ != null) {
            this.parameters_ = new Object[this.parameterMetaData_.columns_];
            this.parameterSet_ = new boolean[this.parameterMetaData_.columns_];
            this.parameterRegistered_ = new boolean[this.parameterMetaData_.columns_];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize");
        }
        if (this.openOnClient_) {
            Connection connection = this.connection_;
            synchronized (connection) {
                this.closeX();
            }
        }
        super.finalize();
    }

    void prepare() throws SqlException {
        try {
            if (this.sqlUpdateMode_ == 32 && this.generatedKeysColumnNames_ != null) {
                this.flowPrepareForSelectFromInsert();
            } else {
                this.flowPrepareDescribeInputOutput();
            }
        }
        catch (SqlException sqlException) {
            this.markClosed();
            throw sqlException;
        }
    }

    public boolean execute(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", string);
        }
        throw new SqlException(this.agent_.logWriter_, "The method java.sql.Statement.execute (String sql) cannot be called on a  prepared statement instance. Use java.sql.PreparedStatement.execute () with no sql string argument.");
    }

    public java.sql.ResultSet executeQuery(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeQuery", string);
        }
        throw new SqlException(this.agent_.logWriter_, "The method java.sql.Statement.executeQuery (String sql) cannot be called on a  prepared statement instance. Use java.sql.PreparedStatement.executeQuery () with no sql string argument.");
    }

    public int executeUpdate(String string) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", string);
        }
        throw new SqlException(this.agent_.logWriter_, "The method java.sql.Statement.executeUpdate (String sql) cannot be called on a  prepared statement instance. Use java.sql.PreparedStatement.executeUpdate () with no sql string argument.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet executeQuery() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "executeQuery");
            }
            ResultSet resultSet = this.executeQueryX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "executeQuery", resultSet);
            }
            return resultSet;
        }
    }

    ResultSet executeQueryX() throws SqlException {
        this.flowExecute(1);
        super.checkExecuteQueryPostConditions("java.sql.PreparedStatement");
        return this.resultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "executeUpdate");
            }
            int n = this.executeUpdateX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", n);
            }
            return n;
        }
    }

    int executeUpdateX() throws SqlException {
        this.flowExecute(2);
        if (this.sqlMode_ == 4) {
            super.checkExecuteUpdatePostConditions("java.sql.PreparedStatement");
        }
        return this.updateCount_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int n, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setNull", n, n2);
            }
            this.setNullX(n, n2);
        }
    }

    void setNullX(int n, int n2) throws SqlException {
        super.checkForClosedStatement();
        n = this.checkSetterPreconditions(n);
        this.parameterMetaData_.clientParamtertype_[n - 1] = n2;
        if (!this.parameterMetaData_.nullable_[n - 1]) {
            throw new SqlException(this.agent_.logWriter_, "PreparedStatement: setNull method setting a non-nullable input parameter " + n + " to null.");
        }
        this.setInput(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull(int n, int n2, String string) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setNull", n, n2, (Object)string);
            }
            super.checkForClosedStatement();
            this.setNull(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoolean(int n, boolean bl) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBoolean", n, bl);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = -7;
            this.setInput(n, new Short((short)(bl ? 1 : 0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByte(int n, byte by) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setByte", n, by);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = -6;
            this.setInput(n, new Short(by));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShort(int n, short s) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setShort", n, s);
            }
            this.setShortX(n, s);
        }
    }

    void setShortX(int n, short s) throws SqlException {
        n = this.checkSetterPreconditions(n);
        this.parameterMetaData_.clientParamtertype_[n - 1] = 5;
        this.setInput(n, new Short(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInt(int n, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setInt", n, n2);
            }
            this.setIntX(n, n2);
        }
    }

    void setIntX(int n, int n2) throws SqlException {
        n = this.checkSetterPreconditions(n);
        this.parameterMetaData_.clientParamtertype_[n - 1] = 4;
        this.setInput(n, new Integer(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLong(int n, long l) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setLong", n, l);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = -5;
            this.setInput(n, new Long(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFloat(int n, float f) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setFloat", n, f);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = 7;
            this.setInput(n, new Float(f));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDouble(int n, double d) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setDouble", n, d);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = 8;
            this.setInput(n, new Double(d));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBigDecimal", n, (Object)bigDecimal);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = 3;
            if (bigDecimal == null) {
                this.setNull(n, 3);
                return;
            }
            boolean bl = false;
            this.setInput(n, bigDecimal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int n, Date date) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setDate", n, (Object)date);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = 91;
            if (date == null) {
                this.setNull(n, 91);
                return;
            }
            this.setInput(n, date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDate(int n, Date date, Calendar calendar) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setDate", n, (Object)date, (Object)calendar);
            }
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, "Invalid parameter: calendar is null");
            }
            Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.setTime(date);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.clear();
            calendar3.setTime(date);
            long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
            Date date2 = l == 0L || date == null ? date : new Date(date.getTime() + l);
            this.setDate(n, date2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(int n, Time time) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setTime", n, (Object)time);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = 92;
            if (time == null) {
                this.setNull(n, 92);
                return;
            }
            this.setInput(n, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTime(int n, Time time, Calendar calendar) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setTime", n, (Object)time, (Object)calendar);
            }
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, "Invalid parameter: calendar is null");
            }
            Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.setTime(time);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.clear();
            calendar3.setTime(time);
            long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
            Time time2 = l == 0L || time == null ? time : new Time(time.getTime() + l);
            this.setTime(n, time2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int n, Timestamp timestamp) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", n, (Object)timestamp);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = 93;
            if (timestamp == null) {
                this.setNull(n, 93);
                return;
            }
            this.setInput(n, timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            Timestamp timestamp2;
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", n, (Object)timestamp, (Object)calendar);
            }
            if (calendar == null) {
                throw new SqlException(this.agent_.logWriter_, "Invalid parameter: calendar is null");
            }
            Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.setTime(timestamp);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.clear();
            calendar3.setTime(timestamp);
            long l = calendar2.get(15) - calendar3.get(15) + calendar2.get(16) - calendar3.get(16);
            Timestamp timestamp3 = timestamp2 = l == 0L || timestamp == null ? timestamp : new Timestamp(timestamp.getTime() + l);
            if (timestamp != null) {
                timestamp2.setNanos(timestamp.getNanos());
            }
            this.setTimestamp(n, timestamp2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int n, String string) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setString", n, (Object)string);
            }
            this.setStringX(n, string);
        }
    }

    void setStringX(int n, String string) throws SqlException {
        n = this.checkSetterPreconditions(n);
        this.parameterMetaData_.clientParamtertype_[n - 1] = -1;
        if (string == null) {
            this.setNull(n, -1);
            return;
        }
        this.setInput(n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(int n, byte[] byArray) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBytes", n, byArray);
            }
            this.setBytesX(n, byArray);
        }
    }

    public void setBytesX(int n, byte[] byArray) throws SqlException {
        n = this.checkSetterPreconditions(n);
        this.parameterMetaData_.clientParamtertype_[n - 1] = -4;
        if (byArray == null) {
            this.setNull(n, -4);
            return;
        }
        this.setInput(n, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBinaryStream", n, (Object)"<input stream>", n2);
            }
            this.setBinaryStreamX(n, inputStream, n2);
        }
    }

    public void setBinaryStreamX(int n, InputStream inputStream, int n2) throws SqlException {
        n = this.checkSetterPreconditions(n);
        this.parameterMetaData_.clientParamtertype_[n - 1] = 2004;
        if (inputStream == null) {
            this.setNull(n, 2004);
            return;
        }
        this.setInput(n, new Blob(this.agent_, inputStream, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setAsciiStream", n, (Object)"<input stream>", n2);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = 2005;
            if (inputStream == null) {
                this.setNull(n, 2005);
                return;
            }
            this.setInput(n, new Clob(this.agent_, inputStream, "US-ASCII", n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceDeprecatedEntry(this, "setUnicodeStream", n, "<input stream>", n2);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = 2005;
            if (inputStream == null) {
                this.setNull(n, 2005);
                return;
            }
            this.setInput(n, new Clob(this.agent_, inputStream, "UnicodeBigUnmarked", n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setCharacterStream", n, (Object)reader, n2);
            }
            n = this.checkSetterPreconditions(n);
            this.parameterMetaData_.clientParamtertype_[n - 1] = 2005;
            if (reader == null) {
                this.setNull(n, 2005);
                return;
            }
            this.setInput(n, new Clob(this.agent_, reader, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n, java.sql.Blob blob) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setBlob", n, (Object)blob);
            }
            this.setBlobX(n, blob);
        }
    }

    public void setBlobX(int n, java.sql.Blob blob) throws SqlException {
        n = this.checkSetterPreconditions(n);
        this.parameterMetaData_.clientParamtertype_[n - 1] = 2004;
        if (blob == null) {
            this.setNull(n, 2004);
            return;
        }
        this.setInput(n, blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n, java.sql.Clob clob) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setClob", n, (Object)clob);
            }
            this.setClobX(n, clob);
        }
    }

    void setClobX(int n, java.sql.Clob clob) throws SqlException {
        n = this.checkSetterPreconditions(n);
        this.parameterMetaData_.clientParamtertype_[n - 1] = 2005;
        if (clob == null) {
            this.setNullX(n, 2005);
            return;
        }
        this.setInput(n, clob);
    }

    public void setArray(int n, Array array) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setArray", n, (Object)array);
            }
            n = this.checkSetterPreconditions(n);
            throw new SqlException(this.agent_.logWriter_, "jdbc 2 method not yet implemented");
        }
    }

    public void setRef(int n, Ref ref) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setRef", n, (Object)ref);
            }
            n = this.checkSetterPreconditions(n);
            throw new SqlException(this.agent_.logWriter_, "jdbc 2 method not yet implemented");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setObject", n, object);
            }
            super.checkForClosedStatement();
            if (object instanceof String) {
                this.setString(n, (String)object);
            } else if (object instanceof Integer) {
                this.setInt(n, (Integer)object);
            } else if (object instanceof Double) {
                this.setDouble(n, (Double)object);
            } else if (object instanceof Float) {
                this.setFloat(n, ((Float)object).floatValue());
            } else if (object instanceof Boolean) {
                this.setBoolean(n, (Boolean)object);
            } else if (object instanceof Long) {
                this.setLong(n, (Long)object);
            } else if (object instanceof byte[]) {
                this.setBytes(n, (byte[])object);
            } else if (object instanceof BigDecimal) {
                this.setBigDecimal(n, (BigDecimal)object);
            } else if (object instanceof Date) {
                this.setDate(n, (Date)object);
            } else if (object instanceof Time) {
                this.setTime(n, (Time)object);
            } else if (object instanceof Timestamp) {
                this.setTimestamp(n, (Timestamp)object);
            } else if (object instanceof java.sql.Blob) {
                this.setBlob(n, (java.sql.Blob)object);
            } else if (object instanceof java.sql.Clob) {
                this.setClob(n, (java.sql.Clob)object);
            } else if (object instanceof Array) {
                this.setArray(n, (Array)object);
            } else if (object instanceof Ref) {
                this.setRef(n, (Ref)object);
            } else if (object instanceof Short) {
                this.setShort(n, (Short)object);
            } else if (object instanceof Byte) {
                this.setByte(n, (Byte)object);
            } else {
                this.checkSetterPreconditions(n);
                throw new SqlException(this.agent_.logWriter_, "Invalid data conversion: Parameter object type is invalid for requested conversion.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object, int n2) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setObject", n, object, n2);
            }
            this.setObjectX(n, object, n2, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object, int n2, int n3) throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "setObject", n, object, n2, n3);
            }
            this.setObjectX(n, object, n2, n3);
        }
    }

    private void setObjectX(int n, Object object, int n2, int n3) throws SqlException {
        int n4;
        n = this.checkSetterPreconditions(n);
        this.checkForValidScale(n3);
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        this.parameterMetaData_.clientParamtertype_[n - 1] = n4 = CrossConverters.getInputJdbcType(n2);
        object = this.agent_.crossConverters_.setObject(n4, object);
        try {
            if (n2 == 3 || n2 == 2) {
                object = ((BigDecimal)object).setScale(n3, 1);
            }
        }
        catch (ArithmeticException arithmeticException) {
            throw new SqlException(this.agent_.logWriter_, arithmeticException.getMessage());
        }
        this.setObject(n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearParameters");
            }
            this.checkForClosedStatement();
            if (this.parameterMetaData_ != null) {
                int n;
                for (n = 0; n < this.parameters_.length; ++n) {
                    this.parameters_[n] = null;
                }
                for (n = 0; n < this.parameterSet_.length; ++n) {
                    this.parameterSet_[n] = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "execute");
            }
            boolean bl = this.executeX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "execute", bl);
            }
            return bl;
        }
    }

    private boolean executeX() throws SqlException {
        this.flowExecute(3);
        return this.resultSet_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "addBatch");
            }
            this.checkForClosedStatement();
            this.checkThatAllParametersAreSet();
            if (this.parameterMetaData_ != null) {
                Object[] objectArray = new Object[this.parameters_.length];
                System.arraycopy(this.parameters_, 0, objectArray, 0, this.parameters_.length);
                this.batch_.add(objectArray);
            } else {
                this.batch_.add(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SqlException, BatchUpdateException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "executeBatch");
            }
            int[] nArray = null;
            nArray = this.executeBatchX(false);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "executeBatch", nArray);
            }
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getMetaData");
            }
            ColumnMetaData columnMetaData = this.getMetaDataX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getMetaData", columnMetaData);
            }
            return columnMetaData;
        }
    }

    private ColumnMetaData getMetaDataX() throws SqlException {
        super.checkForClosedStatement();
        return this.resultSetMetaData_;
    }

    public boolean execute(String string, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)string, n);
        }
        throw new SqlException(this.agent_.logWriter_, "The method java.sql.Statement.execute (String sql, int autoGeneratedKeys) cannot be called on a  prepared statement instance. Use java.sql.PreparedStatement.execute () with no arguments.");
    }

    public boolean execute(String string, String[] stringArray) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)string, (Object)stringArray);
        }
        throw new SqlException(this.agent_.logWriter_, "The method java.sql.Statement.execute (String sql, String[] columnNames) cannot be called on a  prepared statement instance. Use java.sql.PreparedStatement.execute () with no arguments.");
    }

    public boolean execute(String string, int[] nArray) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)string, (Object)nArray);
        }
        throw new SqlException(this.agent_.logWriter_, "The method java.sql.Statement.execute (String sql, int[] columnIndexes) cannot be called on a  prepared statement instance. Use java.sql.PreparedStatement.execute () with no arguments.");
    }

    public int executeUpdate(String string, int n) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", n);
        }
        throw new SqlException(this.agent_.logWriter_, "The method java.sql.Statement.executeUpdate (String sql, int autoGeneratedKeys) cannot be called on a  prepared statement instance. Use java.sql.PreparedStatement.executeUpdate () with no arguments.");
    }

    public int executeUpdate(String string, String[] stringArray) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", stringArray);
        }
        throw new SqlException(this.agent_.logWriter_, "The method java.sql.Statement.executeUpdate (String sql, String[] columnNames) cannot be called on a  prepared statement instance. Use java.sql.PreparedStatement.executeUpdate () with no arguments.");
    }

    public int executeUpdate(String string, int[] nArray) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", nArray);
        }
        throw new SqlException(this.agent_.logWriter_, "The method java.sql.Statement.executeUpdate (String sql, int[] columnIndexes) cannot be called on a  prepared statement instance. Use java.sql.PreparedStatement.executeUpdate () with no arguments.");
    }

    public void setURL(int n, URL uRL) throws SqlException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setURL", n, (Object)uRL);
        }
        throw new SqlException(this.agent_.logWriter_, "JDBC 3 method called - not yet supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ParameterMetaData getParameterMetaData() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getParameterMetaData");
            }
            ParameterMetaData parameterMetaData = this.getParameterMetaDataX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getParameterMetaData", parameterMetaData);
            }
            return parameterMetaData;
        }
    }

    private ParameterMetaData getParameterMetaDataX() throws SqlException {
        super.checkForClosedStatement();
        ParameterMetaData parameterMetaData = new ParameterMetaData(this.parameterMetaData_ != null ? this.parameterMetaData_ : new ColumnMetaData(this.agent_.logWriter_, 0));
        if (this.escapedProcedureCallWithResult_) {
            parameterMetaData.escapedProcedureCallWithResult_ = true;
        }
        return parameterMetaData;
    }

    public void writeExecute(Section section, ColumnMetaData columnMetaData, Object[] objectArray, int n, boolean bl, boolean bl2) throws SqlException {
        this.materialPreparedStatement_.writeExecute_(section, columnMetaData, objectArray, n, bl, bl2);
    }

    public void readExecute() throws SqlException {
        this.materialPreparedStatement_.readExecute_();
    }

    public void writeOpenQuery(Section section, int n, int n2, int n3, ColumnMetaData columnMetaData, Object[] objectArray) throws SqlException {
        this.materialPreparedStatement_.writeOpenQuery_(section, n, n2, n3, columnMetaData, objectArray);
    }

    public void writeDescribeInput(Section section) throws SqlException {
        this.materialPreparedStatement_.writeDescribeInput_(section);
    }

    public void readDescribeInput() throws SqlException {
        this.materialPreparedStatement_.readDescribeInput_();
    }

    public void completeDescribeInput(ColumnMetaData columnMetaData, Sqlca sqlca) {
        int n = super.completeSqlca(sqlca);
        if (n < 0) {
            return;
        }
        this.parameterMetaData_ = columnMetaData;
        if (this.sqlMode_ != 2 && this.parameterMetaData_ != null) {
            for (int i = 0; i < this.parameterMetaData_.columns_; ++i) {
                this.parameterMetaData_.sqlxParmmode_[i] = 1;
            }
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceParameterMetaData(this, this.parameterMetaData_);
        }
    }

    public void writeDescribeOutput(Section section) throws SqlException {
        this.materialPreparedStatement_.writeDescribeOutput_(section);
    }

    public void readDescribeOutput() throws SqlException {
        this.materialPreparedStatement_.readDescribeOutput_();
    }

    public void completeDescribeOutput(ColumnMetaData columnMetaData, Sqlca sqlca) {
        int n = super.completeSqlca(sqlca);
        if (n < 0) {
            return;
        }
        this.resultSetMetaData_ = columnMetaData;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceResultSetMetaData(this, columnMetaData);
        }
    }

    void writePrepareDescribeInputOutput() throws SqlException {
        this.writePrepareDescribeOutput(this.sql_, this.section_);
        this.writeDescribeInput(this.section_);
    }

    void readPrepareDescribeInputOutput() throws SqlException {
        this.readPrepareDescribeOutput();
        this.readDescribeInput();
        this.completePrepareDescribe();
    }

    void writePrepareDescribeInput() throws SqlException {
        this.writePrepare(this.sql_, this.section_);
        this.writeDescribeInput(this.section_);
    }

    void readPrepareDescribeInput() throws SqlException {
        this.readPrepare();
        this.readDescribeInput();
        this.completePrepareDescribe();
    }

    void completePrepareDescribe() {
        if (this.parameterMetaData_ == null) {
            return;
        }
        this.parameters_ = this.expandObjectArray(this.parameters_, this.parameterMetaData_.columns_);
        this.parameterSet_ = this.expandBooleanArray(this.parameterSet_, this.parameterMetaData_.columns_);
        this.parameterRegistered_ = this.expandBooleanArray(this.parameterRegistered_, this.parameterMetaData_.columns_);
    }

    private Object[] expandObjectArray(Object[] objectArray, int n) {
        if (objectArray == null) {
            Object[] objectArray2 = new Object[n];
            return objectArray2;
        }
        if (objectArray.length < n) {
            Object[] objectArray3 = new Object[n];
            System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
            return objectArray3;
        }
        return objectArray;
    }

    private boolean[] expandBooleanArray(boolean[] blArray, int n) {
        if (blArray == null) {
            boolean[] blArray2 = new boolean[n];
            return blArray2;
        }
        if (blArray.length < n) {
            boolean[] blArray3 = new boolean[n];
            System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
            return blArray3;
        }
        return blArray;
    }

    void flowPrepareForSelectFromInsert() throws SqlException {
        this.agent_.beginWriteChain(this);
        this.writePrepareDescribeInputOutput(this.constructSelectFromInsertSQL(this.sql_), this.section_);
        this.agent_.flow(this);
        this.readPrepareDescribeInputOutput();
        this.agent_.endReadChain();
    }

    void writePrepareDescribeInputOutput(String string, Section section) throws SqlException {
        this.writePrepareDescribeOutput(string, section);
        this.writeDescribeInput(section);
    }

    void flowPrepareDescribeInputOutput() throws SqlException {
        this.agent_.beginWriteChain(this);
        if (this.sqlMode_ == 2) {
            this.writePrepareDescribeInput();
            this.agent_.flow(this);
            this.readPrepareDescribeInput();
            this.agent_.endReadChain();
        } else {
            this.writePrepareDescribeInputOutput();
            this.agent_.flow(this);
            this.readPrepareDescribeInputOutput();
            this.agent_.endReadChain();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flowExecute(int n) throws SqlException {
        block35: {
            super.checkForClosedStatement();
            super.clearWarningsX();
            super.checkForAppropriateSqlMode(n, this.sqlMode_);
            this.checkThatAllParametersAreSet();
            this.updateCount_ = this.sqlMode_ == 4 ? 0 : -1;
            Timer timer = null;
            QueryTimerTask queryTimerTask = null;
            if (this.timeout_ != 0) {
                timer = new Timer();
                queryTimerTask = new QueryTimerTask(this, timer);
                timer.schedule((TimerTask)queryTimerTask, 1000 * this.timeout_);
            }
            try {
                this.agent_.beginWriteChain(this);
                boolean bl = super.writeCloseResultSets(true);
                int n2 = this.parameterMetaData_ != null ? this.parameterMetaData_.getColumnCount() : 0;
                boolean bl2 = this.resultSetMetaData_ != null && this.resultSetMetaData_.getColumnCount() > 0;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                ResultSet resultSet = null;
                switch (this.sqlMode_) {
                    case 4: {
                        if (this.positionedUpdateCursorName_ != null) {
                            resultSet = this.agent_.sectionManager_.getPositionedUpdateResultSet(this.positionedUpdateCursorName_);
                        }
                        if (resultSet != null && !resultSet.isRowsetCursor_ && !(bl5 = resultSet.repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete())) {
                            resultSet = null;
                        }
                        boolean bl6 = bl3 = this.connection_.willAutoCommitGenerateFlow() && this.isAutoCommittableStatement_;
                        if (this.sqlUpdateMode_ == 32 && this.generatedKeysColumnNames_ != null) {
                            this.writeOpenQuery(this.section_, this.fetchSize_, this.resultSetType_, n2, this.parameterMetaData_, this.parameters_);
                        } else {
                            boolean bl7 = this.sqlUpdateMode_ == 32 && this.autoGeneratedKeys_ == 1;
                            this.writeExecute(this.section_, this.parameterMetaData_, this.parameters_, n2, bl2, bl3 || bl7);
                            if (bl7) {
                                this.prepareAutoGeneratedKeysStatement();
                                this.writeOpenQuery(this.preparedStatementForAutoGeneratedKeys_.section_, this.preparedStatementForAutoGeneratedKeys_.fetchSize_, this.preparedStatementForAutoGeneratedKeys_.resultSetType_);
                            }
                        }
                        if (!bl3) break;
                        if (this.agent_.accumulatedReadExceptions_ != null) {
                            this.connection_.writeCommitSubstitute_();
                            bl4 = true;
                            break;
                        }
                        this.connection_.writeCommit();
                        break;
                    }
                    case 1: {
                        this.writeOpenQuery(this.section_, this.fetchSize_, this.resultSetType_, n2, this.parameterMetaData_, this.parameters_);
                        break;
                    }
                    case 2: {
                        this.writeExecuteCall(this.outputRegistered_, null, this.section_, this.fetchSize_, false, this.resultSetType_, this.parameterMetaData_, this.parameters_);
                    }
                }
                this.agent_.flow(this);
                super.readCloseResultSets(true);
                if (bl) {
                    this.connection_.completeTransactionStart();
                }
                super.markResultSetsClosed();
                switch (this.sqlMode_) {
                    case 4: {
                        if (resultSet != null && !resultSet.isRowsetCursor_) {
                            resultSet.readPositioningFetch_();
                        }
                        if (this.sqlUpdateMode_ == 32 && this.generatedKeysColumnNames_ != null) {
                            this.readOpenQuery();
                            if (this.resultSet_ != null) {
                                this.generatedKeysResultSet_ = this.resultSet_;
                                this.resultSet_ = null;
                                this.updateCount_ = 1;
                            }
                        } else {
                            this.readExecute();
                            if (this.sqlUpdateMode_ == 32 && this.autoGeneratedKeys_ == 1) {
                                this.readPrepareAutoGeneratedKeysStatement();
                                this.preparedStatementForAutoGeneratedKeys_.readOpenQuery();
                                this.generatedKeysResultSet_ = this.preparedStatementForAutoGeneratedKeys_.resultSet_;
                                this.preparedStatementForAutoGeneratedKeys_.resultSet_ = null;
                            }
                        }
                        if (!bl3) break;
                        if (bl4) {
                            this.connection_.readCommitSubstitute_();
                            break;
                        }
                        this.connection_.readCommit();
                        break;
                    }
                    case 1: {
                        try {
                            this.readOpenQuery();
                        }
                        catch (DisconnectException disconnectException) {
                            throw disconnectException;
                        }
                        catch (SqlException sqlException) {
                            throw sqlException;
                        }
                        if (this.resultSet_ == null) break;
                        this.resultSet_.parseScrollableRowset();
                        this.mapCursorNameToResultSet();
                        break;
                    }
                    case 2: {
                        this.readExecuteCall();
                    }
                }
                this.agent_.endReadChain();
                if (this.sqlMode_ == 2) {
                    this.parseStorProcReturnedScrollableRowset();
                    if (this.connection_.autoCommit_ && this.resultSet_ == null && this.resultSetList_ == null && this.isAutoCommittableStatement_) {
                        this.connection_.flowAutoCommit();
                    }
                }
                if (this.resultSet_ != null && this.resultSet_.resultSetHoldability_ != this.resultSetHoldability_ && this.sqlMode_ != 2) {
                    throw new SqlException(this.agent_.logWriter_, "Unable to open resultSet with requested holdability " + this.resultSetHoldability_ + ".");
                }
                Object var13_15 = null;
                if (this.timeout_ == 0) break block35;
                timer.cancel();
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (this.timeout_ != 0) {
                    timer.cancel();
                    queryTimerTask.cancel();
                }
                throw throwable;
            }
            queryTimerTask.cancel();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatchX(boolean bl) throws SqlException, BatchUpdateException {
        Connection connection = this.connection_;
        synchronized (connection) {
            this.checkForClosedStatement();
            this.clearWarningsX();
            return this.executeBatchRequestX(bl);
        }
    }

    private int[] executeBatchRequestX(boolean bl) throws SqlException, BatchUpdateException {
        int n;
        int n2;
        int n3;
        SqlException sqlException = null;
        int n4 = this.batch_.size();
        int[] nArray = new int[n4];
        int n5 = this.parameterMetaData_ == null ? 0 : this.parameterMetaData_.getColumnCount();
        Object[] objectArray = null;
        if (n4 == 0) {
            return nArray;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = -3;
        }
        if (!bl && this.sqlMode_ == 1) {
            throw new BatchUpdateException(this.agent_.logWriter_, "Batching of queries not allowed by J2EE compliance", nArray);
        }
        if (bl && this.sqlMode_ != 1) {
            throw new BatchUpdateException(this.agent_.logWriter_, "Query batch requested on a non-query statement", nArray);
        }
        this.resultSetList_ = null;
        if (this.sqlMode_ == 1) {
            this.indexOfCurrentResultSet_ = -1;
            this.resultSetList_ = new ResultSet[n4];
        }
        objectArray = this.parameters_;
        this.agent_.beginBatchedWriteChain(this);
        n3 = this.connection_.willAutoCommitGenerateFlow() && this.isAutoCommittableStatement_ ? 1 : 0;
        for (n2 = 0; n2 < n4; ++n2) {
            this.parameters_ = (Object[])this.batch_.get(n2);
            if (this.sqlMode_ != 2) {
                n = this.resultSetMetaData_ != null && this.resultSetMetaData_.getColumnCount() > 0 ? 1 : 0;
                this.writeExecute(this.section_, this.parameterMetaData_, this.parameters_, n5, n != 0, n3 != 0 || n2 != n4 - 1);
                continue;
            }
            if (this.outputRegistered_) {
                throw new BatchUpdateException(this.agent_.logWriter_, "No output parameters are allowed in batch updates", nArray);
            }
            this.writeExecuteCall(false, null, this.section_, this.fetchSize_, true, this.resultSetType_, this.parameterMetaData_, this.parameters_);
        }
        n2 = 0;
        if (n3 != 0) {
            if (this.agent_.accumulatedReadExceptions_ != null) {
                this.connection_.writeCommitSubstitute_();
                n2 = 1;
            } else {
                this.connection_.writeCommit();
            }
        }
        this.agent_.flowBatch(this, n4);
        try {
            for (n = 0; n < n4; ++n) {
                this.agent_.setBatchedExceptionLabelIndex(n);
                this.parameters_ = (Object[])this.batch_.get(n);
                if (this.sqlMode_ != 2) {
                    this.readExecute();
                } else {
                    this.readExecuteCall();
                }
                nArray[n] = this.updateCount_;
            }
            this.agent_.disableBatchedExceptionTracking();
            if (n3 != 0) {
                if (n2 == 0) {
                    this.connection_.readCommit();
                } else {
                    this.connection_.readCommitSubstitute_();
                }
            }
        }
        catch (SqlException sqlException2) {
            sqlException = sqlException2;
            sqlException.setNextException(new SqlException(this.agent_.logWriter_, "Non-recoverable chain-breaking exception occurred during batch processing.  The batch is terminated non-atomically."));
        }
        this.batch_.clear();
        this.parameters_ = objectArray;
        this.agent_.endBatchedReadChain(nArray, sqlException);
        return nArray;
    }

    public void listenToUnitOfWork() {
        if (!this.listenToUnitOfWork_) {
            this.listenToUnitOfWork_ = true;
            this.connection_.CommitAndRollbackListeners_.add(this);
        }
    }

    public void completeLocalCommit(Iterator iterator) {
        if (this.section_ != null) {
            this.openOnServer_ = false;
        }
        iterator.remove();
        this.listenToUnitOfWork_ = false;
    }

    public void completeLocalRollback(Iterator iterator) {
        if (this.section_ != null) {
            this.openOnServer_ = false;
        }
        iterator.remove();
        this.listenToUnitOfWork_ = false;
    }

    private int checkSetterPreconditions(int n) throws SqlException {
        super.checkForClosedStatement();
        n = this.checkForEscapedCallWithResult(n);
        this.checkForValidParameterIndex(n);
        return n;
    }

    void checkForValidParameterIndex(int n) throws SqlException {
        if (this.parameterMetaData_ == null || n < 1 || n > this.parameterMetaData_.columns_) {
            throw new SqlException(this.agent_.logWriter_, "Invalid argument: parameter index " + n + " is out of range.");
        }
    }

    private void checkThatAllParametersAreSet() throws SqlException {
        if (this.parameterMetaData_ != null) {
            for (int i = 0; i < this.parameterMetaData_.columns_; ++i) {
                if (this.parameterSet_[i] || this.parameterRegistered_[i]) continue;
                throw new SqlException(this.agent_.logWriter_, "At least one parameter to the current statement is uninitialized.", "07000");
            }
        }
    }

    private int checkForEscapedCallWithResult(int n) throws SqlException {
        if (this.escapedProcedureCallWithResult_) {
            if (n == 1) {
                throw new SqlException(this.agent_.logWriter_, "Invalid attempt to set the return value parameter of a CALL statement.Return value parameter of {?=CALL foo(?,?)} statement is parameter 1.");
            }
            --n;
        }
        return n;
    }

    void checkForValidScale(int n) throws SqlException {
        if (n < 0 || n > 31) {
            throw new SqlException(this.agent_.logWriter_, "Invalid argument: scale must be greater than or equal to 0 and less than 32.");
        }
    }

    void checkScaleForINOUTDecimal(int n, int n2) throws SqlException {
        BigDecimal bigDecimal = (BigDecimal)this.parameters_[n - 1];
        if (bigDecimal == null) {
            return;
        }
        if (n2 > this.parameterMetaData_.sqlScale_[n - 1]) {
            int n3 = bigDecimal.toString().length();
            int n4 = n2 - bigDecimal.scale();
            if (bigDecimal.signum() == -1) {
                --n3;
            }
            if (32 - n4 < n3) {
                throw new SqlException(this.agent_.logWriter_, "The scale supplied by the registerOutParameter method does not match with the setter method. Possible loss of precision!");
            }
            this.parameters_[n - 1] = bigDecimal.setScale(n2);
            this.parameterMetaData_.sqlScale_[n - 1] = n2;
        } else if (n2 < this.parameterMetaData_.sqlScale_[n - 1]) {
            try {
                this.parameters_[n - 1] = bigDecimal.setScale(n2);
                this.parameterMetaData_.sqlScale_[n - 1] = n2;
            }
            catch (ArithmeticException arithmeticException) {
                throw new SqlException(this.agent_.logWriter_, "The scale supplied by the registerOutParameter method does not match with the setter method. Possible loss of precision!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "close");
            }
            this.closeX();
        }
    }

    public void closeX() throws SqlException {
        if (!this.openOnClient_) {
            return;
        }
        super.closeX();
        if (this.parameterMetaData_ != null) {
            this.parameterMetaData_.markClosed();
            this.parameterMetaData_ = null;
        }
        this.sql_ = null;
        if (this.parameters_ != null) {
            for (int i = 0; i < this.parameters_.length; ++i) {
                this.parameters_[i] = null;
            }
        }
        this.parameters_ = null;
        this.connection_.CommitAndRollbackListeners_.remove(this);
    }
}

