/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.DB;
import org.apache.torque.adapter.DBFactory;
import org.apache.torque.dsfactory.DataSourceFactory;
import org.apache.torque.manager.AbstractBaseManager;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.TableMap;
import org.apache.torque.oid.IDBroker;
import org.apache.torque.oid.IDGeneratorFactory;
import org.apache.torque.util.BasePeer;

public class TorqueInstance {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$TorqueInstance == null ? (class$org$apache$torque$TorqueInstance = TorqueInstance.class$("org.apache.torque.TorqueInstance")) : class$org$apache$torque$TorqueInstance));
    private static final String DEFAULT_NAME = "default";
    private String defaultDBName = null;
    private Map dbMaps;
    private Map dsFactoryMap;
    private Map adapterMap;
    private Map managers;
    private Configuration conf;
    private boolean isInit = false;
    private boolean defaultDSFIsReference = false;
    private List mapBuilders = null;
    static /* synthetic */ Class class$org$apache$torque$TorqueInstance;

    public TorqueInstance() {
        this.resetConfiguration();
    }

    private synchronized void initialize() throws TorqueException {
        log.debug((Object)"initialize()");
        if (this.isInit) {
            log.debug((Object)"Multiple initializations of Torque attempted");
            return;
        }
        if (this.conf == null || this.conf.isEmpty()) {
            throw new TorqueException("Torque cannot be initialized without a valid configuration. Please check the log files for further details.");
        }
        Configuration subConf = this.conf.subset("torque");
        if (subConf == null || subConf.isEmpty()) {
            String error = "Invalid configuration. No keys starting with torque found in configuration";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        this.setConfiguration(subConf);
        this.initDefaultDbName(this.conf);
        this.initAdapters(this.conf);
        this.initDataSourceFactories(this.conf);
        this.dbMaps = new HashMap();
        Iterator i = this.mapBuilders.iterator();
        while (i.hasNext()) {
            BasePeer.getMapBuilder((String)i.next());
        }
        this.mapBuilders = null;
        this.initManagerMappings(this.conf);
        this.isInit = true;
    }

    private final void initDefaultDbName(Configuration conf) throws TorqueException {
        this.defaultDBName = conf.getString("database.default");
        if (this.defaultDBName == null) {
            String error = "Invalid configuration: Key torque.database.default not set";
            log.error((Object)error);
            throw new TorqueException(error);
        }
    }

    private final void initAdapters(Configuration conf) throws TorqueException {
        log.debug((Object)("initAdapters(" + conf + ")"));
        this.adapterMap = new HashMap();
        Configuration c = conf.subset("database");
        if (c == null || c.isEmpty()) {
            String error = "Invalid configuration : No keys starting with torque.database found in configuration";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        try {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.endsWith("adapter")) continue;
                String adapter = c.getString(key);
                String handle = key.substring(0, key.indexOf(46));
                DB db = DBFactory.create(adapter);
                this.adapterMap.put(handle, db);
                log.debug((Object)("Adding " + adapter + " -> " + handle + " as Adapter"));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading configuration seeking database adapters", (Throwable)e);
            throw new TorqueException(e);
        }
        if (this.adapterMap.get(Torque.getDefaultDB()) == null) {
            String error = "Invalid configuration : No adapter definition found for default DB An adapter must be defined under torque.database." + Torque.getDefaultDB() + "." + "adapter";
            log.error((Object)error);
            throw new TorqueException(error);
        }
    }

    private void initDataSourceFactories(Configuration conf) throws TorqueException {
        log.debug((Object)("initDataSourceFactories(" + conf + ")"));
        this.dsFactoryMap = new HashMap();
        Configuration c = conf.subset("dsfactory");
        if (c == null || c.isEmpty()) {
            String error = "Invalid configuration: No keys starting with torque.dsfactory found in configuration";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        try {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.endsWith("factory")) continue;
                String classname = c.getString(key);
                String handle = key.substring(0, key.indexOf(46));
                log.debug((Object)("handle: " + handle + " DataSourceFactory: " + classname));
                Class<?> dsfClass = Class.forName(classname);
                DataSourceFactory dsf = (DataSourceFactory)dsfClass.newInstance();
                dsf.initialize(c.subset(handle));
                this.dsFactoryMap.put(handle, dsf);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading adapter configuration", (Throwable)e);
            throw new TorqueException(e);
        }
        if (this.dsFactoryMap.get(Torque.getDefaultDB()) == null) {
            String error = "Invalid configuration : No DataSourceFactory definition for default DB found. A DataSourceFactory must be defined under the keytorque.dsfactory." + Torque.getDefaultDB() + "." + "factory";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        String defaultDB = this.getDefaultDB();
        if (this.dsFactoryMap.get(DEFAULT_NAME) == null && !defaultDB.equals(DEFAULT_NAME)) {
            log.debug((Object)("Adding a dummy entry for default, mapped onto " + defaultDB));
            this.dsFactoryMap.put(DEFAULT_NAME, this.dsFactoryMap.get(defaultDB));
            this.defaultDSFIsReference = true;
        }
    }

    public void init(String configFile) throws TorqueException {
        log.debug((Object)("init(" + configFile + ")"));
        try {
            PropertiesConfiguration conf = new PropertiesConfiguration(configFile);
            log.debug((Object)("Config Object is " + conf));
            this.init((Configuration)conf);
        }
        catch (ConfigurationException e) {
            throw new TorqueException(e);
        }
    }

    public void init(Configuration conf) throws TorqueException {
        log.debug((Object)("init(" + conf + ")"));
        this.setConfiguration(conf);
        this.initialize();
    }

    protected void initManagerMappings(Configuration conf) throws TorqueException {
        int pref = "managed_class.".length();
        int suff = ".manager".length();
        Iterator it = conf.getKeys();
        while (it.hasNext()) {
            String managedClassKey;
            String key = (String)it.next();
            if (!key.startsWith("managed_class.") || !key.endsWith(".manager") || this.managers.containsKey(managedClassKey = key.substring(pref, key.length() - suff))) continue;
            String managerClass = conf.getString(key);
            log.info((Object)("Added Manager for Class: " + managedClassKey + " -> " + managerClass));
            try {
                this.initManager(managedClassKey, managerClass);
            }
            catch (TorqueException e) {
                log.error((Object)"", (Throwable)((Object)e));
                e.printStackTrace();
                throw e;
            }
        }
    }

    private synchronized void initManager(String name, String className) throws TorqueException {
        AbstractBaseManager manager = (AbstractBaseManager)this.managers.get(name);
        if (manager == null && className != null && className.length() != 0) {
            try {
                manager = (AbstractBaseManager)Class.forName(className).newInstance();
                this.managers.put(name, manager);
            }
            catch (Exception e) {
                throw new TorqueException("Could not instantiate manager associated with class: " + name, e);
            }
        }
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void setConfiguration(Configuration conf) {
        log.debug((Object)("setConfiguration(" + conf + ")"));
        this.conf = conf;
    }

    public Configuration getConfiguration() {
        log.debug((Object)("getConfiguration() = " + this.conf));
        return this.conf;
    }

    public AbstractBaseManager getManager(String name) {
        AbstractBaseManager m = (AbstractBaseManager)this.managers.get(name);
        if (m == null) {
            log.error((Object)("No configured manager for key " + name + "."));
        }
        return m;
    }

    public AbstractBaseManager getManager(String name, String defaultClassName) {
        AbstractBaseManager m = (AbstractBaseManager)this.managers.get(name);
        if (m == null) {
            log.debug((Object)("Added late Manager mapping for Class: " + name + " -> " + defaultClassName));
            try {
                this.initManager(name, defaultClassName);
            }
            catch (TorqueException e) {
                log.error((Object)e.getMessage(), (Throwable)((Object)e));
            }
            m = (AbstractBaseManager)this.managers.get(name);
        }
        return m;
    }

    public synchronized void shutdown() throws TorqueException {
        if (this.dbMaps != null) {
            Iterator it = this.dbMaps.values().iterator();
            while (it.hasNext()) {
                DatabaseMap map = (DatabaseMap)it.next();
                IDBroker idBroker = map.getIDBroker();
                if (idBroker == null) continue;
                idBroker.stop();
            }
        }
        TorqueException exception = null;
        Iterator it = this.dsFactoryMap.keySet().iterator();
        while (it.hasNext()) {
            Object dsfKey = it.next();
            if (DEFAULT_NAME.equals(dsfKey) && this.defaultDSFIsReference) {
                it.remove();
                break;
            }
            DataSourceFactory dsf = (DataSourceFactory)this.dsFactoryMap.get(dsfKey);
            try {
                dsf.close();
                it.remove();
            }
            catch (TorqueException e) {
                log.error((Object)("Error while closing the DataSourceFactory " + dsfKey), (Throwable)((Object)e));
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.resetConfiguration();
    }

    private void resetConfiguration() {
        this.mapBuilders = Collections.synchronizedList(new ArrayList());
        this.managers = new HashMap();
        this.isInit = false;
    }

    public DatabaseMap getDatabaseMap() throws TorqueException {
        return this.getDatabaseMap(this.getDefaultDB());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseMap getDatabaseMap(String name) throws TorqueException {
        if (name == null) {
            throw new TorqueException("DatabaseMap name was null!");
        }
        if (this.dbMaps == null) {
            throw new TorqueException("Torque was not initialized properly.");
        }
        Map map = this.dbMaps;
        synchronized (map) {
            DatabaseMap map2 = (DatabaseMap)this.dbMaps.get(name);
            if (map2 == null) {
                map2 = this.initDatabaseMap(name);
            }
            return map2;
        }
    }

    private final DatabaseMap initDatabaseMap(String name) throws TorqueException {
        DatabaseMap map = new DatabaseMap(name);
        this.setupIdTable(map);
        try {
            String key = this.getDatabaseProperty(name, "adapter");
            if (StringUtils.isEmpty((String)key)) {
                key = this.getDatabaseProperty(name, "driver");
            }
            DB db = DBFactory.create(key);
            for (int i = 0; i < IDGeneratorFactory.ID_GENERATOR_METHODS.length; ++i) {
                map.addIdGenerator(IDGeneratorFactory.ID_GENERATOR_METHODS[i], IDGeneratorFactory.create(db, name));
            }
        }
        catch (InstantiationException e) {
            throw new TorqueException(e);
        }
        HashMap<String, DatabaseMap> newMaps = new HashMap<String, DatabaseMap>(this.dbMaps);
        newMaps.put(name, map);
        this.dbMaps = newMaps;
        return map;
    }

    public void registerMapBuilder(String className) {
        this.mapBuilders.add(className);
    }

    private String getDatabaseProperty(String db, String prop) {
        return this.conf.getString("database." + db + '.' + prop, "");
    }

    private final void setupIdTable(DatabaseMap map) {
        map.setIdTable("ID_TABLE");
        TableMap tMap = map.getIdTable();
        tMap.addPrimaryKey("ID_TABLE_ID", new Integer(0));
        tMap.addColumn("TABLE_NAME", "");
        tMap.addColumn("NEXT_ID", new Integer(0));
        tMap.addColumn("QUANTITY", new Integer(0));
    }

    public Connection getConnection() throws TorqueException {
        return this.getConnection(this.getDefaultDB());
    }

    public Connection getConnection(String name) throws TorqueException {
        Object con = null;
        Object dsf = null;
        try {
            return this.getDataSourceFactory(name).getDataSource().getConnection();
        }
        catch (SQLException se) {
            throw new TorqueException(se);
        }
    }

    protected DataSourceFactory getDataSourceFactory(String name) throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized.");
        }
        DataSourceFactory dsf = null;
        try {
            dsf = (DataSourceFactory)this.dsFactoryMap.get(name);
        }
        catch (Exception e) {
            throw new TorqueException(e);
        }
        if (dsf == null) {
            throw new NullPointerException("There was no DataSourceFactory configured for the connection " + name);
        }
        return dsf;
    }

    public Connection getConnection(String name, String username, String password) throws TorqueException {
        try {
            return this.getDataSourceFactory(name).getDataSource().getConnection(username, password);
        }
        catch (SQLException se) {
            throw new TorqueException(se);
        }
    }

    public DB getDB(String name) throws TorqueException {
        return (DB)this.adapterMap.get(name);
    }

    public String getDefaultDB() {
        return this.defaultDBName;
    }

    public void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error occured while closing connection.", (Throwable)e);
            }
        }
    }

    public void setSchema(String name, String schema) throws TorqueException {
        this.getDataSourceFactory(name).setSchema(schema);
    }

    public String getSchema(String name) throws TorqueException {
        return this.getDataSourceFactory(name).getSchema();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

