/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public abstract class BinaryComparisonOperatorNode
extends BinaryOperatorNode {
    private boolean forQueryRewrite;
    private boolean betweenSelectivity;

    public void init(Object object, Object object2, Object object3, Object object4) {
        super.init(object, object2, object3, object4, "org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor");
    }

    public void setForQueryRewrite(boolean bl) {
        this.forQueryRewrite = bl;
    }

    public boolean getForQueryRewrite() {
        return this.forQueryRewrite;
    }

    void setBetweenSelectivity() {
        this.betweenSelectivity = true;
    }

    boolean getBetweenSelectivity() {
        return this.betweenSelectivity;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        super.bindExpression(fromList, subqueryList, vector);
        TypeCompiler typeCompiler = this.leftOperand.getTypeCompiler();
        TypeCompiler typeCompiler2 = this.rightOperand.getTypeCompiler();
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        if (!typeId.isStringTypeId() && typeId2.isStringTypeId()) {
            DataTypeDescriptor dataTypeDescriptor = this.rightOperand.getTypeServices();
            this.rightOperand = (ValueNode)this.getNodeFactory().getNode(60, this.rightOperand, new DataTypeDescriptor(typeId2, true, dataTypeDescriptor.getMaximumWidth()), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        } else if (!typeId2.isStringTypeId() && typeId.isStringTypeId()) {
            DataTypeDescriptor dataTypeDescriptor = this.leftOperand.getTypeServices();
            this.leftOperand = (ValueNode)this.getNodeFactory().getNode(60, this.leftOperand, new DataTypeDescriptor(typeId, true, dataTypeDescriptor.getMaximumWidth()), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        } else if (!typeId.isNationalStringTypeId() && typeId2.isNationalStringTypeId()) {
            this.leftOperand = (ValueNode)this.getNodeFactory().getNode(60, this.leftOperand, DataTypeDescriptor.getBuiltInDataTypeDescriptor(typeCompiler.getMatchingNationalCharTypeName(), typeCompiler.getCastToCharWidth(this.leftOperand.getTypeServices())), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        } else if (!typeId2.isNationalStringTypeId() && typeId.isNationalStringTypeId()) {
            this.rightOperand = (ValueNode)this.getNodeFactory().getNode(60, this.rightOperand, DataTypeDescriptor.getBuiltInDataTypeDescriptor(typeCompiler2.getMatchingNationalCharTypeName(), typeCompiler2.getCastToCharWidth(this.rightOperand.getTypeServices())), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        }
        this.bindComparisonOperator();
        return this;
    }

    public void bindComparisonOperator() throws StandardException {
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        boolean bl = this.operator.equals("=") || this.operator.equals("<>");
        boolean bl2 = this.leftOperand.getTypeCompiler().comparable(typeId2, bl, this.getClassFactory());
        if (!bl2 && !this.forQueryRewrite) {
            throw StandardException.newException("42818", (Object)typeId.getSQLTypeName(), (Object)typeId2.getSQLTypeName());
        }
        boolean bl3 = this.leftOperand.getTypeServices().isNullable() || this.rightOperand.getTypeServices().isNullable();
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, bl3));
    }

    public ValueNode preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.leftOperand = this.leftOperand.preprocess(n, fromList, subqueryList, predicateList);
        if (this.rightOperand instanceof SubqueryNode && !((SubqueryNode)this.rightOperand).getPreprocessed()) {
            ((SubqueryNode)this.rightOperand).setParentComparisonOperator(this);
            return this.rightOperand.preprocess(n, fromList, subqueryList, predicateList);
        }
        this.rightOperand = this.rightOperand.preprocess(n, fromList, subqueryList, predicateList);
        return this;
    }

    ValueNode eliminateNots(boolean bl) throws StandardException {
        if (!bl) {
            return this;
        }
        return this.getNegation(this.leftOperand, this.rightOperand);
    }

    BinaryOperatorNode getNegation(ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        return this;
    }

    public ValueNode changeToCNF(boolean bl) throws StandardException {
        if (bl && this.rightOperand instanceof SubqueryNode) {
            this.rightOperand = this.rightOperand.changeToCNF(bl);
        }
        return this;
    }

    public ValueNode genSQLJavaSQLTree() throws StandardException {
        TypeId typeId;
        TypeId typeId2 = this.leftOperand.getTypeId();
        if (typeId2.userType()) {
            if (this.leftOperand.getTypeCompiler().comparable(typeId2, false, this.getClassFactory())) {
                return this;
            }
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if ((typeId = this.rightOperand.getTypeId()).userType()) {
            if (this.rightOperand.getTypeCompiler().comparable(typeId, false, this.getClassFactory())) {
                return this;
            }
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        return this;
    }
}

