/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONString;
import net.sf.json.util.JSONTokener;
import net.sf.json.util.JSONUtils;

public class JSONSerializer {
    public static final int MODE_LIST = 1;
    public static final int MODE_OBJECT_ARRAY = 2;
    private int arrayMode = 1;
    private Map classMap;
    private Class rootClass;

    public static JSON toJSON(Object object) {
        JSON json = null;
        if (object == null) {
            json = JSONNull.getInstance();
        } else if (object instanceof JSONString) {
            json = JSONSerializer.toJSON((JSONString)object);
        } else if (object instanceof String) {
            json = JSONSerializer.toJSON((String)object);
        } else if (JSONUtils.isArray(object)) {
            json = JSONArray.fromObject(object);
        } else {
            try {
                json = JSONObject.fromObject(object);
            }
            catch (JSONException e) {
                if (object instanceof JSONTokener) {
                    ((JSONTokener)object).reset();
                }
                json = JSONArray.fromObject(object);
            }
        }
        return json;
    }

    private static JSON toJSON(JSONString string) {
        return JSONSerializer.toJSON(string.toJSONString());
    }

    private static JSON toJSON(String string) {
        JSON json = null;
        if (string.startsWith("[")) {
            json = JSONArray.fromString(string);
        } else if (string.startsWith("{")) {
            json = JSONObject.fromString(string);
        } else if ("null".equalsIgnoreCase(string)) {
            json = JSONNull.getInstance();
        } else {
            throw new JSONException("Invalid JSON String");
        }
        return json;
    }

    public JSONSerializer() {
    }

    public JSONSerializer(Class rootClass, Map classMap, int arrayMode) {
        this.rootClass = rootClass;
        this.classMap = classMap;
        this.arrayMode = arrayMode;
    }

    public synchronized int getArrayMode() {
        return this.arrayMode;
    }

    public synchronized Map getClassMap() {
        return this.classMap;
    }

    public synchronized Class getRootClass() {
        return this.rootClass;
    }

    public synchronized void reset() {
        this.arrayMode = 1;
        this.rootClass = null;
        this.classMap = null;
    }

    public synchronized void setArrayMode(int arrayMode) {
        this.arrayMode = arrayMode != 1 && arrayMode != 2 ? 1 : arrayMode;
    }

    public synchronized void setClassMap(Map classMap) {
        this.classMap = classMap;
    }

    public synchronized void setRootClass(Class rootClass) {
        this.rootClass = rootClass;
    }

    public synchronized Object toJava(JSON json) {
        if (JSONUtils.isNull(json)) {
            return null;
        }
        Object object = null;
        object = json instanceof JSONArray ? (this.arrayMode == 2 ? JSONArray.toArray((JSONArray)json, this.rootClass, this.classMap) : JSONArray.toList((JSONArray)json, this.rootClass, this.classMap)) : JSONObject.toBean((JSONObject)json, this.rootClass, this.classMap);
        return object;
    }
}

