/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.test;

import java.util.Iterator;

import junit.framework.TestCase;
import net.yher2.commons.struts.ErrorsUtils;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;

public class ActionFormTestCase extends TestCase {
	protected void assertDefault(String target) {
		assertEquals("", target);
	}
	protected void assertDefault(int target) {
		assertEquals(0, target);
	}
	protected void assertDefault(double target) {
		assertEquals(0d, target, 0);
	}
	protected void assertDefault(String target[]) {
		assertNotNull(target);
		assertEquals(0, target.length);
	}
	protected void assertDefault(int target[]) {
		assertNotNull(target);
		assertEquals(0, target.length);
	}
	
	protected void assertNoErrors(ActionErrors errors) {
		assertEquals(0, errors.size());
	}
	protected void assertRequired(String property, ActionErrors errors) {
		assertError(ErrorsUtils.REQUIRED, property, errors);
	}
	protected void assertId(String property, ActionErrors errors) {
		assertError(ErrorsUtils.INVALID, property, errors);
	}
	protected void assertError(String error, String property, ActionErrors errors) {
		Iterator it = errors.get(property);
		while (it.hasNext()) {
			Object obj = it.next();
			if (obj instanceof ActionMessage) {
				assertEquals(error, ((ActionMessage)obj).getKey());
			}
		}
	}

}
