/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.action;

import net.yher2.workstyle.Properties;
import net.yher2.workstyle.action.tag.SelectForm;
import net.yher2.workstyle.test.ActionFormTestCase;

public class SelectTagFormTest extends ActionFormTestCase {
	private SelectForm form;
	protected void setUp() throws Exception {
		super.setUp();
		form = new SelectForm();
		form.reset(null, null);
	}

	public void testReset() {
		setValid();
		form.reset(null, null);
		assertDefault(form.getTagId());
	}


	public void testValidate_すべて問題ない場合は空のActionErrorsを返す() {
		setValid();
		assertNoErrors(form.validate(null, null));
	}
	public void testValidate_fileIdがない場合はRequiredエラーを返す() {
		setValid();
		form.setTagId(0);
		assertId(Properties.TAG_ID, form.validate(null, null));
	}
	
	private void setValid() {
		form.setTagId(1);
	}
}
