/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.commons.velocity;

import java.text.DateFormat;

import junit.framework.TestCase;
import net.yher2.commons.lang.DateUtils;

public class VelocityToolTest extends TestCase {
	private VelocityTool tool;

	protected void setUp() throws Exception {
		super.setUp();
		tool = new VelocityTool();
	}
	
	public void testCut_文字列を指定の文字数でカットし続く文字をつける() {
		assertEquals("テスト...", tool.cut("テスト文字列", 3));
	}
	public void testCut_文字列が指定の文字数以下の場合はそのまま返す() {
		assertEquals("テスト文字列", tool.cut("テスト文字列", 7));
	}
	public void testCut_空文字やnullの場合は空文字を返す() {
		assertEquals("", tool.cut("", 3));
		assertEquals("", tool.cut(null, 3));
	}
	public void testCut_文字列が１文字以上で指定の文字数が0の場合は続き文字のみを返す() {
		assertEquals("...", tool.cut("あ", 0));
	}
	public void testCut_指定の文字数がマイナスの場合はそのまま返す() {
		assertEquals("テスト文字列", tool.cut("テスト文字列", -1));
	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.formatDate(Date)'
	 */
	public void testFormatDate() {
		assertEquals("2006/01/01", tool.formatDate(DateUtils.parse(2006, 1, 1)));
	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.formatTimestamp(Date)'
	 */
	public void testFormatTimestamp() {
		String expected = DateFormat.getDateTimeInstance().format(DateUtils.parse(2006, 1, 1));
		assertEquals(expected, tool.formatTimestamp(DateUtils.parse(2006, 1, 1)));
	}
	public void testFormatTimestamp_nullの場合は空文字を返すこと() {
		assertEquals("", tool.formatTimestamp(null));
	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.decode(boolean, String, String)'
	 */
	public void testDecodeBooleanStringString() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.decode(Object, Object, String, String)'
	 */
	public void testDecodeObjectObjectStringString() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.checked(boolean)'
	 */
	public void testCheckedBoolean() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.checked(int, Object)'
	 */
	public void testCheckedIntObject() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.checked(int, int)'
	 */
	public void testCheckedIntInt() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.checked(Object, Object)'
	 */
	public void testCheckedObjectObject() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.selected(int, int)'
	 */
	public void testSelectedIntInt() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.selected(int, String)'
	 */
	public void testSelectedIntString() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.selected(int, Object)'
	 */
	public void testSelectedIntObject() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.selected(Object, Object)'
	 */
	public void testSelectedObjectObject() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.wrapText(String, String, int)'
	 */
	public void testWrapText() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.wrapLine(String, String, int)'
	 */
	public void testWrapLine() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.multiRow(int, String, String)'
	 */
	public void testMultiRow() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.formatNumber(String)'
	 */
	public void testFormatNumberString() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.formatNumber(int)'
	 */
	public void testFormatNumberInt() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.formatNumber(long)'
	 */
	public void testFormatNumberLong() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.formatNumber(double)'
	 */
	public void testFormatNumberDouble() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.formatValue(String)'
	 */
	public void testFormatValueString() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.formatValue(double)'
	 */
	public void testFormatValueDouble() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.formatCurrencyValue(double)'
	 */
	public void testFormatCurrencyValue() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.formatPercentValue(double)'
	 */
	public void testFormatPercentValue() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.simpleHtmlFormat(String)'
	 */
	public void testSimpleHtmlFormat_URLはリンクになる() {
		String test = "このようなURL(http://www.url.com/hogehoge.doなど）はリンクになる";
		String expected = "<a href=\"http://www.url.com/hogehoge.do\">http://www.url.com/hogehoge.do</a>";
		String result = tool.formatHtmlSimple(test); 
		assertTrue(result.indexOf(expected) > 0);
	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.getStackTrace(Throwable)'
	 */
	public void testGetStackTrace() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.size(Collection)'
	 */
	public void testSizeCollection() {
		// TODO Auto-generated method stub

	}

	/*
	 * Test method for 'net.yher2.commons.velocity.VelocityTool.size(Object[])'
	 */
	public void testSizeObjectArray() {
		// TODO Auto-generated method stub

	}

}
