/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.torque;


import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import net.yher2.workstyle.torque.bean.TaskBean;
import net.yher2.workstyle.torque.bean.TaskRelationBean;

import org.apache.commons.collections.map.IdentityMap;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Transaction;
        
        

/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jan 26 23:30:02 JST 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to TaskRelation
 */
public abstract class BaseTaskRelation extends BaseObject
{
    /** The Peer class */
    private static final TaskRelationPeer peer =
        new TaskRelationPeer();

        
    /** The value for the srcTaskId field */
    private int srcTaskId;
      
    /** The value for the destTaskId field */
    private int destTaskId;
  
            
    /**
     * Get the SrcTaskId
     *
     * @return int
     */
    public int getSrcTaskId()
    {
        return srcTaskId;
    }

                              
    /**
     * Set the value of SrcTaskId
     *
     * @param v new value
     */
    public void setSrcTaskId(int v) throws TorqueException
    {
    
                  if (this.srcTaskId != v)
              {
            this.srcTaskId = v;
            setModified(true);
        }
    
                                  
                if (aTask != null && !(aTask.getTaskId() == v))
                {
            aTask = null;
        }
      
              }
          
    /**
     * Get the DestTaskId
     *
     * @return int
     */
    public int getDestTaskId()
    {
        return destTaskId;
    }

                        
    /**
     * Set the value of DestTaskId
     *
     * @param v new value
     */
    public void setDestTaskId(int v) 
    {
    
                  if (this.destTaskId != v)
              {
            this.destTaskId = v;
            setModified(true);
        }
    
          
              }
  
      
        
                  
    
        private Task aTask;

    /**
     * Declares an association between this object and a Task object
     *
     * @param v Task
     * @throws TorqueException
     */
    public void setTask(Task v) throws TorqueException
    {
            if (v == null)
        {
                          setSrcTaskId( 0);
              }
        else
        {
            setSrcTaskId(v.getTaskId());
        }
            aTask = v;
    }

                        
    /**
     * Returns the associated Task object.
           * If it was not retrieved before, the object is retrieved from
     * the database
           *
     * @return the associated Task object
           * @throws TorqueException
           */
    public Task getTask()
              throws TorqueException
          {
              if (aTask == null && (this.srcTaskId != 0))
        {
                              aTask = TaskPeer.retrieveByPK(SimpleKey.keyFor(this.srcTaskId));
                  
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               Task obj = TaskPeer.retrieveByPK(this.srcTaskId);
               obj.add${pCollName}(this);
            */
        }
              return aTask;
    }

    /**
     * Return the associated Task object
     * If it was not retrieved before, the object is retrieved from
     * the database using the passed connection
     *
     * @param connection the connection used to retrieve the associated object
     *        from the database, if it was not retrieved before
     * @return the associated Task object
     * @throws TorqueException
     */
    public Task getTask(Connection connection)
        throws TorqueException
    {
        if (aTask == null && (this.srcTaskId != 0))
        {
                          aTask = TaskPeer.retrieveByPK(SimpleKey.keyFor(this.srcTaskId), connection);
              
            /* The following can be used instead of the line above to
               guarantee the related object contains a reference
               to this object, but this level of coupling
               may be undesirable in many circumstances.
               As it can lead to a db query with many results that may
               never be used.
               Task obj = TaskPeer.retrieveByPK(this.srcTaskId, connection);
               obj.add${pCollName}(this);
            */
        }
        return aTask;
    }

    /**
     * Provides convenient way to set a relationship based on a
     * ObjectKey, for example
     * <code>bar.setFooKey(foo.getPrimaryKey())</code>
     *
         */
    public void setTaskKey(ObjectKey key) throws TorqueException
    {
      
                        setSrcTaskId(((NumberKey) key).intValue());
                  }
       
                
    private static List<String> fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList<String>();
              fieldNames.add("SrcTaskId");
              fieldNames.add("DestTaskId");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
          if (name.equals("SrcTaskId"))
        {
                return new Integer(getSrcTaskId());
            }
          if (name.equals("DestTaskId"))
        {
                return new Integer(getDestTaskId());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(TaskRelationPeer.SRC_TASK_ID))
        {
                return new Integer(getSrcTaskId());
            }
          if (name.equals(TaskRelationPeer.DEST_TASK_ID))
        {
                return new Integer(getDestTaskId());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
            if (pos == 0)
        {
                return new Integer(getSrcTaskId());
            }
              if (pos == 1)
        {
                return new Integer(getDestTaskId());
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
          save(TaskRelationPeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    TaskRelationPeer.doInsert((TaskRelation) this, con);
                    setNew(false);
                }
                else
                {
                    TaskRelationPeer.doUpdate((TaskRelation) this, con);
                }
                }

                      alreadyInSave = false;
        }
      }

                                        
  
    private final SimpleKey[] pks = new SimpleKey[2];
    private final ComboKey comboPK = new ComboKey(pks);

    /**
     * Set the PrimaryKey with an ObjectKey
     *
     * @param key
     */
    public void setPrimaryKey(ObjectKey key) throws TorqueException
    {
        SimpleKey[] keys = (SimpleKey[]) key.getValue();
                      setSrcTaskId(((NumberKey)keys[0]).intValue());
                        setDestTaskId(((NumberKey)keys[1]).intValue());
              }

    /**
     * Set the PrimaryKey using SimpleKeys.
     *
         * @param srcTaskId int
         * @param destTaskId int
         */
    public void setPrimaryKey( int srcTaskId, int destTaskId)
        throws TorqueException
    {
            setSrcTaskId(srcTaskId);
            setDestTaskId(destTaskId);
        }

    /**
     * Set the PrimaryKey using a String.
     */
    public void setPrimaryKey(String key) throws TorqueException
    {
        setPrimaryKey(new ComboKey(key));
    }
  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
              pks[0] = SimpleKey.keyFor(getSrcTaskId());
                  pks[1] = SimpleKey.keyFor(getDestTaskId());
                  return comboPK;
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections and sets the
     * related objects to isNew=true.
       */
      public TaskRelation copy() throws TorqueException
    {
        return copyInto(new TaskRelation());
    }
  
    protected TaskRelation copyInto(TaskRelation copyObj) throws TorqueException
    {
          copyObj.setSrcTaskId(srcTaskId);
          copyObj.setDestTaskId(destTaskId);
  
                            copyObj.setSrcTaskId( 0);
                                      copyObj.setDestTaskId( 0);
            
                return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public TaskRelationPeer getPeer()
    {
        return peer;
    }

  
    /**
     * Creates a TaskRelationBean with the contents of this object
       * This also creates beans for cached related objects, if they exist
       * @return a TaskRelationBean with the contents of this object
     */
    public TaskRelationBean getBean()
    {
        return getBean(new IdentityMap());
    }

    /**
     * Creates a TaskRelationBean with the contents of this object
     * intended for internal use only
     * @param createdBeans a IdentityMap which maps objects
     *        to already created beans
     * @return a TaskRelationBean with the contents of this object
     */
    public TaskRelationBean getBean(IdentityMap createdBeans)
    {
        TaskRelationBean result = (TaskRelationBean) createdBeans.get(this);
        if (result != null ) {
            // we have already created a bean for this object, return it
            return result;
        }
        // no bean exists for this object; create a new one
        result = new TaskRelationBean();
        createdBeans.put(this, result);

          result.setSrcTaskId(getSrcTaskId());
          result.setDestTaskId(getDestTaskId());
  
                    
        
      
                                
              if (aTask != null)
        {
            TaskBean relatedBean = aTask.getBean(createdBeans);
            result.setTaskBean(relatedBean);
        }
              result.setModified(isModified());
        result.setNew(isNew());
        return result;
    }

    /**
     * Creates an instance of TaskRelation with the contents
     * of a TaskRelationBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed
     * @param bean the TaskRelationBean which contents are used to create
     *        the resulting class
     * @return an instance of TaskRelation with the contents of bean
     */
    public static TaskRelation createTaskRelation(TaskRelationBean bean)
        throws TorqueException
    {
        return createTaskRelation(bean, new IdentityMap());
    }

    /**
     * Creates an instance of TaskRelation with the contents
     * of a TaskRelationBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed.
     *
     * This method is intended for internal use only.
     * @param bean the TaskRelationBean which contents are used to create
     *        the resulting class
     * @param createdObjects a IdentityMap which maps beans
     *        to already created objects
     * @return an instance of TaskRelation with the contents of bean
     */

    public static TaskRelation createTaskRelation(TaskRelationBean bean, IdentityMap createdObjects)
        throws TorqueException
    {
        TaskRelation result = (TaskRelation) createdObjects.get(bean);
        if (result != null)
        {
            // we already have an object for the bean, return it
            return result;
        }
        result = new TaskRelation();
        createdObjects.put(bean, result);

          result.setSrcTaskId(bean.getSrcTaskId());
          result.setDestTaskId(bean.getDestTaskId());
  
                    
        
      
                                
              {
            TaskBean relatedBean = bean.getTaskBean();
            if (relatedBean != null)
            {
                Task relatedObject = Task.createTask(relatedBean, createdObjects);
                result.setTask(relatedObject);
            }
        }
          result.setModified(bean.isModified());
    result.setNew(bean.isNew());
  	return result;
    }

                      

    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("TaskRelation:\n");
        str.append("SrcTaskId = ")
               .append(getSrcTaskId())
             .append("\n");
        str.append("DestTaskId = ")
               .append(getDestTaskId())
             .append("\n");
        return(str.toString());
    }
}
