/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.torque;


import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import net.yher2.workstyle.torque.bean.TagBean;
import net.yher2.workstyle.torque.bean.TagTypeBean;

import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;
            

/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jan 26 23:30:02 JST 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to TagType
 */
public abstract class BaseTagType extends BaseObject
{
    /** The Peer class */
    private static final TagTypePeer peer =
        new TagTypePeer();

        
    /** The value for the tagTypeId field */
    private int tagTypeId;
      
    /** The value for the name field */
    private String name;
      
    /** The value for the styleClass field */
    private String styleClass;
      
    /** The value for the sortOrder field */
    private int sortOrder;
  
            
    /**
     * Get the TagTypeId
     *
     * @return int
     */
    public int getTagTypeId()
    {
        return tagTypeId;
    }

                                              
    /**
     * Set the value of TagTypeId
     *
     * @param v new value
     */
    public void setTagTypeId(int v) throws TorqueException
    {
    
                  if (this.tagTypeId != v)
              {
            this.tagTypeId = v;
            setModified(true);
        }
    
          
                                  
                  // update associated Tag
        if (collTags != null)
        {
            for (int i = 0; i < collTags.size(); i++)
            {
                ((Tag) collTags.get(i))
                    .setTagTypeId(v);
            }
        }
                                }
          
    /**
     * Get the Name
     *
     * @return String
     */
    public String getName()
    {
        return name;
    }

                        
    /**
     * Set the value of Name
     *
     * @param v new value
     */
    public void setName(String v) 
    {
    
                  if (!ObjectUtils.equals(this.name, v))
              {
            this.name = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the StyleClass
     *
     * @return String
     */
    public String getStyleClass()
    {
        return styleClass;
    }

                        
    /**
     * Set the value of StyleClass
     *
     * @param v new value
     */
    public void setStyleClass(String v) 
    {
    
                  if (!ObjectUtils.equals(this.styleClass, v))
              {
            this.styleClass = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the SortOrder
     *
     * @return int
     */
    public int getSortOrder()
    {
        return sortOrder;
    }

                        
    /**
     * Set the value of SortOrder
     *
     * @param v new value
     */
    public void setSortOrder(int v) 
    {
    
                  if (this.sortOrder != v)
              {
            this.sortOrder = v;
            setModified(true);
        }
    
          
              }
  
         
                                
            
          /**
     * Collection to store aggregation of collTags
     */
    protected List<Tag> collTags;

    /**
     * Temporary storage of collTags to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initTags()
    {
        if (collTags == null)
        {
            collTags = new ArrayList<Tag>();
        }
    }

        
    /**
     * Method called to associate a Tag object to this object
     * through the Tag foreign key attribute
     *
     * @param l Tag
     * @throws TorqueException
     */
    public void addTag(Tag l) throws TorqueException
    {
        getTags().add(l);
        l.setTagType((TagType) this);
    }

    /**
     * The criteria used to select the current contents of collTags
     */
    private Criteria lastTagsCriteria = null;
      
    /**
                   * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTags(new Criteria())
                   *
     * @return the collection of associated objects
           * @throws TorqueException
           */
    public List<Tag> getTags()
              throws TorqueException
          {
                      if (collTags == null)
        {
            collTags = getTags(new Criteria(10));
        }
                return collTags;
          }

    /**
           * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this TagType has previously
           * been saved, it will retrieve related Tags from storage.
     * If this TagType is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException
     */
    public List<Tag> getTags(Criteria criteria) throws TorqueException
    {
              if (collTags == null)
        {
            if (isNew())
            {
               collTags = new ArrayList<Tag>();
            }
            else
            {
                        criteria.add(TagPeer.TAG_TYPE_ID, getTagTypeId() );
                        collTags = TagPeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                            criteria.add(TagPeer.TAG_TYPE_ID, getTagTypeId());
                            if (!lastTagsCriteria.equals(criteria))
                {
                    collTags = TagPeer.doSelect(criteria);
                }
            }
        }
        lastTagsCriteria = criteria;

        return collTags;
          }

    /**
           * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTags(new Criteria(),Connection)
           * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List<Tag> getTags(Connection con) throws TorqueException
    {
              if (collTags == null)
        {
            collTags = getTags(new Criteria(10), con);
        }
        return collTags;
          }

    /**
           * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this TagType has previously
           * been saved, it will retrieve related Tags from storage.
     * If this TagType is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List<Tag> getTags(Criteria criteria, Connection con)
            throws TorqueException
    {
              if (collTags == null)
        {
            if (isNew())
            {
               collTags = new ArrayList<Tag>();
            }
            else
            {
                         criteria.add(TagPeer.TAG_TYPE_ID, getTagTypeId());
                         collTags = TagPeer.doSelect(criteria, con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                             criteria.add(TagPeer.TAG_TYPE_ID, getTagTypeId());
                             if (!lastTagsCriteria.equals(criteria))
                 {
                     collTags = TagPeer.doSelect(criteria, con);
                 }
             }
         }
         lastTagsCriteria = criteria;

         return collTags;
           }

                  
              
                    
                              
                                
                                                              
                                        
                    
                    
          
    /**
                 * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this TagType is new, it will return
                 * an empty collection; or if this TagType has previously
     * been saved, it will retrieve related Tags from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TagType.
     */
    protected List getTagsJoinTagType(Criteria criteria)
        throws TorqueException
    {
                    if (collTags == null)
        {
            if (isNew())
            {
               collTags = new ArrayList<Tag>();
            }
            else
            {
                              criteria.add(TagPeer.TAG_TYPE_ID, getTagTypeId());
                              collTags = TagPeer.doSelectJoinTagType(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
                                    criteria.add(TagPeer.TAG_TYPE_ID, getTagTypeId());
                                    if (!lastTagsCriteria.equals(criteria))
            {
                collTags = TagPeer.doSelectJoinTagType(criteria);
            }
        }
        lastTagsCriteria = criteria;

        return collTags;
                }
                            


          
    private static List<String> fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList<String>();
              fieldNames.add("TagTypeId");
              fieldNames.add("Name");
              fieldNames.add("StyleClass");
              fieldNames.add("SortOrder");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
          if (name.equals("TagTypeId"))
        {
                return new Integer(getTagTypeId());
            }
          if (name.equals("Name"))
        {
                return getName();
            }
          if (name.equals("StyleClass"))
        {
                return getStyleClass();
            }
          if (name.equals("SortOrder"))
        {
                return new Integer(getSortOrder());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(TagTypePeer.TAG_TYPE_ID))
        {
                return new Integer(getTagTypeId());
            }
          if (name.equals(TagTypePeer.NAME))
        {
                return getName();
            }
          if (name.equals(TagTypePeer.STYLE_CLASS))
        {
                return getStyleClass();
            }
          if (name.equals(TagTypePeer.SORT_ORDER))
        {
                return new Integer(getSortOrder());
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
            if (pos == 0)
        {
                return new Integer(getTagTypeId());
            }
              if (pos == 1)
        {
                return getName();
            }
              if (pos == 2)
        {
                return getStyleClass();
            }
              if (pos == 3)
        {
                return new Integer(getSortOrder());
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
          save(TagTypePeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    TagTypePeer.doInsert((TagType) this, con);
                    setNew(false);
                }
                else
                {
                    TagTypePeer.doUpdate((TagType) this, con);
                }
                }

                                      
                                    if (collTags != null)
            {
                for (int i = 0; i < collTags.size(); i++)
                {
                    ((Tag) collTags.get(i)).save(con);
                }
            }
                                  alreadyInSave = false;
        }
      }

                        
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param key tagTypeId ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        throws TorqueException
    {
            setTagTypeId(((NumberKey) key).intValue());
        }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) throws TorqueException
    {
            setTagTypeId(Integer.parseInt(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getTagTypeId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections and sets the
     * related objects to isNew=true.
       */
      public TagType copy() throws TorqueException
    {
        return copyInto(new TagType());
    }
  
    protected TagType copyInto(TagType copyObj) throws TorqueException
    {
          copyObj.setTagTypeId(tagTypeId);
          copyObj.setName(name);
          copyObj.setStyleClass(styleClass);
          copyObj.setSortOrder(sortOrder);
  
                            copyObj.setTagTypeId( 0);
                              
                                      
                            
        List v = getTags();
                            if (v != null)
        {
            for (int i = 0; i < v.size(); i++)
            {
                Tag obj = (Tag) v.get(i);
                copyObj.addTag(obj.copy());
            }
        }
        else
        {
            copyObj.collTags = null;
        }
                            return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public TagTypePeer getPeer()
    {
        return peer;
    }

  
    /**
     * Creates a TagTypeBean with the contents of this object
       * This also creates beans for cached related objects, if they exist
       * @return a TagTypeBean with the contents of this object
     */
    public TagTypeBean getBean()
    {
        return getBean(new IdentityMap());
    }

    /**
     * Creates a TagTypeBean with the contents of this object
     * intended for internal use only
     * @param createdBeans a IdentityMap which maps objects
     *        to already created beans
     * @return a TagTypeBean with the contents of this object
     */
    public TagTypeBean getBean(IdentityMap createdBeans)
    {
        TagTypeBean result = (TagTypeBean) createdBeans.get(this);
        if (result != null ) {
            // we have already created a bean for this object, return it
            return result;
        }
        // no bean exists for this object; create a new one
        result = new TagTypeBean();
        createdBeans.put(this, result);

          result.setTagTypeId(getTagTypeId());
          result.setName(getName());
          result.setStyleClass(getStyleClass());
          result.setSortOrder(getSortOrder());
  
                                                        
                    
                  if (collTags != null)
        {
            List<TagBean> relatedBeans = new ArrayList<TagBean>(collTags.size());
            for (Iterator collTagsIt = collTags.iterator(); collTagsIt.hasNext(); )
            {
                Tag related = (Tag) collTagsIt.next();
                TagBean relatedBean = related.getBean(createdBeans);
                relatedBeans.add(relatedBean);
            }
            result.setTagBeans(relatedBeans);
        }
                  
                  result.setModified(isModified());
        result.setNew(isNew());
        return result;
    }

    /**
     * Creates an instance of TagType with the contents
     * of a TagTypeBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed
     * @param bean the TagTypeBean which contents are used to create
     *        the resulting class
     * @return an instance of TagType with the contents of bean
     */
    public static TagType createTagType(TagTypeBean bean)
        throws TorqueException
    {
        return createTagType(bean, new IdentityMap());
    }

    /**
     * Creates an instance of TagType with the contents
     * of a TagTypeBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed.
     *
     * This method is intended for internal use only.
     * @param bean the TagTypeBean which contents are used to create
     *        the resulting class
     * @param createdObjects a IdentityMap which maps beans
     *        to already created objects
     * @return an instance of TagType with the contents of bean
     */

    public static TagType createTagType(TagTypeBean bean, IdentityMap createdObjects)
        throws TorqueException
    {
        TagType result = (TagType) createdObjects.get(bean);
        if (result != null)
        {
            // we already have an object for the bean, return it
            return result;
        }
        result = new TagType();
        createdObjects.put(bean, result);

          result.setTagTypeId(bean.getTagTypeId());
          result.setName(bean.getName());
          result.setStyleClass(bean.getStyleClass());
          result.setSortOrder(bean.getSortOrder());
  
                                                        
                    
        {
            List relatedBeans = bean.getTagBeans();
            if (relatedBeans != null)
            {
                for (Iterator relatedBeansIt = relatedBeans.iterator(); relatedBeansIt.hasNext(); )
                {
                    TagBean relatedBean = (TagBean) relatedBeansIt.next();
                    Tag related = Tag.createTag(relatedBean, createdObjects);
                    result.addTagFromBean(related);
                }
            }
        }
                  
              result.setModified(bean.isModified());
    result.setNew(bean.isNew());
  	return result;
    }

                                                        
                    
    /**
     * Method called to associate a Tag object to this object.
     * through the Tag foreign key attribute
     *
     * @param toAdd Tag
     */
    protected void addTagFromBean(Tag toAdd)
    {
        initTags();
        collTags.add(toAdd);
    }
                    

    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("TagType:\n");
        str.append("TagTypeId = ")
               .append(getTagTypeId())
             .append("\n");
        str.append("Name = ")
               .append(getName())
             .append("\n");
        str.append("StyleClass = ")
               .append(getStyleClass())
             .append("\n");
        str.append("SortOrder = ")
               .append(getSortOrder())
             .append("\n");
        return(str.toString());
    }
}
