/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.torque;


import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import net.yher2.workstyle.torque.bean.FileInfoBean;
import net.yher2.workstyle.torque.bean.TaskFileRelationBean;

import org.apache.commons.collections.map.IdentityMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;
            

/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jan 26 23:30:02 JST 2006]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to FileInfo
 */
public abstract class BaseFileInfo extends BaseObject
{
    /** The Peer class */
    private static final FileInfoPeer peer =
        new FileInfoPeer();

        
    /** The value for the fileId field */
    private int fileId;
      
    /** The value for the name field */
    private String name;
      
    /** The value for the path field */
    private String path;
  
            
    /**
     * Get the FileId
     *
     * @return int
     */
    public int getFileId()
    {
        return fileId;
    }

                                              
    /**
     * Set the value of FileId
     *
     * @param v new value
     */
    public void setFileId(int v) throws TorqueException
    {
    
                  if (this.fileId != v)
              {
            this.fileId = v;
            setModified(true);
        }
    
          
                                  
                  // update associated TaskFileRelation
        if (collTaskFileRelations != null)
        {
            for (int i = 0; i < collTaskFileRelations.size(); i++)
            {
                ((TaskFileRelation) collTaskFileRelations.get(i))
                    .setFileId(v);
            }
        }
                                }
          
    /**
     * Get the Name
     *
     * @return String
     */
    public String getName()
    {
        return name;
    }

                        
    /**
     * Set the value of Name
     *
     * @param v new value
     */
    public void setName(String v) 
    {
    
                  if (!ObjectUtils.equals(this.name, v))
              {
            this.name = v;
            setModified(true);
        }
    
          
              }
          
    /**
     * Get the Path
     *
     * @return String
     */
    public String getPath()
    {
        return path;
    }

                        
    /**
     * Set the value of Path
     *
     * @param v new value
     */
    public void setPath(String v) 
    {
    
                  if (!ObjectUtils.equals(this.path, v))
              {
            this.path = v;
            setModified(true);
        }
    
          
              }
  
         
                                
            
          /**
     * Collection to store aggregation of collTaskFileRelations
     */
    protected List<TaskFileRelation> collTaskFileRelations;

    /**
     * Temporary storage of collTaskFileRelations to save a possible db hit in
     * the event objects are add to the collection, but the
     * complete collection is never requested.
     */
    protected void initTaskFileRelations()
    {
        if (collTaskFileRelations == null)
        {
            collTaskFileRelations = new ArrayList<TaskFileRelation>();
        }
    }

        
    /**
     * Method called to associate a TaskFileRelation object to this object
     * through the TaskFileRelation foreign key attribute
     *
     * @param l TaskFileRelation
     * @throws TorqueException
     */
    public void addTaskFileRelation(TaskFileRelation l) throws TorqueException
    {
        getTaskFileRelations().add(l);
        l.setFileInfo((FileInfo) this);
    }

    /**
     * The criteria used to select the current contents of collTaskFileRelations
     */
    private Criteria lastTaskFileRelationsCriteria = null;
      
    /**
                   * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTaskFileRelations(new Criteria())
                   *
     * @return the collection of associated objects
           * @throws TorqueException
           */
    public List<TaskFileRelation> getTaskFileRelations()
              throws TorqueException
          {
                      if (collTaskFileRelations == null)
        {
            collTaskFileRelations = getTaskFileRelations(new Criteria(10));
        }
                return collTaskFileRelations;
          }

    /**
           * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this FileInfo has previously
           * been saved, it will retrieve related TaskFileRelations from storage.
     * If this FileInfo is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException
     */
    public List<TaskFileRelation> getTaskFileRelations(Criteria criteria) throws TorqueException
    {
              if (collTaskFileRelations == null)
        {
            if (isNew())
            {
               collTaskFileRelations = new ArrayList<TaskFileRelation>();
            }
            else
            {
                        criteria.add(TaskFileRelationPeer.FILE_ID, getFileId() );
                        collTaskFileRelations = TaskFileRelationPeer.doSelect(criteria);
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                            criteria.add(TaskFileRelationPeer.FILE_ID, getFileId());
                            if (!lastTaskFileRelationsCriteria.equals(criteria))
                {
                    collTaskFileRelations = TaskFileRelationPeer.doSelect(criteria);
                }
            }
        }
        lastTaskFileRelationsCriteria = criteria;

        return collTaskFileRelations;
          }

    /**
           * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTaskFileRelations(new Criteria(),Connection)
           * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List<TaskFileRelation> getTaskFileRelations(Connection con) throws TorqueException
    {
              if (collTaskFileRelations == null)
        {
            collTaskFileRelations = getTaskFileRelations(new Criteria(10), con);
        }
        return collTaskFileRelations;
          }

    /**
           * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this FileInfo has previously
           * been saved, it will retrieve related TaskFileRelations from storage.
     * If this FileInfo is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     */
    public List<TaskFileRelation> getTaskFileRelations(Criteria criteria, Connection con)
            throws TorqueException
    {
              if (collTaskFileRelations == null)
        {
            if (isNew())
            {
               collTaskFileRelations = new ArrayList<TaskFileRelation>();
            }
            else
            {
                         criteria.add(TaskFileRelationPeer.FILE_ID, getFileId());
                         collTaskFileRelations = TaskFileRelationPeer.doSelect(criteria, con);
             }
         }
         else
         {
             // criteria has no effect for a new object
             if (!isNew())
             {
                 // the following code is to determine if a new query is
                 // called for.  If the criteria is the same as the last
                 // one, just return the collection.
                             criteria.add(TaskFileRelationPeer.FILE_ID, getFileId());
                             if (!lastTaskFileRelationsCriteria.equals(criteria))
                 {
                     collTaskFileRelations = TaskFileRelationPeer.doSelect(criteria, con);
                 }
             }
         }
         lastTaskFileRelationsCriteria = criteria;

         return collTaskFileRelations;
           }

                        
              
                    
                    
                                
                                                              
                                        
                    
                    
          
    /**
                 * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this FileInfo is new, it will return
                 * an empty collection; or if this FileInfo has previously
     * been saved, it will retrieve related TaskFileRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in FileInfo.
     */
    protected List getTaskFileRelationsJoinTask(Criteria criteria)
        throws TorqueException
    {
                    if (collTaskFileRelations == null)
        {
            if (isNew())
            {
               collTaskFileRelations = new ArrayList<TaskFileRelation>();
            }
            else
            {
                              criteria.add(TaskFileRelationPeer.FILE_ID, getFileId());
                              collTaskFileRelations = TaskFileRelationPeer.doSelectJoinTask(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
                                    criteria.add(TaskFileRelationPeer.FILE_ID, getFileId());
                                    if (!lastTaskFileRelationsCriteria.equals(criteria))
            {
                collTaskFileRelations = TaskFileRelationPeer.doSelectJoinTask(criteria);
            }
        }
        lastTaskFileRelationsCriteria = criteria;

        return collTaskFileRelations;
                }
                  
                    
                              
                                
                                                              
                                        
                    
                    
          
    /**
                 * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this FileInfo is new, it will return
                 * an empty collection; or if this FileInfo has previously
     * been saved, it will retrieve related TaskFileRelations from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in FileInfo.
     */
    protected List getTaskFileRelationsJoinFileInfo(Criteria criteria)
        throws TorqueException
    {
                    if (collTaskFileRelations == null)
        {
            if (isNew())
            {
               collTaskFileRelations = new ArrayList<TaskFileRelation>();
            }
            else
            {
                              criteria.add(TaskFileRelationPeer.FILE_ID, getFileId());
                              collTaskFileRelations = TaskFileRelationPeer.doSelectJoinFileInfo(criteria);
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
                                    criteria.add(TaskFileRelationPeer.FILE_ID, getFileId());
                                    if (!lastTaskFileRelationsCriteria.equals(criteria))
            {
                collTaskFileRelations = TaskFileRelationPeer.doSelectJoinFileInfo(criteria);
            }
        }
        lastTaskFileRelationsCriteria = criteria;

        return collTaskFileRelations;
                }
                            


          
    private static List<String> fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList<String>();
              fieldNames.add("FileId");
              fieldNames.add("Name");
              fieldNames.add("Path");
              fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
          if (name.equals("FileId"))
        {
                return new Integer(getFileId());
            }
          if (name.equals("Name"))
        {
                return getName();
            }
          if (name.equals("Path"))
        {
                return getPath();
            }
          return null;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
          if (name.equals(FileInfoPeer.FILE_ID))
        {
                return new Integer(getFileId());
            }
          if (name.equals(FileInfoPeer.NAME))
        {
                return getName();
            }
          if (name.equals(FileInfoPeer.PATH))
        {
                return getPath();
            }
          return null;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
            if (pos == 0)
        {
                return new Integer(getFileId());
            }
              if (pos == 1)
        {
                return getName();
            }
              if (pos == 2)
        {
                return getPath();
            }
              return null;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
          save(FileInfoPeer.getMapBuilder()
                .getDatabaseMap().getName());
      }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
       * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
       *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
          try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
      }

      /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
      /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
          if (!alreadyInSave)
        {
            alreadyInSave = true;


  
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    FileInfoPeer.doInsert((FileInfo) this, con);
                    setNew(false);
                }
                else
                {
                    FileInfoPeer.doUpdate((FileInfo) this, con);
                }
                }

                                      
                                    if (collTaskFileRelations != null)
            {
                for (int i = 0; i < collTaskFileRelations.size(); i++)
                {
                    ((TaskFileRelation) collTaskFileRelations.get(i)).save(con);
                }
            }
                                  alreadyInSave = false;
        }
      }

                        
      /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param key fileId ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        throws TorqueException
    {
            setFileId(((NumberKey) key).intValue());
        }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) throws TorqueException
    {
            setFileId(Integer.parseInt(key));
        }

  
    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
          return SimpleKey.keyFor(getFileId());
      }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
       * It then fills all the association collections and sets the
     * related objects to isNew=true.
       */
      public FileInfo copy() throws TorqueException
    {
        return copyInto(new FileInfo());
    }
  
    protected FileInfo copyInto(FileInfo copyObj) throws TorqueException
    {
          copyObj.setFileId(fileId);
          copyObj.setName(name);
          copyObj.setPath(path);
  
                            copyObj.setFileId( 0);
                        
                                      
                            
        List v = getTaskFileRelations();
                            if (v != null)
        {
            for (int i = 0; i < v.size(); i++)
            {
                TaskFileRelation obj = (TaskFileRelation) v.get(i);
                copyObj.addTaskFileRelation(obj.copy());
            }
        }
        else
        {
            copyObj.collTaskFileRelations = null;
        }
                            return copyObj;
    }

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public FileInfoPeer getPeer()
    {
        return peer;
    }

  
    /**
     * Creates a FileInfoBean with the contents of this object
       * This also creates beans for cached related objects, if they exist
       * @return a FileInfoBean with the contents of this object
     */
    public FileInfoBean getBean()
    {
        return getBean(new IdentityMap());
    }

    /**
     * Creates a FileInfoBean with the contents of this object
     * intended for internal use only
     * @param createdBeans a IdentityMap which maps objects
     *        to already created beans
     * @return a FileInfoBean with the contents of this object
     */
    public FileInfoBean getBean(IdentityMap createdBeans)
    {
        FileInfoBean result = (FileInfoBean) createdBeans.get(this);
        if (result != null ) {
            // we have already created a bean for this object, return it
            return result;
        }
        // no bean exists for this object; create a new one
        result = new FileInfoBean();
        createdBeans.put(this, result);

          result.setFileId(getFileId());
          result.setName(getName());
          result.setPath(getPath());
  
                                                        
                    
                  if (collTaskFileRelations != null)
        {
            List<TaskFileRelationBean> relatedBeans = new ArrayList<TaskFileRelationBean>(collTaskFileRelations.size());
            for (Iterator collTaskFileRelationsIt = collTaskFileRelations.iterator(); collTaskFileRelationsIt.hasNext(); )
            {
                TaskFileRelation related = (TaskFileRelation) collTaskFileRelationsIt.next();
                TaskFileRelationBean relatedBean = related.getBean(createdBeans);
                relatedBeans.add(relatedBean);
            }
            result.setTaskFileRelationBeans(relatedBeans);
        }
                  
                  result.setModified(isModified());
        result.setNew(isNew());
        return result;
    }

    /**
     * Creates an instance of FileInfo with the contents
     * of a FileInfoBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed
     * @param bean the FileInfoBean which contents are used to create
     *        the resulting class
     * @return an instance of FileInfo with the contents of bean
     */
    public static FileInfo createFileInfo(FileInfoBean bean)
        throws TorqueException
    {
        return createFileInfo(bean, new IdentityMap());
    }

    /**
     * Creates an instance of FileInfo with the contents
     * of a FileInfoBean.
     * This behaviour could have also been achieved using a constructor,
     * however as this class is abstract no constructors are allowed.
     *
     * This method is intended for internal use only.
     * @param bean the FileInfoBean which contents are used to create
     *        the resulting class
     * @param createdObjects a IdentityMap which maps beans
     *        to already created objects
     * @return an instance of FileInfo with the contents of bean
     */

    public static FileInfo createFileInfo(FileInfoBean bean, IdentityMap createdObjects)
        throws TorqueException
    {
        FileInfo result = (FileInfo) createdObjects.get(bean);
        if (result != null)
        {
            // we already have an object for the bean, return it
            return result;
        }
        result = new FileInfo();
        createdObjects.put(bean, result);

          result.setFileId(bean.getFileId());
          result.setName(bean.getName());
          result.setPath(bean.getPath());
  
                                                        
                    
        {
            List relatedBeans = bean.getTaskFileRelationBeans();
            if (relatedBeans != null)
            {
                for (Iterator relatedBeansIt = relatedBeans.iterator(); relatedBeansIt.hasNext(); )
                {
                    TaskFileRelationBean relatedBean = (TaskFileRelationBean) relatedBeansIt.next();
                    TaskFileRelation related = TaskFileRelation.createTaskFileRelation(relatedBean, createdObjects);
                    result.addTaskFileRelationFromBean(related);
                }
            }
        }
                  
              result.setModified(bean.isModified());
    result.setNew(bean.isNew());
  	return result;
    }

                                                        
                    
    /**
     * Method called to associate a TaskFileRelation object to this object.
     * through the TaskFileRelation foreign key attribute
     *
     * @param toAdd TaskFileRelation
     */
    protected void addTaskFileRelationFromBean(TaskFileRelation toAdd)
    {
        initTaskFileRelations();
        collTaskFileRelations.add(toAdd);
    }
                    

    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("FileInfo:\n");
        str.append("FileId = ")
               .append(getFileId())
             .append("\n");
        str.append("Name = ")
               .append(getName())
             .append("\n");
        str.append("Path = ")
               .append(getPath())
             .append("\n");
        return(str.toString());
    }
}
