/**
 * Copyright (c) 2006, yher2.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher2.workstyle.action.task;

import java.sql.Connection;
import java.util.List;

import net.yher2.commons.lang.Pager;
import net.yher2.workstyle.TaskQuery;
import net.yher2.workstyle.action.Session;
import net.yher2.workstyle.exception.NotFoundException;
import net.yher2.workstyle.manager.StatusManager;
import net.yher2.workstyle.manager.TagManager;
import net.yher2.workstyle.manager.TaskManager;
import net.yher2.workstyle.torque.bean.TaskBean;

import org.apache.torque.TorqueException;

public class TaskUtils {
	private Connection con = null;
	private Session session;
	
	public TaskUtils(Session session, Connection con) {
		this.con = con;
		this.session = session;
	}

	public void prepare() throws TorqueException {
		session.setStatusList(new StatusManager(con).list());
		prepareTag();
	}
	
	public void prepareTag() throws TorqueException {
		session.setTagList(new TagManager(con).list());
	}

	public void search(TaskQuery query, Pager pager) throws TorqueException {
		session.setTaskList(new TaskManager(con).search(query, pager));
		session.setQuery(query, pager);
		prepare();
	}
	public void searchUnlinkedTask(TaskQuery query, Pager pager) throws TorqueException {
		session.setTaskList(new TaskManager(con).search(query, pager));
		session.setUnlinkedTaskQuery(query, pager);
		prepare();
	}
	public List<TaskBean> searchDetail(TaskQuery query, Pager pager) throws TorqueException {
		List<TaskBean> taskList = new TaskManager(con).searchDetail(query, pager);
		session.setTaskList(taskList);
		session.setQuery(query, pager);
		prepare();
		return taskList;
	}
	
	public void get(int taskId) throws TorqueException, NotFoundException {
		session.setTask(new TaskManager(con).get(taskId));
		prepare();
	}
}
