package net.yher2.workstyle.action.tag.rest;

import javax.servlet.http.HttpServletRequest;

import net.yher2.commons.struts.Validator;
import net.yher2.workstyle.Properties;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class AddForm extends ActionForm {
	private String name;

	@Override
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		super.reset(mapping, request);
		name = "";
	}

	@Override
	public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
		Validator validator = new Validator(super.validate(mapping, request));
		validator.verifyRequired(Properties.TAG, name);
		validator.verifyMaxLength(Properties.TAG, name, 50);
		return validator.getErrors();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
}
