/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db.data;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.yher2.junit.db.data.XmlParser;

public class XmlParserTest
extends TestCase {
    public void testNomalize() {
        Assert.assertEquals((String)"<date value=\"2004%2F12%2F21+13%3A52%3A11\" format=\"yyyy%2FMM%2Fdd+HH%3Amm%3Ass\"/>", (String)new XmlParser("<date value=\"2004/12/21 13:52:11\" format=\"yyyy/MM/dd HH:mm:ss\"/>").getXml());
        Assert.assertEquals((String)"<date/>", (String)new XmlParser("<date/>").getXml());
        Assert.assertEquals((String)"<char value=\"1%3C%3E%26quot%3B\"/>", (String)new XmlParser("<char value \t\r\n= \t\r\n\"1<>&quot;\"/>").getXml());
        Assert.assertEquals((String)"<random length=\"3\" type=\"alphabet\"/>", (String)new XmlParser("<random length=\"3\" \n type=\"alphabet\"/>").getXml());
        Assert.assertEquals((String)"<random length=\"2\" type=\"alphabet\"/>", (String)new XmlParser("<random length=\"2\" \r\n type=\"alphabet\"/>").getXml());
        Assert.assertEquals((String)"<random length=\"2\" type=\"number\"/>", (String)new XmlParser("<random length=\"2\" \t type=\"number\"/>").getXml());
        Assert.assertEquals((String)"<date/>", (String)new XmlParser("\n\r \t<date/>\n\r \t").getXml());
    }

    public void testIsXml() {
        Assert.assertTrue((boolean)new XmlParser("<date value=\"2004/12/21 13:52:11\" format=\"yyyy/MM/dd HH:mm:ss\"/>").isXml());
        Assert.assertTrue((boolean)new XmlParser("<date/>").isXml());
        Assert.assertTrue((boolean)new XmlParser("<string value=\"1\"/>").isXml());
        Assert.assertTrue((boolean)new XmlParser("<random length=\"3\" \n type=\"alphabet\"/>").isXml());
        Assert.assertTrue((boolean)new XmlParser("<random length=\"2\" \r\n type=\"alphabet\"/>").isXml());
        Assert.assertTrue((boolean)new XmlParser("<random length=\"2\" \t type=\"number\"/>").isXml());
        Assert.assertTrue((boolean)new XmlParser("\n\r \t<date/>\n\r \t").isXml());
        Assert.assertFalse((boolean)new XmlParser("d<ate/>").isXml());
        Assert.assertFalse((boolean)new XmlParser("<date/").isXml());
        Assert.assertFalse((boolean)new XmlParser("<date>").isXml());
    }

    public void testParse() {
        XmlParser parser = new XmlParser("<date value=\"2004/12/21 13:52:11\" format=\"yyyy/MM/dd HH:mm:ss\"/>");
        parser.parse();
        Assert.assertEquals((String)"date", (String)parser.getElementName());
        Assert.assertEquals((String)"2004/12/21 13:52:11", (String)parser.getAttribute("value"));
        Assert.assertEquals((String)"yyyy/MM/dd HH:mm:ss", (String)parser.getAttribute("format"));
        parser = new XmlParser("<dAte/>");
        parser.parse();
        Assert.assertEquals((String)"date", (String)parser.getElementName());
        Assert.assertFalse((boolean)parser.hasAttribute("value"));
        Assert.assertFalse((boolean)parser.hasAttribute("format"));
        parser = new XmlParser("<char value \t\r\n= \t\r\n\"1<>&quot;&amp; \n\r\t\"/>");
        parser.parse();
        Assert.assertEquals((String)"char", (String)parser.getElementName());
        Assert.assertEquals((String)"1<>\"& \n\r\t", (String)parser.getAttribute("value"));
    }

    public void testParseNoElementName() {
        try {
            new XmlParser("<hoge=\"\">").parse();
        }
        catch (Exception e) {
            return;
        }
        Assert.fail();
    }

    public void testParseNoAttributeName() {
        try {
            new XmlParser("<hoge =\"\">").parse();
        }
        catch (Exception e) {
            return;
        }
        Assert.fail();
    }

    public void testParseNoAttributeValue() {
        try {
            new XmlParser("<hoge hoge=>").parse();
        }
        catch (Exception e) {
            return;
        }
        Assert.fail();
    }

    public void testParseInvalidXml() {
        try {
            new XmlParser("<hoge>").parse();
        }
        catch (Exception e) {
            return;
        }
        Assert.fail();
    }

    public void testParseInvalidXml2() {
        try {
            new XmlParser("d<hoge/>").parse();
        }
        catch (Exception e) {
            return;
        }
        Assert.fail();
    }

    public void testParseInvalidXml3() {
        try {
            new XmlParser("<hoge").parse();
        }
        catch (Exception e) {
            return;
        }
        Assert.fail();
    }
}

