/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db.data;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import net.yher2.commons.lang.NumberUtils;
import net.yher2.junit.db.data.BooleanColumn;
import net.yher2.junit.db.data.DateColumn;
import net.yher2.junit.db.data.EmptyColumn;
import net.yher2.junit.db.data.IntegerColumn;
import net.yher2.junit.db.data.NumberColumn;
import net.yher2.junit.db.data.StringColumn;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;

public abstract class ColumnData {
    public static ColumnData getInstance(Object value) {
        if (value == null) {
            return new EmptyColumn();
        }
        if (value instanceof Integer) {
            return new IntegerColumn((Integer)value);
        }
        if (value instanceof Double) {
            return new NumberColumn((Double)value);
        }
        if (value instanceof Date) {
            return new DateColumn((Date)value);
        }
        if (value instanceof String) {
            return new StringColumn((String)value);
        }
        if (value instanceof Boolean) {
            return new BooleanColumn((Boolean)value);
        }
        if (value instanceof HSSFCell) {
            return ColumnData.parse((HSSFCell)value);
        }
        throw new IllegalArgumentException("Illegal arguments=" + value);
    }

    private static ColumnData parse(HSSFCell cell) {
        if (cell == null) {
            return new EmptyColumn();
        }
        switch (cell.getCellType()) {
            case 3: {
                return new EmptyColumn();
            }
            case 4: {
                return new BooleanColumn(cell.getBooleanCellValue());
            }
            case 0: {
                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                    return new DateColumn(cell.getDateCellValue());
                }
                if (NumberUtils.isInteger(cell.getNumericCellValue())) {
                    return new IntegerColumn((int)cell.getNumericCellValue());
                }
                return new NumberColumn(cell.getNumericCellValue());
            }
            case 1: {
                return new StringColumn(cell.getStringCellValue().trim());
            }
        }
        throw new IllegalStateException("There is illegal column at line.");
    }

    public abstract Object getValue();

    protected abstract void set(int var1, PreparedStatement var2) throws SQLException;
}

