/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.yher2.commons.io.Path;
import net.yher2.junit.db.data.Table;
import net.yher2.junit.db.excel.ExcelReader;

public class TestDataManager {
    static boolean pool = true;
    static Map dataMap = new HashMap();
    Connection con;

    private static Table[] getTable(Path path) throws IllegalStateException, IOException {
        if (pool) {
            Table[] table = (Table[])dataMap.get(path);
            if (table == null) {
                table = new ExcelReader(path).read();
            }
            return table;
        }
        return new ExcelReader(path).read();
    }

    public static void enablePool() {
        pool = true;
    }

    public static void disablePool() {
        pool = false;
    }

    public TestDataManager(Connection con) {
        this.con = con;
    }

    public void prepare(Path path) throws IOException, SQLException {
        this.deleteExcel(path);
        this.insertExcel(path);
    }

    public void clear(Path path) throws IOException, SQLException {
        this.deleteExcel(path);
    }

    public void insert(Table table) throws SQLException {
        table.insert(this.con);
    }

    public void insertExcel(Path path) throws IOException, SQLException {
        ExcelReader reader = new ExcelReader(path);
        Table[] table = reader.read();
        int i = 0;
        while (i < table.length) {
            this.insert(table[i]);
            ++i;
        }
    }

    public void delete(Table table) throws SQLException {
        table.delete(this.con);
    }

    protected void deleteExcel(Path path) throws IOException, SQLException {
        ExcelReader reader = new ExcelReader(path);
        Table[] table = reader.read();
        int i = table.length - 1;
        while (i >= 0) {
            this.delete(table[i]);
            --i;
        }
    }
}

