/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.transform;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.sql.ParseException;
import org.apache.torque.engine.sql.SQLScanner;
import org.apache.torque.engine.sql.Token;

public class SQLToAppData {
    private String sqlFile;
    private List tokens;
    private Token token;
    private Database appDataDB;
    private int count;
    private String databaseType;

    public SQLToAppData(String sqlFile) {
        this.sqlFile = sqlFile;
    }

    public SQLToAppData(String sqlFile, String databaseType) {
        this.sqlFile = sqlFile;
        this.databaseType = databaseType;
    }

    public String getSqlFile() {
        return this.sqlFile;
    }

    public void setSqlFile(String sqlFile) {
        this.sqlFile = sqlFile;
    }

    private void next() throws ParseException {
        if (this.count >= this.tokens.size()) {
            throw new ParseException("No More Tokens");
        }
        this.token = (Token)this.tokens.get(this.count++);
    }

    private void err(String name) throws ParseException {
        throw new ParseException(name + " at [ line: " + this.token.getLine() + " col: " + this.token.getCol() + " ]");
    }

    private boolean hasTokens() {
        return this.count < this.tokens.size();
    }

    private void create() throws ParseException {
        this.next();
        if (this.token.getStr().toUpperCase().equals("TABLE")) {
            this.create_Table();
        }
    }

    private void create_Table() throws ParseException {
        this.next();
        String tableName = this.token.getStr();
        this.next();
        if (!this.token.getStr().equals("(")) {
            this.err("( expected");
        }
        this.next();
        Table tbl = new Table(tableName);
        while (!this.token.getStr().equals(";")) {
            this.create_Table_Column(tbl);
        }
        if (tbl.getPrimaryKey().size() == 1) {
            tbl.setIdMethod("idbroker");
        } else {
            tbl.setIdMethod("none");
        }
        this.appDataDB.addTable(tbl);
    }

    private void create_Table_Column(Table tbl) throws ParseException {
        if (this.token.getStr().equals(",")) {
            this.next();
        }
        if (this.token.getStr().toUpperCase().equals("PRIMARY")) {
            this.create_Table_Column_Primary(tbl);
        } else if (this.token.getStr().toUpperCase().equals("FOREIGN")) {
            this.create_Table_Column_Foreign(tbl);
        } else if (this.token.getStr().toUpperCase().equals("UNIQUE")) {
            this.create_Table_Column_Unique(tbl);
        } else {
            this.create_Table_Column_Data(tbl);
        }
    }

    private void create_Table_Column_Primary(Table tbl) throws ParseException {
        this.next();
        if (!this.token.getStr().toUpperCase().equals("KEY")) {
            this.err("KEY expected");
        }
        this.next();
        if (!this.token.getStr().toUpperCase().equals("(")) {
            this.err("( expected");
        }
        this.next();
        String colName = this.token.getStr();
        Column c = tbl.getColumn(colName);
        if (c == null) {
            this.err("Invalid column name: " + colName);
        }
        c.setPrimaryKey(true);
        this.next();
        while (this.token.getStr().equals(",")) {
            this.next();
            colName = this.token.getStr();
            c = tbl.getColumn(colName);
            if (c == null) {
                this.err("Invalid column name: " + colName);
            }
            c.setPrimaryKey(true);
            this.next();
        }
        if (!this.token.getStr().toUpperCase().equals(")")) {
            this.err(") expected");
        }
        this.next();
    }

    private void create_Table_Column_Unique(Table tbl) throws ParseException {
        this.next();
        if (!this.token.getStr().toUpperCase().equals("(")) {
            this.err("( expected");
        }
        this.next();
        while (!this.token.getStr().equals(")")) {
            if (!this.token.getStr().equals(",")) {
                String colName = this.token.getStr();
                Column c = tbl.getColumn(colName);
                if (c == null) {
                    this.err("Invalid column name: " + colName);
                }
                c.setUnique(true);
            }
            this.next();
        }
        if (!this.token.getStr().toUpperCase().equals(")")) {
            this.err(") expected got: " + this.token.getStr());
        }
        this.next();
    }

    private void create_Table_Column_Foreign(Table tbl) throws ParseException {
        this.next();
        if (!this.token.getStr().toUpperCase().equals("KEY")) {
            this.err("KEY expected");
        }
        this.next();
        if (!this.token.getStr().toUpperCase().equals("(")) {
            this.err("( expected");
        }
        this.next();
        ForeignKey fk = new ForeignKey();
        ArrayList<String> localColumns = new ArrayList<String>();
        tbl.addForeignKey(fk);
        String colName = this.token.getStr();
        localColumns.add(colName);
        this.next();
        while (this.token.getStr().equals(",")) {
            this.next();
            colName = this.token.getStr();
            localColumns.add(colName);
            this.next();
        }
        if (!this.token.getStr().toUpperCase().equals(")")) {
            this.err(") expected");
        }
        this.next();
        if (!this.token.getStr().toUpperCase().equals("REFERENCES")) {
            this.err("REFERENCES expected");
        }
        this.next();
        fk.setForeignTableName(this.token.getStr());
        this.next();
        if (this.token.getStr().toUpperCase().equals("(")) {
            this.next();
            int i = 0;
            fk.addReference((String)localColumns.get(i++), this.token.getStr());
            this.next();
            while (this.token.getStr().equals(",")) {
                this.next();
                fk.addReference((String)localColumns.get(i++), this.token.getStr());
                this.next();
            }
            if (!this.token.getStr().toUpperCase().equals(")")) {
                this.err(") expected");
            }
            this.next();
        }
    }

    private void create_Table_Column_Data(Table tbl) throws ParseException {
        String columnSize = null;
        String columnPrecision = null;
        String columnDefault = null;
        boolean inEnum = false;
        String columnName = this.token.getStr();
        this.next();
        String columnType = this.token.getStr();
        if (columnName.equals(")") && columnType.equals(";")) {
            return;
        }
        this.next();
        if (columnType.toUpperCase().equals("ENUM")) {
            inEnum = true;
            this.next();
            while (!this.token.getStr().equals(")")) {
                this.next();
            }
            while (!this.token.getStr().equals(",")) {
                if (this.token.getStr().toUpperCase().equals("DEFAULT")) {
                    this.next();
                    if (this.token.getStr().equals("'")) {
                        this.next();
                    }
                    columnDefault = this.token.getStr();
                    this.next();
                    if (this.token.getStr().equals("'")) {
                        this.next();
                    }
                }
                this.next();
            }
            this.next();
            columnType = "VARCHAR";
        } else if (this.token.getStr().toUpperCase().equals("(")) {
            this.next();
            columnSize = this.token.getStr();
            this.next();
            if (this.token.getStr().equals(",")) {
                this.next();
                columnPrecision = this.token.getStr();
                this.next();
            }
            if (!this.token.getStr().equals(")")) {
                this.err(") expected");
            }
            this.next();
        }
        Column col = new Column(columnName);
        if (columnPrecision != null) {
            columnSize = columnSize + columnPrecision;
        }
        col.setTypeFromString(columnType, columnSize);
        tbl.addColumn(col);
        if (inEnum) {
            col.setNotNull(true);
            if (columnDefault != null) {
                col.setDefaultValue(columnDefault);
            }
        } else {
            while (!this.token.getStr().equals(",") && !this.token.getStr().equals(")")) {
                if (this.token.getStr().toUpperCase().equals("NOT")) {
                    this.next();
                    if (!this.token.getStr().toUpperCase().equals("NULL")) {
                        this.err("NULL expected after NOT");
                    }
                    col.setNotNull(true);
                    this.next();
                    continue;
                }
                if (this.token.getStr().toUpperCase().equals("PRIMARY")) {
                    this.next();
                    if (!this.token.getStr().toUpperCase().equals("KEY")) {
                        this.err("KEY expected after PRIMARY");
                    }
                    col.setPrimaryKey(true);
                    this.next();
                    continue;
                }
                if (this.token.getStr().toUpperCase().equals("UNIQUE")) {
                    col.setUnique(true);
                    this.next();
                    continue;
                }
                if (this.token.getStr().toUpperCase().equals("NULL")) {
                    col.setNotNull(false);
                    this.next();
                    continue;
                }
                if (this.token.getStr().toUpperCase().equals("AUTO_INCREMENT")) {
                    col.setAutoIncrement(true);
                    this.next();
                    continue;
                }
                if (!this.token.getStr().toUpperCase().equals("DEFAULT")) continue;
                this.next();
                if (this.token.getStr().equals("'")) {
                    this.next();
                }
                col.setDefaultValue(this.token.getStr());
                this.next();
                if (!this.token.getStr().equals("'")) continue;
                this.next();
            }
            this.next();
        }
    }

    public Database execute() throws IOException, ParseException {
        this.count = 0;
        this.appDataDB = new Database(this.databaseType);
        FileReader fr = new FileReader(this.sqlFile);
        BufferedReader br = new BufferedReader(fr);
        SQLScanner scanner = new SQLScanner(br);
        this.tokens = scanner.scan();
        br.close();
        while (this.hasTokens()) {
            if (this.token == null) {
                this.next();
            }
            if (this.token.getStr().toUpperCase().equals("CREATE")) {
                this.create();
            }
            if (!this.hasTokens()) continue;
            this.next();
        }
        return this.appDataDB;
    }
}

