/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import com.workingdogs.village.TableDataSet;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Criteria;

public abstract class VillageUtils
implements Serializable {
    public static final void close(TableDataSet tds) {
        if (tds != null) {
            try {
                tds.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void close(QueryDataSet qds) {
        if (qds != null) {
            try {
                qds.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] hashtableToByteArray(Hashtable hash) throws Exception {
        Hashtable<String, Object> saveData = new Hashtable<String, Object>(hash.size());
        String key = null;
        Object value = null;
        byte[] byteArray = null;
        Iterator keys = hash.keySet().iterator();
        while (keys.hasNext()) {
            key = (String)keys.next();
            value = hash.get(key);
            if (!(value instanceof Serializable)) continue;
            saveData.put(key, value);
        }
        ByteArrayOutputStream baos = null;
        BufferedOutputStream bos = null;
        ObjectOutputStream out = null;
        try {
            baos = new ByteArrayOutputStream();
            bos = new BufferedOutputStream(baos);
            out = new ObjectOutputStream(bos);
            out.writeObject(saveData);
            out.flush();
            bos.flush();
            baos.flush();
            byteArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            VillageUtils.close(out);
            VillageUtils.close(bos);
            VillageUtils.close(baos);
            throw throwable;
        }
        VillageUtils.close(out);
        VillageUtils.close(bos);
        VillageUtils.close(baos);
        return byteArray;
    }

    public static final void setVillageValue(Criteria crit, String key, Record rec, String colName) throws Exception {
        Object obj = crit.getValue(key);
        if (obj instanceof SimpleKey) {
            obj = ((SimpleKey)obj).getValue();
        }
        if (obj == null) {
            rec.setValueNull(colName);
        } else if (obj instanceof String) {
            rec.setValue(colName, (String)obj);
        } else if (obj instanceof Integer) {
            rec.setValue(colName, crit.getInt(key));
        } else if (obj instanceof BigDecimal) {
            rec.setValue(colName, (BigDecimal)obj);
        } else if (obj instanceof Boolean) {
            rec.setValue(colName, ((Boolean)obj).booleanValue());
        } else if (obj instanceof Date) {
            rec.setValue(colName, (Date)obj);
        } else if (obj instanceof Float) {
            rec.setValue(colName, crit.getFloat(key));
        } else if (obj instanceof Double) {
            rec.setValue(colName, crit.getDouble(key));
        } else if (obj instanceof Byte) {
            rec.setValue(colName, (int)((Byte)obj).byteValue());
        } else if (obj instanceof Long) {
            rec.setValue(colName, crit.getLong(key));
        } else if (obj instanceof Short) {
            rec.setValue(colName, (int)((Short)obj).shortValue());
        } else if (obj instanceof Hashtable) {
            rec.setValue(colName, VillageUtils.hashtableToByteArray((Hashtable)obj));
        } else if (obj instanceof byte[]) {
            rec.setValue(colName, (byte[])obj);
        }
    }
}

