/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.Blob;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SignedBinary;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.Typdef;

public class NetCursor
extends Cursor {
    NetResultSet netResultSet_;
    NetAgent netAgent_;
    Typdef qrydscTypdef_;
    int targetSqlamForTypdef_;
    int numMddOverrides_;
    int maximumRowSize_;
    boolean blocking_;
    int[] typeToUseForComputingDataLength_;
    boolean[] isGraphic_;
    HashMap extdtaPositions_;
    ArrayList extdtaData_;
    boolean rtnextrow_ = true;

    NetCursor(NetAgent netAgent) {
        super(netAgent);
        this.netAgent_ = netAgent;
        this.numMddOverrides_ = 0;
        this.maximumRowSize_ = 0;
        this.extdtaPositions_ = new HashMap();
        this.extdtaData_ = new ArrayList();
    }

    NetCursor(NetAgent netAgent, int n) {
        this(netAgent);
        if (n == 9240) {
            this.blocking_ = false;
        } else if (n == 9239) {
            this.blocking_ = true;
        }
    }

    protected boolean calculateColumnOffsetsForRow_(int n) throws SqlException, DisconnectException {
        int n2;
        int n3 = 255;
        int n4 = 255;
        if (this.hasLobs_) {
            this.extdtaPositions_.clear();
        }
        int[] nArray = null;
        int[] nArray2 = null;
        boolean[] blArray = null;
        if (this.position_ == this.lastValidBytePosition_ && this.netResultSet_ != null && this.netResultSet_.scrollable_) {
            return false;
        }
        NetSqlca netSqlca = this.parseSQLCARD(this.qrydscTypdef_);
        if (netSqlca != null) {
            n2 = netSqlca.getSqlCode();
            if (n2 < 0) {
                throw new SqlException(this.netAgent_.logWriter_, netSqlca);
            }
            if (n2 > 0) {
                if (n2 == 100) {
                    this.allRowsReceivedFromServer_ = true;
                    if (this.netResultSet_ != null && netSqlca.containsSqlcax()) {
                        this.netResultSet_.setRowCountEvent(netSqlca.getRowCount(this.qrydscTypdef_));
                    }
                } else if (this.netResultSet_ != null) {
                    this.netResultSet_.accumulateWarning(new SqlWarning(this.agent_.logWriter_, netSqlca));
                }
            }
        }
        n3 = this.readFdocaOneByte();
        if (this.allRowsReceivedFromServer_ && this.position_ == this.lastValidBytePosition_) {
            this.markNextRowPosition();
            this.makeNextRowPositionCurrent();
            return false;
        }
        if (n3 == 0) {
            this.incrementRowsReadEvent();
            if (this.netResultSet_ != null && this.netResultSet_.scrollable_) {
                nArray = this.allocateColumnDataPositionArray(n);
                nArray2 = this.allocateColumnDataComputedLengthArray(n);
                blArray = this.allocateColumnDataIsNullArray(n);
                this.setIsUpdataDeleteHole(n, false);
            } else {
                if (this.columnDataPosition_ == null || this.columnDataComputedLength_ == null || this.isNull_ == null) {
                    this.allocateColumnOffsetAndLengthArrays();
                }
                nArray = this.columnDataPosition_;
                nArray2 = this.columnDataComputedLength_;
                blArray = this.isNull_;
            }
            for (n2 = 0; n2 < this.columns_; ++n2) {
                if (this.nullable_[n2]) {
                    n4 = this.readFdocaOneByte(n2);
                }
                if (!this.nullable_[n2] || n4 >= 0 && n4 <= 127) {
                    blArray[n2] = false;
                    switch (this.typeToUseForComputingDataLength_[n2]) {
                        case 0: {
                            nArray[n2] = this.position_;
                            if (this.isGraphic_[n2]) {
                                nArray2[n2] = this.skipFdocaBytes(this.fdocaLength_[n2] * 2, n2);
                                break;
                            }
                            nArray2[n2] = this.skipFdocaBytes(this.fdocaLength_[n2], n2);
                            break;
                        }
                        case 1: {
                            nArray[n2] = this.position_;
                            int n5 = this.readFdocaTwoByteLength(n2);
                            if (this.isGraphic_[n2]) {
                                nArray2[n2] = this.skipFdocaBytes(n5 * 2, n2) + 2;
                                break;
                            }
                            nArray2[n2] = this.skipFdocaBytes(n5, n2) + 2;
                            break;
                        }
                        case 3: {
                            nArray[n2] = this.position_;
                            nArray2[n2] = this.skipFdocaBytes(this.getDecimalLength(n2), n2);
                            break;
                        }
                        case 4: {
                            nArray[n2] = this.position_;
                            nArray2[n2] = this.skipFdocaBytes(this.fdocaLength_[n2] & Short.MAX_VALUE, n2);
                            break;
                        }
                        case 2: {
                            nArray[n2] = this.position_;
                            int n5 = this.readFdocaOneByte(n2);
                            if (this.isGraphic_[n2]) {
                                nArray2[n2] = this.skipFdocaBytes(n5 * 2, n2) + 1;
                                break;
                            }
                            nArray2[n2] = this.skipFdocaBytes(n5, n2) + 1;
                            break;
                        }
                        default: {
                            nArray[n2] = this.position_;
                            if (this.isGraphic_[n2]) {
                                nArray2[n2] = this.skipFdocaBytes(this.fdocaLength_[n2] * 2, n2);
                                break;
                            }
                            nArray2[n2] = this.skipFdocaBytes(this.fdocaLength_[n2], n2);
                            break;
                        }
                    }
                    continue;
                }
                if ((n4 & 0x80) != 128) continue;
                blArray[n2] = true;
            }
            this.columnDataPosition_ = nArray;
            this.columnDataComputedLength_ = nArray2;
            this.isNull_ = blArray;
            if (!this.allRowsReceivedFromServer_) {
                this.calculateLobColumnPositionsForRow();
                if (this.blocking_ && this.rtnextrow_ && this.extdtaPositions_.size() > 0 && !this.netResultSet_.scrollable_ && !this.extdtaPositions_.isEmpty()) {
                    this.netResultSet_.flowFetch();
                }
            }
        } else if (this.netResultSet_ != null && this.netResultSet_.scrollable_) {
            this.setIsUpdataDeleteHole(n, true);
        }
        return this.blocking_ || !this.allRowsReceivedFromServer_ || n3 != 255;
    }

    protected boolean isDataBufferNull() {
        return this.dataBuffer_ == null;
    }

    protected void allocateDataBuffer() {
        int n = this.maximumRowSize_ > Short.MAX_VALUE ? this.maximumRowSize_ : Short.MAX_VALUE;
        this.dataBuffer_ = new byte[n];
        this.position_ = 0;
        this.lastValidBytePosition_ = 0;
    }

    protected void allocateDataBuffer(int n) {
        this.dataBuffer_ = new byte[n];
    }

    private int readFdocaInt() throws DisconnectException, SqlException {
        int n;
        if (this.position_ + 4 > this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            n = this.completeSplitRow();
            this.checkAndThrowReceivedEndqryrm(n);
        }
        n = SignedBinary.getInt(this.dataBuffer_, this.position_);
        this.position_ += 4;
        return n;
    }

    private int readFdocaOneByte() throws DisconnectException, SqlException {
        if (this.position_ == this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            int n = this.completeSplitRow();
            this.checkAndThrowReceivedEndqryrm(n);
        }
        return this.dataBuffer_[this.position_++] & 0xFF;
    }

    private int readFdocaOneByte(int n) throws DisconnectException, SqlException {
        if (this.position_ == this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            int n2 = this.completeSplitRow(n);
            this.checkAndThrowReceivedEndqryrm(n2);
        }
        return this.dataBuffer_[this.position_++] & 0xFF;
    }

    private byte[] readFdocaBytes(int n) throws DisconnectException, SqlException {
        int n2;
        byte[] byArray = new byte[n];
        if (this.position_ + n > this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            n2 = this.completeSplitRow();
            this.checkAndThrowReceivedEndqryrm(n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = this.dataBuffer_[this.position_++];
        }
        return byArray;
    }

    private int readFdocaTwoByteLength() throws DisconnectException, SqlException {
        if (this.position_ + 2 > this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            int n = this.completeSplitRow();
            this.checkAndThrowReceivedEndqryrm(n);
        }
        return ((this.dataBuffer_[this.position_++] & 0xFF) << 8) + ((this.dataBuffer_[this.position_++] & 0xFF) << 0);
    }

    private int readFdocaTwoByteLength(int n) throws DisconnectException, SqlException {
        if (this.position_ + 2 > this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            int n2 = this.completeSplitRow(n);
            this.checkAndThrowReceivedEndqryrm(n2);
        }
        return ((this.dataBuffer_[this.position_++] & 0xFF) << 8) + ((this.dataBuffer_[this.position_++] & 0xFF) << 0);
    }

    private int skipFdocaBytes(int n) throws DisconnectException, SqlException {
        if (this.position_ + n > this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            int n2 = this.completeSplitRow();
            this.checkAndThrowReceivedEndqryrm(n2);
        }
        this.position_ += n;
        return n;
    }

    private int skipFdocaBytes(int n, int n2) throws DisconnectException, SqlException {
        if (this.position_ + n > this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            int n3 = this.completeSplitRow(n2);
            this.checkAndThrowReceivedEndqryrm(n3);
        }
        this.position_ += n;
        return n;
    }

    private void shiftPartialRowToBeginning() {
        int n = this.lastValidBytePosition_ - this.currentRowPosition_;
        this.dataBufferStream_.reset();
        if (this.dataBuffer_ != null) {
            this.dataBufferStream_.write(this.dataBuffer_, this.currentRowPosition_, n);
        }
        for (int i = 0; i < n; ++i) {
            this.dataBuffer_[i] = this.dataBuffer_[this.currentRowPosition_ + i];
        }
        this.position_ = n - (this.lastValidBytePosition_ - this.position_);
        this.lastValidBytePosition_ = n;
    }

    private void adjustColumnOffsetsForColumnsPreviouslyCalculated(int n) {
        int n2 = 0;
        while (n2 <= n) {
            int n3 = n2++;
            this.columnDataPosition_[n3] = this.columnDataPosition_[n3] - this.currentRowPosition_;
        }
    }

    private void resetCurrentRowPosition() {
        this.currentRowPosition_ = 0;
    }

    void calculateLobColumnPositionsForRow() {
        int n = 0;
        for (int i = 0; i < this.columns_; ++i) {
            if (!this.isNonTrivialDataLob(i)) continue;
            this.extdtaPositions_.put(new Integer(i + 1), new Integer(n++));
        }
    }

    boolean isNonTrivialDataLob(int n) {
        long l = 0L;
        if (this.isNull_[n] || this.jdbcTypes_[n] != 2004 && this.jdbcTypes_[n] != 2005) {
            return false;
        }
        int n2 = this.columnDataPosition_[n];
        if ((this.dataBuffer_[n2] & 0x80) == 128) {
            l = -1L;
        } else {
            byte[] byArray = new byte[this.columnDataComputedLength_[n]];
            byte[] byArray2 = new byte[8];
            System.arraycopy(this.dataBuffer_, n2, byArray, 0, this.columnDataComputedLength_[n]);
            int n3 = 0;
            for (int i = 8 - this.columnDataComputedLength_[n]; i < 8; ++i) {
                byArray2[i] = byArray[n3];
                ++n3;
            }
            l = SignedBinary.getLong(byArray2, 0);
        }
        return l != 0L;
    }

    protected void clearLobData_() {
        this.extdtaData_.clear();
        this.extdtaPositions_.clear();
    }

    NetSqlca parseSQLCARD(Typdef typdef) throws DisconnectException, SqlException {
        return this.parseSQLCAGRP(typdef);
    }

    private NetSqlca parseSQLCAGRP(Typdef typdef) throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return null;
        }
        int n = this.readFdocaInt();
        byte[] byArray = this.readFdocaBytes(5);
        byte[] byArray2 = this.readFdocaBytes(8);
        NetSqlca netSqlca = new NetSqlca(this.netAgent_.netConnection_, n, byArray, byArray2, typdef.getCcsidSbc());
        this.parseSQLCAXGRP(typdef, netSqlca);
        this.parseSQLDIAGGRP();
        return netSqlca;
    }

    private void parseSQLCAXGRP(Typdef typdef, NetSqlca netSqlca) throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            netSqlca.setContainsSqlcax(false);
            return;
        }
        int[] nArray = new int[6];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.readFdocaInt();
        }
        byte[] byArray = this.readFdocaBytes(11);
        this.parseVCS(typdef);
        int n = this.readFdocaTwoByteLength();
        byte[] byArray2 = null;
        int n2 = 0;
        if (n != 0) {
            byArray2 = this.readFdocaBytes(n);
            n2 = typdef.getCcsidMbc();
            this.skipFdocaBytes(2);
        } else {
            n = this.readFdocaTwoByteLength();
            byArray2 = this.readFdocaBytes(n);
            n2 = typdef.getCcsidSbc();
        }
        netSqlca.setSqlerrd(nArray);
        netSqlca.setSqlwarnBytes(byArray);
        netSqlca.setSqlerrmcBytes(byArray2, n2);
    }

    private void parseSQLDIAGGRP() throws DisconnectException, SqlException {
        if (this.readFdocaOneByte() == 255) {
            return;
        }
        this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException((Agent)this.netAgent_, "parseSQLDIAGGRP not yet implemented"));
    }

    private String parseVCS(Typdef typdef) throws DisconnectException, SqlException {
        return this.readFdocaString(this.readFdocaTwoByteLength(), typdef.getCcsidSbcEncoding());
    }

    private String readFdocaString(int n, String string) throws DisconnectException, SqlException {
        if (n == 0) {
            return null;
        }
        if (this.position_ + n > this.lastValidBytePosition_) {
            this.checkAndThrowReceivedEndqryrm();
            int n2 = this.completeSplitRow();
            this.checkAndThrowReceivedEndqryrm(n2);
        }
        String string2 = null;
        try {
            string2 = new String(this.dataBuffer_, this.position_, n, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.netAgent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(unsupportedEncodingException, this.netAgent_, "encoding not supported!!"));
        }
        this.position_ += n;
        return string2;
    }

    void allocateColumnOffsetAndLengthArrays() {
        this.columnDataPosition_ = new int[this.columns_];
        this.columnDataComputedLength_ = new int[this.columns_];
        this.isNull_ = new boolean[this.columns_];
    }

    void setBlocking(int n) {
        this.blocking_ = n == 9239;
    }

    protected byte[] findExtdtaData(int n) {
        byte[] byArray = null;
        Integer n2 = new Integer(n);
        if (this.extdtaPositions_.containsKey(n2)) {
            int n3 = (Integer)this.extdtaPositions_.get(n2);
            byArray = (byte[])this.extdtaData_.get(n3);
        }
        return byArray;
    }

    public Blob getBlobColumn_(int n, Agent agent) throws SqlException {
        int n2 = n - 1;
        Blob blob = null;
        byte[] byArray = this.findExtdtaData(n);
        if (byArray != null) {
            int n3 = !this.nullable_[n2] ? 0 : 1;
            blob = new Blob(byArray, agent, n3);
        } else {
            blob = new Blob(new byte[0], agent, 0);
        }
        return blob;
    }

    public Clob getClobColumn_(int n, Agent agent) throws SqlException {
        int n2 = n - 1;
        Clob clob = null;
        byte[] byArray = this.findExtdtaData(n);
        if (byArray != null) {
            int n3 = !this.nullable_[n2] ? 0 : 1;
            clob = new Clob(agent, byArray, this.charsetName_[n2], n3);
        } else {
            clob = new Clob(agent, "");
        }
        return clob;
    }

    public byte[] getClobBytes_(int n, int[] nArray) throws SqlException {
        int n2 = n - 1;
        byte[] byArray = null;
        byArray = this.findExtdtaData(n);
        if (byArray != null) {
            nArray[0] = !this.nullable_[n2] ? 0 : 1;
        }
        return byArray;
    }

    void initializeColumnInfoArrays(Typdef typdef, int n, int n2) throws DisconnectException {
        this.qrydscTypdef_ = typdef;
        this.setNumberOfColumns(n);
        this.fdocaLength_ = new int[n];
        this.isGraphic_ = new boolean[n];
        this.typeToUseForComputingDataLength_ = new int[n];
        this.targetSqlamForTypdef_ = n2;
    }

    int ensureSpaceForDataBuffer(int n) {
        int n2;
        if (this.dataBuffer_ == null) {
            this.allocateDataBuffer();
        }
        if ((n2 = this.dataBuffer_.length - this.lastValidBytePosition_) < n) {
            int n3;
            for (n3 = 2 * this.dataBuffer_.length; n3 < n; n3 = 2 * n3) {
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.dataBuffer_, 0, byArray, 0, this.lastValidBytePosition_);
            this.dataBuffer_ = byArray;
            n2 = this.dataBuffer_.length - this.lastValidBytePosition_;
        }
        return n2;
    }

    protected void getMoreData_() throws SqlException {
        if (this.netResultSet_.resultSetType_ == 1003) {
            this.resetDataBuffer();
        }
        this.netResultSet_.flowFetch();
    }

    public void nullDataForGC() {
        super.nullDataForGC();
        this.qrydscTypdef_ = null;
        this.typeToUseForComputingDataLength_ = null;
        this.isGraphic_ = null;
        if (this.extdtaPositions_ != null) {
            this.extdtaPositions_.clear();
        }
        this.extdtaPositions_ = null;
        if (this.extdtaData_ != null) {
            this.extdtaData_.clear();
        }
        this.extdtaData_ = null;
    }

    private void checkAndThrowReceivedEndqryrm() throws SqlException {
        if (!this.netResultSet_.openOnServer_) {
            SqlException sqlException = null;
            int n = Utils.getSqlcodeFromSqlca(this.netResultSet_.queryTerminatingSqlca_);
            sqlException = n < 0 ? new SqlException(this.agent_.logWriter_, this.netResultSet_.queryTerminatingSqlca_) : new SqlException(this.agent_.logWriter_, "Query processing has been terminated due to error on the server.");
            try {
                this.netResultSet_.closeX();
            }
            catch (SqlException sqlException2) {
                sqlException.setNextException(sqlException2);
            }
            throw sqlException;
        }
    }

    private void checkAndThrowReceivedEndqryrm(int n) throws SqlException {
        if (this.lastValidBytePosition_ > n) {
            return;
        }
        this.checkAndThrowReceivedEndqryrm();
    }

    private int completeSplitRow() throws DisconnectException, SqlException {
        int n = 0;
        if (this.netResultSet_ != null && this.netResultSet_.scrollable_) {
            n = this.lastValidBytePosition_;
            this.netResultSet_.flowFetchToCompleteRowset();
        } else {
            this.shiftPartialRowToBeginning();
            this.resetCurrentRowPosition();
            n = this.lastValidBytePosition_;
            this.netResultSet_.flowFetch();
        }
        return n;
    }

    private int completeSplitRow(int n) throws DisconnectException, SqlException {
        int n2 = 0;
        if (this.netResultSet_ != null && this.netResultSet_.scrollable_) {
            n2 = this.lastValidBytePosition_;
            this.netResultSet_.flowFetchToCompleteRowset();
        } else {
            this.shiftPartialRowToBeginning();
            this.adjustColumnOffsetsForColumnsPreviouslyCalculated(n);
            this.resetCurrentRowPosition();
            n2 = this.lastValidBytePosition_;
            this.netResultSet_.flowFetch();
        }
        return n2;
    }

    private int[] allocateColumnDataPositionArray(int n) {
        int[] nArray;
        if (this.columnDataPositionCache_.size() == n) {
            nArray = new int[this.columns_];
            this.columnDataPositionCache_.add(nArray);
        } else {
            nArray = (int[])this.columnDataPositionCache_.get(n);
        }
        return nArray;
    }

    private int[] allocateColumnDataComputedLengthArray(int n) {
        int[] nArray;
        if (this.columnDataLengthCache_.size() == n) {
            nArray = new int[this.columns_];
            this.columnDataLengthCache_.add(nArray);
        } else {
            nArray = (int[])this.columnDataLengthCache_.get(n);
        }
        return nArray;
    }

    private boolean[] allocateColumnDataIsNullArray(int n) {
        boolean[] blArray;
        if (this.columnDataIsNullCache_.size() <= n) {
            blArray = new boolean[this.columns_];
            this.columnDataIsNullCache_.add(blArray);
        } else {
            blArray = (boolean[])this.columnDataIsNullCache_.get(n);
        }
        return blArray;
    }

    protected int getDecimalLength(int n) {
        return ((this.fdocaLength_[n] >> 8 & 0xFF) + 2) / 2;
    }
}

